/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.internal;

import java.lang.reflect.Constructor;
import org.hibernate.PropertyNotFoundException;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.metamodel.internal.AbstractPojoInstantiator;
import org.hibernate.type.descriptor.java.JavaType;

public class PojoInstantiatorImpl<J>
extends AbstractPojoInstantiator {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(PojoInstantiatorImpl.class);
    private final Constructor<?> constructor = this.isAbstract() ? null : PojoInstantiatorImpl.resolveConstructor(this.getMappedPojoClass());

    public PojoInstantiatorImpl(JavaType javaType) {
        super(javaType.getJavaTypeClass());
    }

    protected static Constructor<?> resolveConstructor(Class<?> mappedPojoClass) {
        try {
            return ReflectHelper.getDefaultConstructor(mappedPojoClass);
        }
        catch (PropertyNotFoundException e) {
            LOG.noDefaultConstructor(mappedPojoClass.getName());
            return null;
        }
    }

    protected Object applyInterception(Object entity) {
        return entity;
    }
}

