/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping;

import org.hibernate.Internal;
import org.hibernate.Session;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.mapping.GeneratedValueResolver;
import org.hibernate.tuple.GenerationTiming;
import org.hibernate.tuple.ValueGenerator;

@Internal
public class InMemoryGeneratedValueResolver
implements GeneratedValueResolver {
    private final GenerationTiming generationTiming;
    private final ValueGenerator valueGenerator;

    public InMemoryGeneratedValueResolver(ValueGenerator valueGenerator, GenerationTiming generationTiming) {
        this.valueGenerator = valueGenerator;
        this.generationTiming = generationTiming;
    }

    @Override
    public GenerationTiming getGenerationTiming() {
        return this.generationTiming;
    }

    @Override
    public Object resolveGeneratedValue(Object[] row, Object entity, SharedSessionContractImplementor session) {
        return this.valueGenerator.generateValue((Session)((Object)session), entity);
    }
}

