/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import org.hibernate.bytecode.spi.ReflectionOptimizer;
import org.hibernate.mapping.Property;
import org.hibernate.metamodel.RepresentationMode;
import org.hibernate.metamodel.internal.EmbeddableInstantiatorPojoStandard;
import org.hibernate.metamodel.mapping.internal.IdClassEmbeddable;
import org.hibernate.metamodel.spi.EmbeddableInstantiator;
import org.hibernate.metamodel.spi.EmbeddableRepresentationStrategy;
import org.hibernate.property.access.internal.PropertyAccessStrategyMixedImpl;
import org.hibernate.property.access.spi.PropertyAccess;
import org.hibernate.type.descriptor.java.JavaType;

public class IdClassRepresentationStrategy
implements EmbeddableRepresentationStrategy {
    private final JavaType<?> idClassType;
    private final EmbeddableInstantiator instantiator;

    public IdClassRepresentationStrategy(IdClassEmbeddable idClassEmbeddable) {
        this.idClassType = idClassEmbeddable.getMappedJavaType();
        this.instantiator = new EmbeddableInstantiatorPojoStandard(this.idClassType, () -> idClassEmbeddable);
    }

    @Override
    public EmbeddableInstantiator getInstantiator() {
        return this.instantiator;
    }

    @Override
    public RepresentationMode getMode() {
        return RepresentationMode.POJO;
    }

    @Override
    public ReflectionOptimizer getReflectionOptimizer() {
        return null;
    }

    @Override
    public JavaType<?> getMappedJavaType() {
        return this.idClassType;
    }

    @Override
    public PropertyAccess resolvePropertyAccess(Property bootAttributeDescriptor) {
        return PropertyAccessStrategyMixedImpl.INSTANCE.buildPropertyAccess((Class)this.idClassType.getJavaTypeClass(), bootAttributeDescriptor.getName(), true);
    }
}

