/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.internal;

import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.query.spi.DomainQueryExecutionContext;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.query.spi.SqlOmittingQueryOptions;
import org.hibernate.sql.exec.spi.Callback;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcSelect;

public class SqmJdbcExecutionContextAdapter
implements ExecutionContext {
    private final DomainQueryExecutionContext sqmExecutionContext;
    private final QueryOptions queryOptions;

    public static SqmJdbcExecutionContextAdapter omittingLockingAndPaging(DomainQueryExecutionContext sqmExecutionContext) {
        return new SqmJdbcExecutionContextAdapter(sqmExecutionContext);
    }

    public static SqmJdbcExecutionContextAdapter usingLockingAndPaging(DomainQueryExecutionContext sqmExecutionContext) {
        return new SqmJdbcExecutionContextAdapter(sqmExecutionContext, sqmExecutionContext.getQueryOptions());
    }

    private SqmJdbcExecutionContextAdapter(DomainQueryExecutionContext sqmExecutionContext) {
        this(sqmExecutionContext, SqlOmittingQueryOptions.omitSqlQueryOptions(sqmExecutionContext.getQueryOptions()));
    }

    private SqmJdbcExecutionContextAdapter(DomainQueryExecutionContext sqmExecutionContext, QueryOptions queryOptions) {
        this.sqmExecutionContext = sqmExecutionContext;
        this.queryOptions = queryOptions;
    }

    public SqmJdbcExecutionContextAdapter(DomainQueryExecutionContext sqmExecutionContext, JdbcSelect jdbcSelect) {
        this(sqmExecutionContext, SqlOmittingQueryOptions.omitSqlQueryOptions(sqmExecutionContext.getQueryOptions(), jdbcSelect));
    }

    @Override
    public SharedSessionContractImplementor getSession() {
        return this.sqmExecutionContext.getSession();
    }

    @Override
    public QueryOptions getQueryOptions() {
        return this.queryOptions;
    }

    @Override
    public QueryParameterBindings getQueryParameterBindings() {
        return this.sqmExecutionContext.getQueryParameterBindings();
    }

    @Override
    public Callback getCallback() {
        return this.sqmExecutionContext.getCallback();
    }

    @Override
    public boolean hasQueryExecutionToBeAddedToStatistics() {
        return true;
    }

    @Override
    public String getQueryIdentifier(String sql) {
        return sql;
    }
}

