/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.entity;

import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.StaleObjectStateException;
import org.hibernate.WrongClassException;
import org.hibernate.bytecode.enhance.spi.LazyPropertyInitializer;
import org.hibernate.bytecode.enhance.spi.interceptor.EnhancementAsProxyLazinessInterceptor;
import org.hibernate.cache.spi.access.EntityDataAccess;
import org.hibernate.cache.spi.entry.CacheEntry;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.EntityUniqueKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.PersistentAttributeInterceptable;
import org.hibernate.engine.spi.PersistentAttributeInterceptor;
import org.hibernate.engine.spi.SessionEventListenerManager;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.spi.Status;
import org.hibernate.event.service.spi.EventListenerGroup;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.PreLoadEvent;
import org.hibernate.event.spi.PreLoadEventListener;
import org.hibernate.internal.log.LoggingHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.loader.entity.CacheEntityLoaderHelper;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.metamodel.mapping.EntityValuedModelPart;
import org.hibernate.metamodel.mapping.EntityVersionMapping;
import org.hibernate.metamodel.mapping.ManagedMappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.UniqueKeyLoadable;
import org.hibernate.property.access.internal.PropertyAccessStrategyBackRefImpl;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.proxy.map.MapProxy;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.results.graph.AbstractFetchParentAccess;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.Fetchable;
import org.hibernate.sql.results.graph.Initializer;
import org.hibernate.sql.results.graph.basic.BasicResultAssembler;
import org.hibernate.sql.results.graph.entity.EntityInitializer;
import org.hibernate.sql.results.graph.entity.EntityLoadingLogging;
import org.hibernate.sql.results.graph.entity.EntityResultGraphNode;
import org.hibernate.sql.results.graph.entity.LoadingEntityEntry;
import org.hibernate.sql.results.graph.entity.internal.EntityResultInitializer;
import org.hibernate.sql.results.internal.NullValueAssembler;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesSourceProcessingState;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;
import org.hibernate.stat.spi.StatisticsImplementor;
import org.hibernate.type.AssociationType;
import org.hibernate.type.BasicType;
import org.hibernate.type.Type;

public abstract class AbstractEntityInitializer
extends AbstractFetchParentAccess
implements EntityInitializer {
    private final EntityValuedModelPart referencedModelPart;
    private final EntityPersister entityDescriptor;
    private final EntityPersister rootEntityDescriptor;
    private final NavigablePath navigablePath;
    private final LockMode lockMode;
    private final DomainResultAssembler identifierAssembler;
    private final BasicResultAssembler discriminatorAssembler;
    private final DomainResultAssembler versionAssembler;
    private final DomainResultAssembler<Object> rowIdAssembler;
    private final Map<AttributeMapping, DomainResultAssembler> assemblerMap;
    private EntityPersister concreteDescriptor;
    private EntityKey entityKey;
    private Object entityInstance;
    private Object entityInstanceForNotify;
    private boolean missing;
    boolean isInitialized;
    private boolean isOwningInitializer;
    private Object[] resolvedEntityState;

    protected AbstractEntityInitializer(EntityResultGraphNode resultDescriptor, NavigablePath navigablePath, LockMode lockMode, Fetch identifierFetch, Fetch discriminatorFetch, DomainResult<Object> rowIdResult, AssemblerCreationState creationState) {
        this.referencedModelPart = resultDescriptor.getEntityValuedModelPart();
        this.entityDescriptor = (EntityPersister)this.referencedModelPart.getEntityMappingType();
        String rootEntityName = this.entityDescriptor.getRootEntityName();
        this.rootEntityDescriptor = rootEntityName == null || rootEntityName.equals(this.entityDescriptor.getEntityName()) ? this.entityDescriptor : this.entityDescriptor.getRootEntityDescriptor().getEntityPersister();
        this.navigablePath = navigablePath;
        this.lockMode = lockMode;
        assert (lockMode != null);
        this.identifierAssembler = identifierFetch != null ? identifierFetch.createAssembler(this, creationState) : null;
        this.discriminatorAssembler = discriminatorFetch != null ? (BasicResultAssembler)discriminatorFetch.createAssembler(this, creationState) : null;
        EntityVersionMapping versionMapping = this.entityDescriptor.getVersionMapping();
        if (versionMapping != null) {
            Fetch versionFetch = resultDescriptor.findFetch(versionMapping);
            assert (versionFetch != null);
            this.versionAssembler = versionFetch.createAssembler(this, creationState);
        } else {
            this.versionAssembler = null;
        }
        this.rowIdAssembler = rowIdResult != null ? rowIdResult.createResultAssembler(this, creationState) : null;
        this.assemblerMap = new IdentityHashMap<AttributeMapping, DomainResultAssembler>(this.entityDescriptor.getNumberOfAttributeMappings());
        this.entityDescriptor.visitFetchables(fetchable -> {
            AttributeMapping attributeMapping = (AttributeMapping)fetchable;
            Fetch fetch = resultDescriptor.findFetch((Fetchable)fetchable);
            DomainResultAssembler<?> stateAssembler = fetch == null ? new NullValueAssembler(attributeMapping.getMappedType().getMappedJavaType()) : fetch.createAssembler(this, creationState);
            this.assemblerMap.put(attributeMapping, stateAssembler);
        }, null);
    }

    private static void deepCopy(ManagedMappingType containerDescriptor, Object[] source, Object[] target, EntityPersister concreteDescriptor) {
        containerDescriptor.visitAttributeMappings(attributeMapping -> {
            if (attributeMapping.getAttributeMetadataAccess().resolveAttributeMetadata(concreteDescriptor).isUpdatable()) {
                int position = attributeMapping.getStateArrayPosition();
                Object result = source[position] == LazyPropertyInitializer.UNFETCHED_PROPERTY || source[position] == PropertyAccessStrategyBackRefImpl.UNKNOWN ? source[position] : attributeMapping.getAttributeMetadataAccess().resolveAttributeMetadata(null).getMutabilityPlan().deepCopy(source[position]);
                target[position] = result;
            }
        });
    }

    @Override
    public ModelPart getInitializedPart() {
        return this.referencedModelPart;
    }

    protected abstract String getSimpleConcreteImplName();

    @Override
    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    protected boolean isMissing() {
        return this.missing;
    }

    protected abstract boolean isEntityReturn();

    @Override
    public EntityPersister getEntityDescriptor() {
        return this.entityDescriptor;
    }

    @Override
    public Object getEntityInstance() {
        return this.entityInstance;
    }

    public Object getKeyValue() {
        if (this.entityKey == null) {
            return null;
        }
        return this.entityKey.getIdentifier();
    }

    @Override
    public EntityKey getEntityKey() {
        return this.entityKey;
    }

    @Override
    public Object getParentKey() {
        return this.getKeyValue();
    }

    @Override
    public void registerResolutionListener(Consumer<Object> listener) {
        if (this.entityInstanceForNotify != null) {
            listener.accept(this.entityInstanceForNotify);
            return;
        }
        super.registerResolutionListener(listener);
    }

    @Override
    public void resolveKey(RowProcessingState rowProcessingState) {
        if (this.entityKey != null) {
            return;
        }
        if (EntityLoadingLogging.TRACE_ENABLED) {
            EntityLoadingLogging.ENTITY_LOADING_LOGGER.tracef("(%s) Beginning Initializer#resolveKey process for entity : %s", (Object)StringHelper.collapse(this.getClass().getName()), (Object)this.getNavigablePath());
        }
        SharedSessionContractImplementor session = rowProcessingState.getJdbcValuesSourceProcessingState().getSession();
        this.concreteDescriptor = this.determineConcreteEntityDescriptor(rowProcessingState, session);
        if (this.concreteDescriptor == null) {
            this.missing = true;
            return;
        }
        this.resolveEntityKey(rowProcessingState);
        if (this.entityKey == null) {
            EntityLoadingLogging.ENTITY_LOADING_LOGGER.debugf("(%s) EntityKey (%s) is null", (Object)this.getSimpleConcreteImplName(), (Object)this.getNavigablePath());
            assert (this.missing);
            return;
        }
        if (EntityLoadingLogging.DEBUG_ENABLED) {
            EntityLoadingLogging.ENTITY_LOADING_LOGGER.debugf("(%s) Hydrated EntityKey (%s): %s", (Object)this.getSimpleConcreteImplName(), (Object)this.getNavigablePath(), this.entityKey.getIdentifier());
        }
    }

    private EntityPersister determineConcreteEntityDescriptor(RowProcessingState rowProcessingState, SharedSessionContractImplementor session) throws WrongClassException {
        if (this.discriminatorAssembler == null) {
            return this.entityDescriptor;
        }
        Object discriminatorDomainValue = this.discriminatorAssembler.extractRawValue(rowProcessingState);
        String concreteEntityName = this.entityDescriptor.getDiscriminatorMapping().getConcreteEntityNameForDiscriminatorValue(discriminatorDomainValue);
        if (concreteEntityName == null) {
            return this.entityDescriptor;
        }
        EntityPersister concreteType = session.getFactory().getRuntimeMetamodels().getMappingMetamodel().findEntityDescriptor(concreteEntityName);
        if (concreteType == null || !concreteType.isTypeOrSuperType(this.entityDescriptor)) {
            throw new WrongClassException(concreteEntityName, null, this.entityDescriptor.getEntityName(), discriminatorDomainValue);
        }
        assert (concreteType.isTypeOrSuperType(this.entityDescriptor));
        return concreteType;
    }

    protected void resolveEntityKey(RowProcessingState rowProcessingState) {
        if (this.entityKey != null) {
            return;
        }
        JdbcValuesSourceProcessingState jdbcValuesSourceProcessingState = rowProcessingState.getJdbcValuesSourceProcessingState();
        SharedSessionContractImplementor session = jdbcValuesSourceProcessingState.getSession();
        Object id = this.initializeIdentifier(rowProcessingState, jdbcValuesSourceProcessingState);
        if (id == null) {
            this.missing = true;
            return;
        }
        this.entityKey = new EntityKey(id, this.concreteDescriptor);
        if (jdbcValuesSourceProcessingState.findInitializer(this.entityKey) == null) {
            jdbcValuesSourceProcessingState.registerInitilaizer(this.entityKey, (Initializer)this);
        }
        if (this.concreteDescriptor.isBatchLoadable() && !session.getPersistenceContext().containsEntity(this.entityKey)) {
            session.getPersistenceContext().getBatchFetchQueue().addBatchLoadableEntityKey(this.entityKey);
        }
    }

    private Object initializeIdentifier(RowProcessingState rowProcessingState, JdbcValuesSourceProcessingState jdbcValuesSourceProcessingState) {
        boolean useEmbeddedIdentifierInstanceAsEntity;
        Object id = jdbcValuesSourceProcessingState.getProcessingOptions().getEffectiveOptionalId();
        boolean bl = useEmbeddedIdentifierInstanceAsEntity = id != null && id.getClass().equals(this.concreteDescriptor.getJavaType().getJavaType());
        if (useEmbeddedIdentifierInstanceAsEntity) {
            this.entityInstance = id;
            return id;
        }
        if (this.identifierAssembler == null) {
            return id;
        }
        return this.identifierAssembler.assemble(rowProcessingState, jdbcValuesSourceProcessingState.getProcessingOptions());
    }

    @Override
    public void resolveInstance(RowProcessingState rowProcessingState) {
        if (this.missing) {
            return;
        }
        SharedSessionContractImplementor session = rowProcessingState.getJdbcValuesSourceProcessingState().getSession();
        PersistenceContext persistenceContext = session.getPersistenceContext();
        LoadingEntityEntry existingLoadingEntry = persistenceContext.getLoadContexts().findLoadingEntityEntry(this.entityKey);
        this.setIsOwningInitializer(this.entityKey.getIdentifier(), existingLoadingEntry);
        if (this.entityInstance != null) {
            return;
        }
        Object entityIdentifier = this.entityKey.getIdentifier();
        if (EntityLoadingLogging.TRACE_ENABLED) {
            EntityLoadingLogging.ENTITY_LOADING_LOGGER.tracef("(%s) Beginning Initializer#resolveInstance process for entity (%s) : %s", (Object)StringHelper.collapse(this.getClass().getName()), (Object)this.getNavigablePath(), entityIdentifier);
        }
        Object proxy = this.getProxy(persistenceContext);
        Object entityInstanceFromExecutionContext = rowProcessingState.getJdbcValuesSourceProcessingState().getExecutionContext().getEntityInstance();
        if (proxy != null && (proxy instanceof MapProxy || this.entityDescriptor.getJavaType().getJavaTypeClass().isInstance(proxy))) {
            if (this instanceof EntityResultInitializer && entityInstanceFromExecutionContext != null) {
                this.entityInstance = entityInstanceFromExecutionContext;
                this.registerLoadingEntity(rowProcessingState, this.entityInstance);
            } else {
                this.entityInstance = proxy;
            }
        } else {
            EntityEntry entry;
            Object existingEntity = persistenceContext.getEntity(this.entityKey);
            if (existingEntity != null) {
                this.entityInstance = existingEntity;
            } else if (this instanceof EntityResultInitializer && entityInstanceFromExecutionContext != null) {
                this.entityInstance = entityInstanceFromExecutionContext;
                this.registerLoadingEntity(rowProcessingState, this.entityInstance);
            } else {
                this.entityInstance = this.resolveInstance(entityIdentifier, existingLoadingEntry, rowProcessingState, session);
            }
            if (LockMode.NONE != this.lockMode && (entry = session.getPersistenceContextInternal().getEntry(this.entityInstance)) != null && entry.getLockMode().lessThan(this.lockMode)) {
                if (this.versionAssembler != null && entry.getLockMode() != LockMode.NONE) {
                    this.checkVersion(entry, rowProcessingState);
                }
                entry.setLockMode(this.lockMode);
            }
        }
    }

    private void checkVersion(EntityEntry entry, RowProcessingState rowProcessingState) throws HibernateException {
        Object currentVersion;
        BasicType<?> versionType;
        Object version = entry.getVersion();
        if (version != null && !(versionType = this.concreteDescriptor.getVersionType()).isEqual(version, currentVersion = this.versionAssembler.assemble(rowProcessingState))) {
            StatisticsImplementor statistics = rowProcessingState.getSession().getFactory().getStatistics();
            if (statistics.isStatisticsEnabled()) {
                statistics.optimisticFailure(this.concreteDescriptor.getEntityName());
            }
            throw new StaleObjectStateException(this.concreteDescriptor.getEntityName(), entry.getId());
        }
    }

    protected Object getProxy(PersistenceContext persistenceContext) {
        return persistenceContext.getProxy(this.entityKey);
    }

    private void setIsOwningInitializer(Object entityIdentifier, LoadingEntityEntry existingLoadingEntry) {
        if (existingLoadingEntry != null) {
            if (EntityLoadingLogging.DEBUG_ENABLED) {
                EntityLoadingLogging.ENTITY_LOADING_LOGGER.debugf("(%s) Found existing loading entry [%s] - using loading instance", (Object)this.getSimpleConcreteImplName(), (Object)LoggingHelper.toLoggableString(this.getNavigablePath(), entityIdentifier));
            }
            if (existingLoadingEntry.getEntityInitializer() == this) {
                this.isOwningInitializer = true;
            }
        } else {
            this.isOwningInitializer = true;
        }
    }

    private Object resolveInstance(Object entityIdentifier, LoadingEntityEntry existingLoadingEntry, RowProcessingState rowProcessingState, SharedSessionContractImplementor session) {
        if (!this.isOwningInitializer) {
            if (EntityLoadingLogging.DEBUG_ENABLED) {
                EntityLoadingLogging.ENTITY_LOADING_LOGGER.debugf("(%s) Entity [%s] being loaded by another initializer [%s] - skipping processing", (Object)this.getSimpleConcreteImplName(), (Object)LoggingHelper.toLoggableString(this.getNavigablePath(), entityIdentifier), (Object)existingLoadingEntry.getEntityInitializer());
            }
            return existingLoadingEntry.getEntityInstance();
        }
        assert (existingLoadingEntry == null || existingLoadingEntry.getEntityInstance() == null);
        Object instance = null;
        if (this.isEntityReturn()) {
            Object requestedEntityId = rowProcessingState.getJdbcValuesSourceProcessingState().getProcessingOptions().getEffectiveOptionalId();
            Object optionalEntityInstance = rowProcessingState.getJdbcValuesSourceProcessingState().getProcessingOptions().getEffectiveOptionalObject();
            if (requestedEntityId != null && optionalEntityInstance != null && requestedEntityId.equals(this.entityKey.getIdentifier())) {
                instance = optionalEntityInstance;
            }
        }
        if (instance == null && this.entityDescriptor.canUseReferenceCacheEntries() && (instance = CacheEntityLoaderHelper.INSTANCE.loadFromSecondLevelCache((EventSource)rowProcessingState.getSession(), null, this.lockMode, this.entityDescriptor, this.entityKey)) != null) {
            return instance;
        }
        if (instance == null) {
            instance = session.instantiate(this.concreteDescriptor.getEntityName(), this.entityKey.getIdentifier());
            if (EntityLoadingLogging.DEBUG_ENABLED) {
                EntityLoadingLogging.ENTITY_LOADING_LOGGER.debugf("(%s) Created new entity instance [%s] : %s", (Object)this.getSimpleConcreteImplName(), (Object)LoggingHelper.toLoggableString(this.getNavigablePath(), entityIdentifier), instance);
            }
        }
        this.registerLoadingEntity(rowProcessingState, instance);
        return instance;
    }

    private void registerLoadingEntity(RowProcessingState rowProcessingState, Object instance) {
        LoadingEntityEntry loadingEntry = new LoadingEntityEntry(this, this.entityKey, this.concreteDescriptor, instance);
        rowProcessingState.getJdbcValuesSourceProcessingState().registerLoadingEntity(this.entityKey, loadingEntry);
    }

    @Override
    public void initializeInstance(RowProcessingState rowProcessingState) {
        if (this.missing || this.isInitialized) {
            return;
        }
        this.preLoad(rowProcessingState);
        SharedSessionContractImplementor session = rowProcessingState.getJdbcValuesSourceProcessingState().getSession();
        PersistenceContext persistenceContext = session.getPersistenceContext();
        if (this.entityInstance instanceof HibernateProxy) {
            LazyInitializer hibernateLazyInitializer = ((HibernateProxy)this.entityInstance).getHibernateLazyInitializer();
            Object instance = persistenceContext.getEntity(this.entityKey);
            if (instance == null) {
                instance = this.resolveInstance(this.entityKey.getIdentifier(), persistenceContext.getLoadContexts().findLoadingEntityEntry(this.entityKey), rowProcessingState, session);
                this.initializeEntity(instance, rowProcessingState, session, persistenceContext);
            }
            hibernateLazyInitializer.setImplementation(instance);
            this.entityInstanceForNotify = instance;
        } else {
            this.initializeEntity(this.entityInstance, rowProcessingState, session, persistenceContext);
            this.entityInstanceForNotify = this.entityInstance;
        }
        this.notifyResolutionListeners(this.entityInstanceForNotify);
        this.isInitialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeEntity(Object toInitialize, RowProcessingState rowProcessingState, SharedSessionContractImplementor session, PersistenceContext persistenceContext) {
        Type[] status;
        EntityEntry entry = persistenceContext.getEntry(toInitialize);
        if (entry != null && this.skipInitialization(toInitialize, rowProcessingState, entry)) {
            return;
        }
        Object entity = persistenceContext.getEntity(this.entityKey);
        assert (entity == null || entity == toInitialize);
        Object entityIdentifier = this.entityKey.getIdentifier();
        if (EntityLoadingLogging.TRACE_ENABLED) {
            EntityLoadingLogging.ENTITY_LOADING_LOGGER.tracef("(%s) Beginning Initializer#initializeInstance process for entity %s", (Object)this.getSimpleConcreteImplName(), (Object)LoggingHelper.toLoggableString(this.getNavigablePath(), entityIdentifier));
        }
        if (entry != null && ((status = entry.getStatus()) == Status.DELETED || status == Status.GONE)) {
            return;
        }
        this.entityDescriptor.setIdentifier(toInitialize, entityIdentifier, session);
        this.resolvedEntityState = this.concreteDescriptor.extractConcreteTypeStateValues(this.assemblerMap, rowProcessingState);
        this.concreteDescriptor.setPropertyValues(toInitialize, this.resolvedEntityState);
        persistenceContext.addEntity(this.entityKey, toInitialize);
        for (Type propertyType : this.concreteDescriptor.getPropertyTypes()) {
            AssociationType associationType;
            String ukName;
            if (!(propertyType instanceof AssociationType) || (ukName = (associationType = (AssociationType)propertyType).getLHSPropertyName()) == null) continue;
            int index = ((UniqueKeyLoadable)this.concreteDescriptor).getPropertyIndex(ukName);
            Type type = this.concreteDescriptor.getPropertyTypes()[index];
            if (this.resolvedEntityState[index] == null) continue;
            EntityUniqueKey euk = new EntityUniqueKey(this.concreteDescriptor.getRootEntityDescriptor().getEntityName(), ukName, this.resolvedEntityState[index], type, session.getFactory());
            session.getPersistenceContextInternal().addEntity(euk, toInitialize);
        }
        Object version = this.versionAssembler != null ? this.versionAssembler.assemble(rowProcessingState) : null;
        Object rowId = this.rowIdAssembler != null ? this.rowIdAssembler.assemble(rowProcessingState) : null;
        LockMode lockModeToAcquire = this.lockMode == LockMode.NONE ? LockMode.READ : this.lockMode;
        EntityEntry entityEntry = persistenceContext.addEntry(toInitialize, Status.LOADING, this.resolvedEntityState, rowId, this.entityKey.getIdentifier(), version, lockModeToAcquire, true, this.concreteDescriptor, false);
        SessionFactoryImplementor factory = session.getFactory();
        EntityDataAccess cacheAccess = this.concreteDescriptor.getCacheAccessStrategy();
        StatisticsImplementor statistics = factory.getStatistics();
        if (!rowProcessingState.isQueryCacheHit() && cacheAccess != null && session.getCacheMode().isPutEnabled()) {
            if (EntityLoadingLogging.DEBUG_ENABLED) {
                EntityLoadingLogging.ENTITY_LOADING_LOGGER.debugf("(%S) Adding entityInstance to second-level cache: %s", (Object)this.getSimpleConcreteImplName(), (Object)LoggingHelper.toLoggableString(this.getNavigablePath(), entityIdentifier));
            }
            CacheEntry cacheEntry = this.concreteDescriptor.buildCacheEntry(toInitialize, this.resolvedEntityState, version, session);
            Object cacheKey = cacheAccess.generateCacheKey(entityIdentifier, this.rootEntityDescriptor, factory, session.getTenantIdentifier());
            if (persistenceContext.wasInsertedDuringTransaction(this.concreteDescriptor, entityIdentifier)) {
                cacheAccess.update(session, cacheKey, this.rootEntityDescriptor.getCacheEntryStructure().structure(cacheEntry), version, version);
            } else {
                SessionEventListenerManager eventListenerManager = session.getEventListenerManager();
                try {
                    eventListenerManager.cachePutStart();
                    boolean put = cacheAccess.putFromLoad(session, cacheKey, this.rootEntityDescriptor.getCacheEntryStructure().structure(cacheEntry), version, false);
                    if (put && statistics.isStatisticsEnabled()) {
                        statistics.entityCachePut(this.rootEntityDescriptor.getNavigableRole(), cacheAccess.getRegion().getName());
                    }
                }
                finally {
                    eventListenerManager.cachePutEnd();
                }
            }
        }
        if (this.entityDescriptor.getNaturalIdMapping() != null) {
            persistenceContext.getNaturalIdResolutions().cacheResolutionFromLoad(entityIdentifier, this.entityDescriptor.getNaturalIdMapping().extractNaturalIdFromEntityState(this.resolvedEntityState, session), this.entityDescriptor);
        }
        boolean isReallyReadOnly = this.isReadOnly(rowProcessingState, session);
        if (!this.concreteDescriptor.isMutable()) {
            isReallyReadOnly = true;
        } else if (this.entityInstance instanceof HibernateProxy) {
            isReallyReadOnly = ((HibernateProxy)this.entityInstance).getHibernateLazyInitializer().isReadOnly();
        }
        if (isReallyReadOnly) {
            persistenceContext.setEntryStatus(entityEntry, Status.READ_ONLY);
        } else {
            AbstractEntityInitializer.deepCopy(this.concreteDescriptor, this.resolvedEntityState, this.resolvedEntityState, this.concreteDescriptor);
            persistenceContext.setEntryStatus(entityEntry, Status.MANAGED);
        }
        this.concreteDescriptor.afterInitialize(toInitialize, session);
        if (EntityLoadingLogging.DEBUG_ENABLED) {
            EntityLoadingLogging.ENTITY_LOADING_LOGGER.debugf("(%s) Done materializing entityInstance : %s", (Object)this.getSimpleConcreteImplName(), (Object)LoggingHelper.toLoggableString(this.getNavigablePath(), entityIdentifier));
        }
        if (statistics.isStatisticsEnabled() && !rowProcessingState.isQueryCacheHit()) {
            statistics.loadEntity(this.concreteDescriptor.getEntityName());
        }
    }

    private boolean skipInitialization(Object toInitialize, RowProcessingState rowProcessingState, EntityEntry entry) {
        PersistentAttributeInterceptor interceptor;
        if (!this.isOwningInitializer) {
            return true;
        }
        if (toInitialize instanceof PersistentAttributeInterceptable && (interceptor = ((PersistentAttributeInterceptable)toInitialize).$$_hibernate_getInterceptor()) instanceof EnhancementAsProxyLazinessInterceptor) {
            return entry.getStatus() == Status.LOADING;
        }
        if (entry.getStatus() != Status.LOADING) {
            Object optionalEntityInstance = rowProcessingState.getJdbcValuesSourceProcessingState().getProcessingOptions().getEffectiveOptionalObject();
            if (!this.isEntityReturn() || toInitialize != optionalEntityInstance) {
                return true;
            }
        }
        return false;
    }

    private boolean isReadOnly(RowProcessingState rowProcessingState, SharedSessionContractImplementor persistenceContext) {
        Boolean readOnly = rowProcessingState.getQueryOptions().isReadOnly();
        return readOnly == null ? persistenceContext.isDefaultReadOnly() : readOnly.booleanValue();
    }

    private void preLoad(RowProcessingState rowProcessingState) {
        SharedSessionContractImplementor session = rowProcessingState.getJdbcValuesSourceProcessingState().getSession();
        if (session instanceof EventSource) {
            PreLoadEvent preLoadEvent = rowProcessingState.getJdbcValuesSourceProcessingState().getPreLoadEvent();
            assert (preLoadEvent != null);
            preLoadEvent.reset();
            preLoadEvent.setEntity(this.entityInstance).setId(this.entityKey.getIdentifier()).setPersister(this.concreteDescriptor);
            EventListenerGroup<PreLoadEventListener> listenerGroup = session.getFactory().getFastSessionServices().eventListenerGroup_PRE_LOAD;
            for (PreLoadEventListener listener : listenerGroup.listeners()) {
                listener.onPreLoad(preLoadEvent);
            }
        }
    }

    @Override
    public EntityPersister getConcreteDescriptor() {
        return this.concreteDescriptor;
    }

    @Override
    public void finishUpRow(RowProcessingState rowProcessingState) {
        this.isOwningInitializer = false;
        this.concreteDescriptor = null;
        this.entityKey = null;
        this.entityInstance = null;
        this.entityInstanceForNotify = null;
        this.missing = false;
        this.resolvedEntityState = null;
        this.isInitialized = false;
        this.clearResolutionListeners();
    }
}

