/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.jdbc.internal;

import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.sql.results.caching.QueryCachePutManager;
import org.hibernate.sql.results.jdbc.spi.JdbcValues;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;

public abstract class AbstractJdbcValues
implements JdbcValues {
    private final QueryCachePutManager queryCachePutManager;

    public AbstractJdbcValues(QueryCachePutManager queryCachePutManager) {
        if (queryCachePutManager == null) {
            throw new IllegalArgumentException("QueryCachePutManager cannot be null");
        }
        this.queryCachePutManager = queryCachePutManager;
    }

    @Override
    public final boolean next(RowProcessingState rowProcessingState) {
        boolean hadRow = this.processNext(rowProcessingState);
        if (hadRow) {
            this.queryCachePutManager.registerJdbcRow(this.getCurrentRowValuesArray());
        }
        return hadRow;
    }

    protected abstract boolean processNext(RowProcessingState var1);

    @Override
    public boolean previous(RowProcessingState rowProcessingState) {
        return this.processPrevious(rowProcessingState);
    }

    protected abstract boolean processPrevious(RowProcessingState var1);

    @Override
    public boolean scroll(int numberOfRows, RowProcessingState rowProcessingState) {
        return this.processScroll(numberOfRows, rowProcessingState);
    }

    protected abstract boolean processScroll(int var1, RowProcessingState var2);

    @Override
    public boolean position(int position, RowProcessingState rowProcessingState) {
        return this.processPosition(position, rowProcessingState);
    }

    protected abstract boolean processPosition(int var1, RowProcessingState var2);

    @Override
    public final void finishUp(SharedSessionContractImplementor session) {
        this.queryCachePutManager.finishUp(session);
        this.release();
    }

    protected abstract void release();
}

