/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.jdbc.internal;

import jakarta.persistence.EnumType;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMetadata;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeIndicators;
import org.hibernate.type.spi.TypeConfiguration;

public interface ResultSetAccess
extends JdbcValuesMetadata {
    public ResultSet getResultSet();

    public SessionFactoryImplementor getFactory();

    public void release();

    @Override
    default public int getColumnCount() {
        try {
            return this.getResultSet().getMetaData().getColumnCount();
        }
        catch (SQLException e) {
            throw this.getFactory().getJdbcServices().getJdbcEnvironment().getSqlExceptionHelper().convert(e, "Unable to access ResultSet column count");
        }
    }

    @Override
    default public int resolveColumnPosition(String columnName) {
        try {
            return this.getResultSet().findColumn(columnName);
        }
        catch (SQLException e) {
            throw this.getFactory().getJdbcServices().getJdbcEnvironment().getSqlExceptionHelper().convert(e, "Unable to find column position by name");
        }
    }

    @Override
    default public String resolveColumnName(int position) {
        try {
            return this.getFactory().getJdbcServices().getJdbcEnvironment().getDialect().getColumnAliasExtractor().extractColumnAlias(this.getResultSet().getMetaData(), position);
        }
        catch (SQLException e) {
            throw this.getFactory().getJdbcServices().getJdbcEnvironment().getSqlExceptionHelper().convert(e, "Unable to find column name by position");
        }
    }

    @Override
    default public <J> BasicType<J> resolveType(int position, JavaType<J> explicitJavaType, SessionFactoryImplementor sessionFactory) {
        final TypeConfiguration typeConfiguration = this.getFactory().getTypeConfiguration();
        JdbcServices jdbcServices = this.getFactory().getJdbcServices();
        try {
            JdbcType jdbcType;
            JavaType<J> javaType;
            ResultSetMetaData metaData = this.getResultSet().getMetaData();
            String columnTypeName = metaData.getColumnTypeName(position);
            int columnType = metaData.getColumnType(position);
            final int scale = metaData.getScale(position);
            final int precision = metaData.getPrecision(position);
            int displaySize = metaData.getColumnDisplaySize(position);
            Dialect dialect = jdbcServices.getDialect();
            final int length = dialect.resolveSqlTypeLength(columnTypeName, columnType, precision, scale, displaySize);
            final JdbcType resolvedJdbcType = dialect.resolveSqlTypeDescriptor(columnTypeName, columnType, length, scale, typeConfiguration.getJdbcTypeRegistry());
            if (explicitJavaType != null) {
                javaType = explicitJavaType;
                jdbcType = explicitJavaType.getRecommendedJdbcType(new JdbcTypeIndicators(){

                    @Override
                    public TypeConfiguration getTypeConfiguration() {
                        return typeConfiguration;
                    }

                    @Override
                    public long getColumnLength() {
                        return length;
                    }

                    @Override
                    public int getColumnPrecision() {
                        return precision;
                    }

                    @Override
                    public int getColumnScale() {
                        return scale;
                    }

                    @Override
                    public EnumType getEnumeratedType() {
                        return resolvedJdbcType.isNumber() ? EnumType.ORDINAL : EnumType.STRING;
                    }
                });
            } else {
                jdbcType = resolvedJdbcType;
                javaType = jdbcType.getJdbcRecommendedJavaTypeMapping(length, scale, typeConfiguration);
            }
            return typeConfiguration.getBasicTypeRegistry().resolve(javaType, jdbcType);
        }
        catch (SQLException e) {
            throw jdbcServices.getSqlExceptionHelper().convert(e, "Unable to determine JDBC type code for ResultSet position " + position);
        }
    }
}

