/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import jakarta.persistence.AttributeConverter;
import jakarta.persistence.Converter;
import org.hibernate.metamodel.model.convert.spi.BasicValueConverter;
import org.hibernate.type.descriptor.java.BooleanJavaType;
import org.hibernate.type.descriptor.java.CharacterJavaType;
import org.hibernate.type.descriptor.java.JavaType;

@Converter
public class YesNoConverter
implements AttributeConverter<Boolean, Character>,
BasicValueConverter<Boolean, Character> {
    public static final YesNoConverter INSTANCE = new YesNoConverter();

    public Character convertToDatabaseColumn(Boolean attribute) {
        return this.toRelationalValue(attribute);
    }

    public Boolean convertToEntityAttribute(Character dbData) {
        return this.toDomainValue(dbData);
    }

    @Override
    public Boolean toDomainValue(Character relationalForm) {
        if (relationalForm == null) {
            return null;
        }
        switch (relationalForm.charValue()) {
            case 'Y': {
                return true;
            }
            case 'N': {
                return false;
            }
        }
        return null;
    }

    @Override
    public Character toRelationalValue(Boolean domainForm) {
        if (domainForm == null) {
            return null;
        }
        return Character.valueOf(domainForm != false ? (char)'Y' : 'N');
    }

    @Override
    public JavaType<Boolean> getDomainJavaType() {
        return BooleanJavaType.INSTANCE;
    }

    @Override
    public JavaType<Character> getRelationalJavaType() {
        return CharacterJavaType.INSTANCE;
    }
}

