/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import java.time.Clock;
import java.time.Duration;
import org.hibernate.engine.spi.SharedSessionContractImplementor;

public class ClockHelper {
    private static final Duration TICK_8 = Duration.ofNanos(10L);
    private static final Duration TICK_7 = Duration.ofNanos(100L);
    private static final Duration TICK_6 = Duration.ofNanos(1000L);
    private static final Duration TICK_5 = Duration.ofNanos(10000L);
    private static final Duration TICK_4 = Duration.ofNanos(100000L);
    private static final Duration TICK_3 = Duration.ofNanos(1000000L);
    private static final Duration TICK_2 = Duration.ofNanos(10000000L);
    private static final Duration TICK_1 = Duration.ofNanos(100000000L);
    private static final Duration TICK_0 = Duration.ofNanos(1000000000L);

    public static Clock forPrecision(Integer precision, SharedSessionContractImplementor session) {
        int resolvedPrecision = precision == null ? session.getJdbcServices().getDialect().getDefaultTimestampPrecision() : precision.intValue();
        Clock clock = Clock.systemDefaultZone();
        switch (resolvedPrecision) {
            case 0: {
                return Clock.tick(clock, TICK_0);
            }
            case 1: {
                return Clock.tick(clock, TICK_1);
            }
            case 2: {
                return Clock.tick(clock, TICK_2);
            }
            case 3: {
                return Clock.tick(clock, TICK_3);
            }
            case 4: {
                return Clock.tick(clock, TICK_4);
            }
            case 5: {
                return Clock.tick(clock, TICK_5);
            }
            case 6: {
                return Clock.tick(clock, TICK_6);
            }
            case 7: {
                return Clock.tick(clock, TICK_7);
            }
            case 8: {
                return Clock.tick(clock, TICK_8);
            }
            case 9: {
                return clock;
            }
        }
        throw new IllegalArgumentException("Illegal precision: " + resolvedPrecision);
    }
}

