/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import jakarta.persistence.TemporalType;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.hibernate.cache.internal.CacheKeyValueDescriptor;
import org.hibernate.cache.internal.DefaultCacheKeyValueDescriptor;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractTemporalJavaType;
import org.hibernate.type.descriptor.java.ClockHelper;
import org.hibernate.type.descriptor.java.ImmutableMutabilityPlan;
import org.hibernate.type.descriptor.java.TemporalJavaType;
import org.hibernate.type.descriptor.java.VersionJavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeIndicators;
import org.hibernate.type.descriptor.jdbc.spi.JdbcTypeRegistry;
import org.hibernate.type.spi.TypeConfiguration;

public class OffsetDateTimeJavaType
extends AbstractTemporalJavaType<OffsetDateTime>
implements VersionJavaType<OffsetDateTime> {
    public static final OffsetDateTimeJavaType INSTANCE = new OffsetDateTimeJavaType();

    public OffsetDateTimeJavaType() {
        super(OffsetDateTime.class, ImmutableMutabilityPlan.instance(), OffsetDateTime.timeLineOrder());
    }

    @Override
    public TemporalType getPrecision() {
        return TemporalType.TIMESTAMP;
    }

    @Override
    public JdbcType getRecommendedJdbcType(JdbcTypeIndicators stdIndicators) {
        TemporalType temporalPrecision = stdIndicators.getTemporalPrecision();
        JdbcTypeRegistry jdbcTypeRegistry = stdIndicators.getTypeConfiguration().getJdbcTypeRegistry();
        if (temporalPrecision == null || temporalPrecision == TemporalType.TIMESTAMP) {
            switch (stdIndicators.getDefaultTimeZoneStorageStrategy()) {
                case NORMALIZE: {
                    return jdbcTypeRegistry.getDescriptor(93);
                }
                case NORMALIZE_UTC: {
                    return jdbcTypeRegistry.getDescriptor(3003);
                }
            }
            return jdbcTypeRegistry.getDescriptor(2014);
        }
        switch (temporalPrecision) {
            case TIME: {
                return jdbcTypeRegistry.getDescriptor(92);
            }
            case DATE: {
                return jdbcTypeRegistry.getDescriptor(91);
            }
        }
        throw new IllegalArgumentException("Unexpected jakarta.persistence.TemporalType : " + temporalPrecision);
    }

    @Override
    protected <X> TemporalJavaType<X> forTimestampPrecision(TypeConfiguration typeConfiguration) {
        return this;
    }

    @Override
    public String toString(OffsetDateTime value) {
        return DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(value);
    }

    @Override
    public OffsetDateTime fromString(CharSequence string) {
        return OffsetDateTime.from(DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse(string));
    }

    @Override
    public <X> X unwrap(OffsetDateTime offsetDateTime, Class<X> type, WrapperOptions options) {
        if (offsetDateTime == null) {
            return null;
        }
        if (OffsetDateTime.class.isAssignableFrom(type)) {
            return (X)offsetDateTime;
        }
        if (ZonedDateTime.class.isAssignableFrom(type)) {
            return (X)offsetDateTime.toZonedDateTime();
        }
        if (Instant.class.isAssignableFrom(type)) {
            return (X)offsetDateTime.toInstant();
        }
        if (Calendar.class.isAssignableFrom(type)) {
            return (X)GregorianCalendar.from(offsetDateTime.toZonedDateTime());
        }
        if (Timestamp.class.isAssignableFrom(type)) {
            if (offsetDateTime.getYear() < 1905) {
                return (X)Timestamp.valueOf(offsetDateTime.atZoneSameInstant(ZoneId.systemDefault()).toLocalDateTime());
            }
            return (X)Timestamp.from(offsetDateTime.toInstant());
        }
        if (Date.class.isAssignableFrom(type)) {
            return (X)Date.from(offsetDateTime.toInstant());
        }
        if (Time.class.isAssignableFrom(type)) {
            return (X)Time.from(offsetDateTime.toInstant());
        }
        if (java.util.Date.class.isAssignableFrom(type)) {
            return (X)java.util.Date.from(offsetDateTime.toInstant());
        }
        if (Long.class.isAssignableFrom(type)) {
            return (X)Long.valueOf(offsetDateTime.toInstant().toEpochMilli());
        }
        throw this.unknownUnwrap(type);
    }

    @Override
    public <X> OffsetDateTime wrap(X value, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (value instanceof OffsetDateTime) {
            return (OffsetDateTime)value;
        }
        if (value instanceof ZonedDateTime) {
            ZonedDateTime zonedDateTime = (ZonedDateTime)value;
            return OffsetDateTime.of(zonedDateTime.toLocalDateTime(), zonedDateTime.getOffset());
        }
        if (value instanceof Instant) {
            Instant instant = (Instant)value;
            return instant.atOffset(ZoneOffset.UTC);
        }
        if (value instanceof Timestamp) {
            Timestamp ts = (Timestamp)value;
            if (ts.getYear() < 5) {
                return ts.toLocalDateTime().atZone(ZoneId.systemDefault()).toOffsetDateTime();
            }
            return OffsetDateTime.ofInstant(ts.toInstant(), ZoneId.systemDefault());
        }
        if (value instanceof java.util.Date) {
            java.util.Date date = (java.util.Date)value;
            return OffsetDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
        }
        if (value instanceof Long) {
            return OffsetDateTime.ofInstant(Instant.ofEpochMilli((Long)value), ZoneId.systemDefault());
        }
        if (value instanceof Calendar) {
            Calendar calendar = (Calendar)value;
            return OffsetDateTime.ofInstant(calendar.toInstant(), calendar.getTimeZone().toZoneId());
        }
        throw this.unknownWrap(value.getClass());
    }

    @Override
    public int getDefaultSqlPrecision(Dialect dialect, JdbcType jdbcType) {
        return dialect.getDefaultTimestampPrecision();
    }

    @Override
    public OffsetDateTime seed(Long length, Integer precision, Integer scale, SharedSessionContractImplementor session) {
        return OffsetDateTime.now(ClockHelper.forPrecision(precision, session));
    }

    @Override
    public OffsetDateTime next(OffsetDateTime current, Long length, Integer precision, Integer scale, SharedSessionContractImplementor session) {
        return OffsetDateTime.now(ClockHelper.forPrecision(precision, session));
    }

    @Override
    public CacheKeyValueDescriptor toCacheKeyDescriptor(SessionFactoryImplementor sessionFactory) {
        return DefaultCacheKeyValueDescriptor.INSTANCE;
    }
}

