/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import java.time.ZoneId;
import org.hibernate.cache.internal.CacheKeyValueDescriptor;
import org.hibernate.cache.internal.DefaultCacheKeyValueDescriptor;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractClassJavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeIndicators;

public class ZoneIdJavaType
extends AbstractClassJavaType<ZoneId> {
    public static final ZoneIdJavaType INSTANCE = new ZoneIdJavaType();

    public ZoneIdJavaType() {
        super(ZoneId.class);
    }

    @Override
    public JdbcType getRecommendedJdbcType(JdbcTypeIndicators indicators) {
        return indicators.getTypeConfiguration().getJdbcTypeRegistry().getDescriptor(12);
    }

    @Override
    public String toString(ZoneId value) {
        return value == null ? null : value.getId();
    }

    @Override
    public ZoneId fromString(CharSequence string) {
        return string == null ? null : ZoneId.of(string.toString());
    }

    @Override
    public <X> X unwrap(ZoneId value, Class<X> type, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (String.class.isAssignableFrom(type)) {
            return (X)this.toString(value);
        }
        throw this.unknownUnwrap(type);
    }

    @Override
    public <X> ZoneId wrap(X value, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return this.fromString((String)value);
        }
        throw this.unknownWrap(value.getClass());
    }

    @Override
    public CacheKeyValueDescriptor toCacheKeyDescriptor(SessionFactoryImplementor sessionFactory) {
        return DefaultCacheKeyValueDescriptor.INSTANCE;
    }
}

