/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.generic_project.beans;

import org.openspcoop2.generic_project.beans.Field;
import org.openspcoop2.generic_project.beans.IField;

public class ComplexField
implements IField {
    protected String fieldName;
    protected Class<?> fieldType;
    protected String className;
    protected Class<?> classType;
    protected IField father;

    public ComplexField(IField father, String fieldName, Class<?> fieldType, String className, Class<?> classType) {
        this.fieldName = fieldName;
        this.fieldType = fieldType;
        this.className = className;
        this.classType = classType;
        this.father = father;
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public Class<?> getFieldType() {
        return this.fieldType;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public Class<?> getClassType() {
        return this.classType;
    }

    public IField getFather() {
        return this.father;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof ComplexField)) {
            if (o instanceof IField) {
                return false;
            }
            throw new RuntimeException("Expected type [" + ComplexField.class.getName() + "] different from the type found [" + o.getClass().getName() + "]");
        }
        ComplexField f = (ComplexField)o;
        String thisClassTypeName = this.getClassType().getName();
        String fClassTypeName = f.getClassType().getName();
        String thisFieldTypeName = this.getFieldType().getName();
        String fFieldTypeName = f.getFieldType().getName();
        return this.getClassName().equals(f.getClassName()) && thisClassTypeName.equals(fClassTypeName) && this.getFieldName().equals(f.getFieldName()) && thisFieldTypeName.equals(fFieldTypeName) && this.father.equals(f.getFather());
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return this.toString(0);
    }

    @Override
    public String toString(int indent) {
        StringBuilder indentBuffer = new StringBuilder();
        for (int i = 0; i < indent; ++i) {
            indentBuffer.append("\t");
        }
        StringBuilder bf = new StringBuilder();
        bf.append(indentBuffer.toString());
        bf.append("- field name: " + this.fieldName);
        bf.append("\n");
        bf.append(indentBuffer.toString());
        bf.append("- field type: " + this.fieldType);
        bf.append("\n");
        bf.append(indentBuffer.toString());
        bf.append("- class name: " + this.className);
        bf.append("\n");
        bf.append(indentBuffer.toString());
        bf.append("- class type: " + this.classType);
        bf.append("\n");
        bf.append(indentBuffer.toString());
        bf.append("- father: ");
        bf.append("\n");
        if (this.father instanceof ComplexField) {
            bf.append(((ComplexField)this.father).toString(++indent));
        } else if (this.father instanceof Field) {
            bf.append(((Field)this.father).toString(++indent));
        } else {
            throw new RuntimeException("Type [" + this.father.getClass().getName() + "] not supported");
        }
        return bf.toString();
    }
}

