/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.generic_project.expression.impl;

import java.util.ArrayList;
import java.util.List;
import org.openspcoop2.generic_project.beans.ComplexField;
import org.openspcoop2.generic_project.beans.IField;
import org.openspcoop2.generic_project.exception.ExpressionException;
import org.openspcoop2.generic_project.exception.ExpressionNotImplementedException;
import org.openspcoop2.generic_project.expression.impl.AbstractCommonFieldBaseExpressionImpl;
import org.openspcoop2.generic_project.expression.impl.Comparator;
import org.openspcoop2.generic_project.expression.impl.formatter.IObjectFormatter;

public class ComparatorExpressionImpl
extends AbstractCommonFieldBaseExpressionImpl {
    private Object object;
    private Comparator comparator;

    public ComparatorExpressionImpl(IObjectFormatter objectFormatter, IField field, Object object, Comparator comparator) {
        super(objectFormatter, field);
        this.object = object;
        this.comparator = comparator;
    }

    public Object getObject() {
        return this.object;
    }

    public void setObject(Object object) {
        this.object = object;
    }

    public Comparator getComparator() {
        return this.comparator;
    }

    public void setComparator(Comparator comparator) {
        this.comparator = comparator;
    }

    public String toString() {
        StringBuilder bf = new StringBuilder();
        if (this.isNot()) {
            bf.append("( NOT ");
        }
        bf.append("( ");
        if (this.field instanceof ComplexField) {
            ComplexField cf = (ComplexField)this.field;
            if (cf.getFather() != null) {
                bf.append(cf.getFather().getFieldName());
            } else {
                bf.append(this.field.getClassName());
            }
        } else {
            bf.append(this.field.getClassName());
        }
        bf.append(".");
        bf.append(this.field.getFieldName());
        bf.append(" ");
        bf.append(this.comparator.getOperatore());
        if (this.object != null) {
            bf.append(" ");
            try {
                bf.append(super.getObjectFormatter().toString(this.object));
            }
            catch (Exception e) {
                return "ERROR: " + e.getMessage();
            }
        }
        bf.append(" )");
        if (this.isNot()) {
            bf.append(" )");
        }
        return bf.toString();
    }

    @Override
    public List<Object> getFieldValues(IField field) throws ExpressionNotImplementedException, ExpressionException {
        ArrayList<Object> lista = null;
        if (this.field == null) {
            return lista;
        }
        if (this.field.equals(field)) {
            lista = new ArrayList<Object>();
            lista.add(this.object);
            return lista;
        }
        return lista;
    }
}

