/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.generic_project.expression.impl.formatter;

import org.openspcoop2.generic_project.exception.ExpressionException;
import org.openspcoop2.generic_project.expression.impl.formatter.ITypeFormatter;
import org.openspcoop2.generic_project.expression.impl.formatter.StringTypeFormatter;
import org.openspcoop2.utils.TipiDatabase;
import org.openspcoop2.utils.Utilities;

public class ByteArrayTypeFormatter
implements ITypeFormatter<byte[]> {
    @Override
    public String toString(byte[] o) throws ExpressionException {
        if (o == null) {
            throw new ExpressionException("Object parameter is null");
        }
        int max = 5120;
        StringBuilder sb = new StringBuilder();
        try {
            sb.append('\'').append(Utilities.convertToPrintableText((byte[])o, (int)max)).append('\'');
        }
        catch (Exception e) {
            sb.append("bytes[] not printable (" + e.getMessage() + ")");
        }
        return sb.toString();
    }

    @Override
    public String toSQLString(byte[] o) throws ExpressionException {
        return this.toSQLString(o, TipiDatabase.DEFAULT);
    }

    @Override
    public String toSQLString(byte[] o, TipiDatabase databaseType) throws ExpressionException {
        return "'" + StringTypeFormatter.escapeStringValue(this.toString(o)) + "'";
    }

    @Override
    public byte[] toObject(String o, Class<?> c) throws ExpressionException {
        if (o == null) {
            throw new ExpressionException("Object parameter is null");
        }
        try {
            return o.getBytes();
        }
        catch (Exception e) {
            throw new ExpressionException("Conversion failure: " + e.getMessage(), e);
        }
    }

    @Override
    public Class<byte[]> getTypeSupported() {
        return byte[].class;
    }
}

