/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.generic_project.expression.impl.formatter;

import org.openspcoop2.generic_project.exception.ExpressionException;
import org.openspcoop2.generic_project.expression.impl.formatter.ITypeFormatter;
import org.openspcoop2.utils.TipiDatabase;

public class DoubleTypeFormatter
implements ITypeFormatter<Double> {
    @Override
    public String toString(Double o) throws ExpressionException {
        if (o == null) {
            throw new ExpressionException("Object parameter is null");
        }
        return "" + o;
    }

    @Override
    public String toSQLString(Double o) throws ExpressionException {
        return this.toSQLString(o, TipiDatabase.DEFAULT);
    }

    @Override
    public String toSQLString(Double o, TipiDatabase databaseType) throws ExpressionException {
        switch (databaseType) {
            case ORACLE: {
                return "to_binary_double(" + this.toString(o) + ")";
            }
        }
        return this.toString(o);
    }

    @Override
    public Double toObject(String o, Class<?> c) throws ExpressionException {
        if (o == null) {
            throw new ExpressionException("Object parameter is null");
        }
        try {
            return Double.parseDouble(o);
        }
        catch (Exception e) {
            throw new ExpressionException("Conversion failure: " + e.getMessage(), e);
        }
    }

    @Override
    public Class<Double> getTypeSupported() {
        return Double.class;
    }
}

