/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.generic_project.expression.impl.sql;

import java.util.List;
import java.util.Map;
import org.openspcoop2.generic_project.exception.ExpressionException;
import org.openspcoop2.generic_project.expression.impl.AbstractBaseExpressionImpl;
import org.openspcoop2.generic_project.expression.impl.ConjunctionExpressionImpl;
import org.openspcoop2.generic_project.expression.impl.formatter.IObjectFormatter;
import org.openspcoop2.generic_project.expression.impl.sql.ISQLExpression;
import org.openspcoop2.generic_project.expression.impl.sql.ISQLFieldConverter;
import org.openspcoop2.generic_project.expression.impl.sql.SQLMode;
import org.openspcoop2.utils.sql.ISQLQueryObject;

public class ConjunctionExpressionSQL
extends ConjunctionExpressionImpl
implements ISQLExpression {
    private ISQLFieldConverter sqlFieldConverter;

    public ConjunctionExpressionSQL(ISQLFieldConverter sqlFieldConverter, IObjectFormatter objectFormatter) {
        super(objectFormatter);
        this.sqlFieldConverter = sqlFieldConverter;
    }

    private String toSqlEngine(SQLMode mode, ISQLQueryObject sqlQueryObject, List<Object> oggettiPreparedStatement, Map<String, Object> oggettiJPA) throws ExpressionException {
        StringBuilder bf = new StringBuilder();
        if (this.isNot()) {
            bf.append("( NOT ");
        }
        bf.append("( ");
        int index = 0;
        for (AbstractBaseExpressionImpl exp : this.getLista()) {
            if (index > 0) {
                if (this.isAndConjunction()) {
                    bf.append(" AND ");
                } else {
                    bf.append(" OR ");
                }
            }
            if (exp instanceof ISQLExpression) {
                if (sqlQueryObject != null) {
                    ISQLQueryObject sqlQ = null;
                    try {
                        sqlQ = sqlQueryObject.newSQLQueryObject();
                        switch (mode) {
                            case STANDARD: {
                                ((ISQLExpression)((Object)exp)).toSql(sqlQ);
                                bf.append(sqlQ.createSQLConditions());
                                break;
                            }
                            case PREPARED_STATEMENT: {
                                ((ISQLExpression)((Object)exp)).toSqlPreparedStatement(sqlQ, oggettiPreparedStatement);
                                bf.append(sqlQ.createSQLConditions());
                                break;
                            }
                            case JPA: {
                                ((ISQLExpression)((Object)exp)).toSqlJPA(sqlQ, oggettiJPA);
                                bf.append(sqlQ.createSQLConditions());
                            }
                        }
                    }
                    catch (Exception e) {
                        throw new ExpressionException("Expression[" + index + "] (type:" + exp.getClass().getName() + ")  sqlQueryObject error: " + e.getMessage(), e);
                    }
                } else {
                    switch (mode) {
                        case STANDARD: {
                            bf.append(((ISQLExpression)((Object)exp)).toSql());
                            break;
                        }
                        case PREPARED_STATEMENT: {
                            bf.append(((ISQLExpression)((Object)exp)).toSqlPreparedStatement(oggettiPreparedStatement));
                            break;
                        }
                        case JPA: {
                            bf.append(((ISQLExpression)((Object)exp)).toSqlJPA(oggettiJPA));
                        }
                    }
                }
            } else {
                throw new ExpressionException("Expression[" + index + "] (type:" + exp.getClass().getName() + ") is not as cast with " + ISQLExpression.class.getName());
            }
            ++index;
        }
        bf.append(" )");
        if (this.isNot()) {
            bf.append(" )");
        }
        return bf.toString();
    }

    private void toSqlEngine(ISQLQueryObject sqlQueryObject, SQLMode mode, List<Object> oggettiPreparedStatement, Map<String, Object> oggettiJPA) throws ExpressionException {
        try {
            String s = this.toSqlEngine(mode, sqlQueryObject, oggettiPreparedStatement, oggettiJPA);
            s = s.substring(1, s.length() - 2);
            sqlQueryObject.addWhereCondition(s);
        }
        catch (Exception e) {
            throw new ExpressionException(e);
        }
    }

    @Override
    public String toSql() throws ExpressionException {
        return this.toSqlEngine(SQLMode.STANDARD, null, null, null);
    }

    @Override
    public String toSqlPreparedStatement(List<Object> oggetti) throws ExpressionException {
        return this.toSqlEngine(SQLMode.PREPARED_STATEMENT, null, oggetti, null);
    }

    @Override
    public String toSqlJPA(Map<String, Object> oggetti) throws ExpressionException {
        return this.toSqlEngine(SQLMode.JPA, null, null, oggetti);
    }

    @Override
    public void toSql(ISQLQueryObject sqlQueryObject) throws ExpressionException {
        this.toSqlEngine(sqlQueryObject, SQLMode.STANDARD, null, null);
    }

    @Override
    public void toSqlPreparedStatement(ISQLQueryObject sqlQueryObject, List<Object> oggetti) throws ExpressionException {
        this.toSqlEngine(sqlQueryObject, SQLMode.PREPARED_STATEMENT, oggetti, null);
    }

    @Override
    public void toSqlJPA(ISQLQueryObject sqlQueryObject, Map<String, Object> oggetti) throws ExpressionException {
        this.toSqlEngine(sqlQueryObject, SQLMode.JPA, null, oggetti);
    }
}

