/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.javaflow.core;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.commons.javaflow.core.EmptyStackException;
import org.apache.commons.javaflow.core.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Stack
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(Stack.class);
    private static final long serialVersionUID = 3L;
    private long[] pstack;
    private Object[] ostack;
    private Object[] rstack;
    private int dTop;
    private int fTop;
    private int lTop;
    private int iTop;
    private int oTop;
    private int rTop;
    protected Runnable runnable;

    Stack(Runnable pRunnable) {
        this.pstack = new long[16];
        this.ostack = new Object[8];
        this.rstack = new Object[4];
        this.runnable = pRunnable;
    }

    Stack(Stack pParent) {
        this.pstack = new long[pParent.pstack.length];
        this.ostack = new Object[pParent.ostack.length];
        this.rstack = new Object[pParent.rstack.length];
        this.iTop = pParent.iTop;
        this.fTop = pParent.fTop;
        this.dTop = pParent.dTop;
        this.lTop = pParent.lTop;
        this.oTop = pParent.oTop;
        this.rTop = pParent.rTop;
        System.arraycopy(pParent.pstack, 0, this.pstack, 0, this.pTop());
        System.arraycopy(pParent.ostack, 0, this.ostack, 0, this.oTop);
        System.arraycopy(pParent.rstack, 0, this.rstack, 0, this.rTop);
        this.runnable = pParent.runnable;
    }

    public final boolean hasDouble() {
        return this.dTop > 0;
    }

    public final double popDouble() {
        if (this.dTop == 0) {
            throw new EmptyStackException("pop double");
        }
        --this.dTop;
        double d = Double.longBitsToDouble(this.popPrimitive());
        if (log.isDebugEnabled()) {
            log.debug("pop double " + d + " " + this.getStats());
        }
        return d;
    }

    public final boolean hasFloat() {
        return this.fTop > 0;
    }

    public final float popFloat() {
        if (this.fTop == 0) {
            throw new EmptyStackException("pop float");
        }
        --this.fTop;
        float f = Float.intBitsToFloat((int)this.popPrimitive());
        if (log.isDebugEnabled()) {
            log.debug("pop float " + f + " " + this.getStats());
        }
        return f;
    }

    public final boolean hasLong() {
        return this.lTop > 0;
    }

    public final long popLong() {
        if (this.lTop == 0) {
            throw new EmptyStackException("pop long");
        }
        --this.lTop;
        long l = this.popPrimitive();
        if (log.isDebugEnabled()) {
            log.debug("pop long " + l + " " + this.getStats());
        }
        return l;
    }

    public final boolean hasInt() {
        return this.iTop > 0;
    }

    public final int popInt() {
        if (this.iTop == 0) {
            throw new EmptyStackException("pop int");
        }
        --this.iTop;
        int i = (int)this.popPrimitive();
        if (log.isDebugEnabled()) {
            log.debug("pop int " + i + " " + this.getStats());
        }
        return i;
    }

    public final boolean hasObject() {
        return this.oTop > 0;
    }

    public final Object popObject() {
        if (this.oTop == 0) {
            throw new EmptyStackException("pop object");
        }
        Object o = this.ostack[--this.oTop];
        this.ostack[this.oTop] = null;
        if (log.isDebugEnabled()) {
            log.debug("pop object " + ReflectionUtils.descriptionOfObject(o) + " " + this.getStats());
        }
        return o;
    }

    public final boolean hasReference() {
        return this.rTop > 0;
    }

    public final Object popReference() {
        if (this.rTop == 0) {
            throw new EmptyStackException("pop reference");
        }
        Object o = this.rstack[--this.rTop];
        this.rstack[this.rTop] = null;
        if (log.isDebugEnabled()) {
            log.debug("pop reference " + ReflectionUtils.descriptionOfObject(o) + " " + this.getStats());
        }
        return o;
    }

    public final void pushDouble(double d) {
        if (log.isDebugEnabled()) {
            log.debug("push double " + d + " " + this.getStats());
        }
        this.ensurePrimitivesStackSize();
        this.pushPrimitive(Double.doubleToLongBits(d));
        ++this.dTop;
    }

    public final void pushFloat(float f) {
        if (log.isDebugEnabled()) {
            log.debug("push float " + f + " " + this.getStats());
        }
        this.ensurePrimitivesStackSize();
        this.pushPrimitive(Float.floatToIntBits(f));
        ++this.fTop;
    }

    public final void pushLong(long l) {
        if (log.isDebugEnabled()) {
            log.debug("push long " + l + " " + this.getStats());
        }
        this.ensurePrimitivesStackSize();
        this.pushPrimitive(l);
        ++this.lTop;
    }

    public final void pushInt(int i) {
        if (log.isDebugEnabled()) {
            log.debug("push int " + i + " " + this.getStats());
        }
        this.ensurePrimitivesStackSize();
        this.pushPrimitive(i);
        ++this.iTop;
    }

    public final void pushObject(Object o) {
        if (log.isDebugEnabled()) {
            log.debug("push object " + ReflectionUtils.descriptionOfObject(o) + " " + this.getStats());
        }
        if (this.oTop == this.ostack.length) {
            Object[] hlp = new Object[Math.max(8, this.ostack.length * 2)];
            System.arraycopy(this.ostack, 0, hlp, 0, this.ostack.length);
            this.ostack = hlp;
        }
        this.ostack[this.oTop++] = o;
    }

    public final void pushReference(Object o) {
        if (log.isDebugEnabled()) {
            log.debug("push reference " + ReflectionUtils.descriptionOfObject(o) + " " + this.getStats());
        }
        if (this.rTop == this.rstack.length) {
            Object[] hlp = new Object[Math.max(8, this.rstack.length * 2)];
            System.arraycopy(this.rstack, 0, hlp, 0, this.rstack.length);
            this.rstack = hlp;
        }
        this.rstack[this.rTop++] = o;
    }

    public boolean isSerializable() {
        int i;
        for (i = 0; i < this.rTop; ++i) {
            Object r = this.rstack[i];
            if (r instanceof Serializable) continue;
            return false;
        }
        for (i = 0; i < this.oTop; ++i) {
            Object o = this.ostack[i];
            if (o instanceof Serializable) continue;
            return false;
        }
        return true;
    }

    public final boolean isEmpty() {
        return this.iTop == 0 && this.lTop == 0 && this.dTop == 0 && this.fTop == 0 && this.oTop == 0 && this.rTop == 0;
    }

    public final Runnable getRunnable() {
        return this.runnable;
    }

    private String getStats() {
        StringBuilder sb = new StringBuilder();
        sb.append("i[").append(this.iTop).append("],");
        sb.append("l[").append(this.lTop).append("],");
        sb.append("d[").append(this.dTop).append("],");
        sb.append("f[").append(this.fTop).append("],");
        sb.append("o[").append(this.oTop).append("],");
        sb.append("r[").append(this.rTop).append("]");
        return sb.toString();
    }

    private String getContent() {
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append("i[").append(this.iTop).append("]\n");
        sb.append("l[").append(this.lTop).append("]\n");
        sb.append("d[").append(this.dTop).append("]\n");
        sb.append("f[").append(this.fTop).append("]\n");
        sb.append("o[").append(this.oTop).append("]\n");
        for (i = 0; i < this.oTop; ++i) {
            sb.append(' ').append(i).append(": ").append(ReflectionUtils.descriptionOfObject(this.ostack[i])).append('\n');
        }
        sb.append("r[").append(this.rTop).append("]\n");
        for (i = 0; i < this.rTop; ++i) {
            sb.append(' ').append(i).append(": ").append(ReflectionUtils.descriptionOfObject(this.rstack[i])).append('\n');
        }
        return sb.toString();
    }

    public String toString() {
        return this.getContent();
    }

    private final int pTop() {
        return this.dTop + this.fTop + this.lTop + this.iTop;
    }

    private final void pushPrimitive(long value) {
        this.pstack[this.pTop()] = value;
    }

    private final long popPrimitive() {
        return this.pstack[this.pTop()];
    }

    private final void ensurePrimitivesStackSize() {
        if (this.pTop() == this.pstack.length) {
            long[] hlp = new long[Math.max(8, this.pstack.length * 2)];
            System.arraycopy(this.pstack, 0, hlp, 0, this.pstack.length);
            this.pstack = hlp;
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        int i;
        s.writeInt(this.dTop);
        s.writeInt(this.fTop);
        s.writeInt(this.lTop);
        s.writeInt(this.iTop);
        int pTop = this.pTop();
        for (i = 0; i < pTop; ++i) {
            s.writeLong(this.pstack[i]);
        }
        s.writeInt(this.oTop);
        for (i = 0; i < this.oTop; ++i) {
            s.writeObject(this.ostack[i]);
        }
        s.writeInt(this.rTop);
        for (i = 0; i < this.rTop; ++i) {
            s.writeObject(this.rstack[i]);
        }
        s.writeObject(this.runnable);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        int i;
        this.dTop = s.readInt();
        this.fTop = s.readInt();
        this.lTop = s.readInt();
        this.iTop = s.readInt();
        int pTop = this.pTop();
        this.pstack = new long[pTop];
        for (i = 0; i < pTop; ++i) {
            this.pstack[i] = s.readLong();
        }
        this.oTop = s.readInt();
        this.ostack = new Object[this.oTop];
        for (i = 0; i < this.oTop; ++i) {
            this.ostack[i] = s.readObject();
        }
        this.rTop = s.readInt();
        this.rstack = new Object[this.rTop];
        for (i = 0; i < this.rTop; ++i) {
            this.rstack[i] = s.readObject();
        }
        this.runnable = (Runnable)s.readObject();
    }
}

