/*
 * Decompiled with CFR 0.152.
 */
package nu.xom;

import nu.xom.DocType;
import nu.xom.Element;
import nu.xom.IllegalAddException;
import nu.xom.MultipleParentException;
import nu.xom.Node;
import nu.xom.ParentNode;
import nu.xom.WellformednessException;

public class Document
extends ParentNode {
    public Document(Element element) {
        this._insertChild(element, 0);
    }

    public Document(Document document) {
        this.insertChild(document.getRootElement().copy(), 0);
        int n = document.getChildCount();
        for (int i = 0; i < n; ++i) {
            Node node = document.getChild(i);
            if (node.isElement()) continue;
            this.insertChild(node.copy(), i);
        }
        this.actualBaseURI = document.actualBaseURI;
    }

    @Override
    final void insertionAllowed(Node node, int n) {
        if (node == null) {
            throw new NullPointerException("Tried to insert a null child in the document");
        }
        if (node.getParent() != null) {
            throw new MultipleParentException("Child already has a parent.");
        }
        if (node.isComment() || node.isProcessingInstruction()) {
            return;
        }
        if (node.isDocType()) {
            if (n <= this.getRootPosition()) {
                DocType docType = this.getDocType();
                if (docType != null) {
                    throw new IllegalAddException("Tried to insert a second DOCTYPE");
                }
                return;
            }
            throw new IllegalAddException("Cannot add a document type declaration after the root element");
        }
        if (node.isElement()) {
            if (this.getChildCount() == 0) {
                return;
            }
            throw new IllegalAddException("Cannot add a second root element to a Document.");
        }
        throw new IllegalAddException("Cannot add a " + node.getClass().getName() + " to a Document.");
    }

    private int getRootPosition() {
        int n = 0;
        Node node;
        while (!(node = this.getChild(n)).isElement()) {
            ++n;
        }
        return n;
    }

    public final DocType getDocType() {
        for (int i = 0; i < this.getChildCount(); ++i) {
            Node node = this.getChild(i);
            if (!node.isDocType()) continue;
            return (DocType)node;
        }
        return null;
    }

    public void setDocType(DocType docType) {
        DocType docType2 = this.getDocType();
        if (docType == null) {
            throw new NullPointerException("Null DocType");
        }
        if (docType == docType2) {
            return;
        }
        if (docType.getParent() != null) {
            throw new MultipleParentException("DocType belongs to another document");
        }
        if (docType2 == null) {
            this.insertChild(docType, 0);
        } else {
            int n = this.indexOf(docType2);
            super.removeChild(n);
            this.fastInsertChild(docType, n);
            docType2.setParent(null);
            docType.setParent(this);
        }
    }

    public final Element getRootElement() {
        int n = 0;
        Node node;
        while (!(node = this.getChild(n)).isElement()) {
            ++n;
        }
        return (Element)node;
    }

    public void setRootElement(Element element) {
        Element element2 = this.getRootElement();
        if (element == element2) {
            return;
        }
        if (element == null) {
            throw new NullPointerException("Root element cannot be null");
        }
        if (element.getParent() != null) {
            throw new MultipleParentException(element.getQualifiedName() + " already has a parent");
        }
        this.fillInBaseURI(element2);
        int n = this.indexOf(element2);
        element2.setParent(null);
        this.children[n] = element;
        element.setParent(this);
    }

    @Override
    public void setBaseURI(String string) {
        this.setActualBaseURI(string);
    }

    @Override
    public final String getBaseURI() {
        return this.getActualBaseURI();
    }

    @Override
    public Node removeChild(int n) {
        if (n == this.getRootPosition()) {
            throw new WellformednessException("Cannot remove the root element");
        }
        return super.removeChild(n);
    }

    @Override
    public Node removeChild(Node node) {
        if (node == this.getRootElement()) {
            throw new WellformednessException("Cannot remove the root element");
        }
        return super.removeChild(node);
    }

    @Override
    public void replaceChild(Node node, Node node2) {
        if (node == this.getRootElement() && node2 != null && node2.isElement()) {
            this.setRootElement((Element)node2);
        } else if (node == this.getDocType() && node2 != null && node2.isDocType()) {
            this.setDocType((DocType)node2);
        } else {
            super.replaceChild(node, node2);
        }
    }

    @Override
    public final String getValue() {
        return this.getRootElement().getValue();
    }

    @Override
    public final String toXML() {
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append("<?xml version=\"1.0\"?>\n");
        for (int i = 0; i < this.getChildCount(); ++i) {
            stringBuffer.append(this.getChild(i).toXML());
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    @Override
    public Node copy() {
        return new Document(this);
    }

    @Override
    boolean isDocument() {
        return true;
    }

    public final String toString() {
        return "[" + this.getClass().getName() + ": " + this.getRootElement().getQualifiedName() + "]";
    }
}

