/*
 * Decompiled with CFR 0.152.
 */
package nu.xom;

import java.util.ArrayList;
import nu.xom.Attribute;
import nu.xom.DocType;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.IllegalAddException;
import nu.xom.Node;
import nu.xom.NodeFactory;
import nu.xom.Nodes;
import nu.xom.ParentNode;
import nu.xom.URIUtil;
import nu.xom.WellformednessException;
import nu.xom.XMLException;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;

class XOMHandler
implements ContentHandler,
LexicalHandler,
DeclHandler,
DTDHandler {
    protected Document document;
    protected String documentBaseURI;
    protected ParentNode parent;
    protected ParentNode current;
    protected ArrayList parents;
    protected boolean inProlog;
    protected boolean inDTD;
    protected int position;
    protected Locator locator;
    protected DocType doctype;
    protected StringBuffer internalDTDSubset;
    protected NodeFactory factory;
    boolean usingCrimson = false;
    protected String textString = null;
    protected StringBuffer buffer = null;
    protected boolean inExternalSubset = false;
    protected boolean inCDATA = false;
    protected boolean finishedCDATA = false;

    XOMHandler(NodeFactory nodeFactory) {
        this.factory = nodeFactory;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    Document getDocument() {
        return this.document;
    }

    void freeMemory() {
        this.document = null;
        this.parent = null;
        this.current = null;
        this.parents = null;
        this.locator = null;
        this.doctype = null;
        this.internalDTDSubset = null;
        System.gc();
    }

    @Override
    public void startDocument() {
        this.inDTD = false;
        this.document = this.factory.startMakingDocument();
        this.parent = this.document;
        this.current = this.document;
        this.parents = new ArrayList();
        this.parents.add(this.document);
        this.inProlog = true;
        this.position = 0;
        this.textString = null;
        this.doctype = null;
        if (this.locator != null) {
            this.documentBaseURI = this.locator.getSystemId();
            this.document.setBaseURI(this.documentBaseURI);
        }
        this.buffer = null;
    }

    @Override
    public void endDocument() {
        this.factory.finishMakingDocument(this.document);
        this.parents.remove(this.parents.size() - 1);
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        Element element;
        this.flushText();
        if (this.parent != this.document) {
            element = this.factory.startMakingElement(string3, string);
        } else {
            element = this.factory.makeRootElement(string3, string);
            if (element == null) {
                throw new NullPointerException("Factory failed to create root element.");
            }
            this.document.setRootElement(element);
            this.inProlog = false;
        }
        this.current = element;
        this.parents.add(element);
        if (element != null) {
            Object object;
            String string4;
            String string5;
            String string6;
            int n;
            String string7;
            if (this.parent != this.document) {
                this.parent.appendChild(element);
            }
            if (this.locator != null && (string7 = this.locator.getSystemId()) != null && !string7.equals(this.documentBaseURI)) {
                element.setActualBaseURI(string7);
            }
            for (n = 0; n < attributes.getLength(); ++n) {
                string6 = attributes.getQName(n);
                if (string6.startsWith("xmlns:") || string6.equals("xmlns")) continue;
                string5 = attributes.getURI(n);
                string4 = attributes.getValue(n);
                object = this.factory.makeAttribute(string6, string5, string4, XOMHandler.convertStringToType(attributes.getType(n)));
                int n2 = 0;
                for (int i = 0; i < ((Nodes)object).size(); ++i) {
                    Node node = ((Nodes)object).get(i);
                    if (node.isAttribute()) {
                        this.factory.addAttribute(element, (Attribute)node);
                        continue;
                    }
                    this.factory.insertChild(element, node, n2++);
                }
            }
            for (n = 0; n < attributes.getLength(); ++n) {
                string6 = attributes.getQName(n);
                if (string6.startsWith("xmlns:")) {
                    string5 = attributes.getValue(n);
                    if (string5.equals(object = element.getNamespaceURI(string4 = string6.substring(6))) || string4.equals(element.getNamespacePrefix())) continue;
                    element.addNamespaceDeclaration(string4, string5);
                    continue;
                }
                if (!string6.equals("xmlns") || (string5 = attributes.getValue(n)).equals(object = element.getNamespaceURI(string4 = "")) || "".equals(element.getNamespacePrefix())) continue;
                element.addNamespaceDeclaration(string4, string5);
            }
            this.parent = element;
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) {
        this.current = (ParentNode)this.parents.remove(this.parents.size() - 1);
        this.flushText();
        if (this.current != null) {
            this.parent = this.current.getParent();
            Nodes nodes = this.factory.finishMakingElement((Element)this.current);
            if (nodes.size() != 1 || nodes.get(0) != this.current) {
                if (!this.parent.isDocument()) {
                    int n = this.parent.getChildCount();
                    try {
                        this.parent.removeChild(n - 1);
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        throw new XMLException("Factory detached element in finishMakingElement()", indexOutOfBoundsException);
                    }
                    for (int i = 0; i < nodes.size(); ++i) {
                        Node node = nodes.get(i);
                        if (node.isAttribute()) {
                            ((Element)this.parent).addAttribute((Attribute)node);
                            continue;
                        }
                        this.parent.appendChild(node);
                    }
                } else {
                    Document document = (Document)this.parent;
                    Element element = document.getRootElement();
                    boolean bl = true;
                    for (int i = 0; i < nodes.size(); ++i) {
                        Node node = nodes.get(i);
                        if (node.isElement()) {
                            if (node != element) {
                                if (!bl) {
                                    throw new IllegalAddException("Factory returned multiple roots");
                                }
                                document.setRootElement((Element)node);
                            }
                            bl = false;
                            continue;
                        }
                        if (bl) {
                            document.insertChild(node, document.indexOf(document.getRootElement()));
                            continue;
                        }
                        document.appendChild(node);
                    }
                    if (bl) {
                        throw new WellformednessException("Factory attempted to remove the root element");
                    }
                }
            }
        }
    }

    static Attribute.Type convertStringToType(String string) {
        if (string.equals("CDATA")) {
            return Attribute.Type.CDATA;
        }
        if (string.equals("ID")) {
            return Attribute.Type.ID;
        }
        if (string.equals("IDREF")) {
            return Attribute.Type.IDREF;
        }
        if (string.equals("IDREFS")) {
            return Attribute.Type.IDREFS;
        }
        if (string.equals("NMTOKEN")) {
            return Attribute.Type.NMTOKEN;
        }
        if (string.equals("NMTOKENS")) {
            return Attribute.Type.NMTOKENS;
        }
        if (string.equals("ENTITY")) {
            return Attribute.Type.ENTITY;
        }
        if (string.equals("ENTITIES")) {
            return Attribute.Type.ENTITIES;
        }
        if (string.equals("NOTATION")) {
            return Attribute.Type.NOTATION;
        }
        if (string.equals("ENUMERATION")) {
            return Attribute.Type.ENUMERATION;
        }
        if (string.startsWith("(")) {
            return Attribute.Type.ENUMERATION;
        }
        return Attribute.Type.UNDECLARED;
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (n2 <= 0) {
            return;
        }
        if (this.textString == null) {
            this.textString = new String(cArray, n, n2);
        } else {
            if (this.buffer == null) {
                this.buffer = new StringBuffer(this.textString);
            }
            this.buffer.append(cArray, n, n2);
        }
        if (this.finishedCDATA) {
            this.inCDATA = false;
        }
    }

    private void flushText() {
        if (this.buffer != null) {
            this.textString = this.buffer.toString();
            this.buffer = null;
        }
        if (this.textString != null) {
            Nodes nodes = !this.inCDATA ? this.factory.makeText(this.textString) : this.factory.makeCDATASection(this.textString);
            for (int i = 0; i < nodes.size(); ++i) {
                Node node = nodes.get(i);
                if (node.isAttribute()) {
                    ((Element)this.parent).addAttribute((Attribute)node);
                    continue;
                }
                this.parent.appendChild(node);
            }
            this.textString = null;
        }
        this.inCDATA = false;
        this.finishedCDATA = false;
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        this.characters(cArray, n, n2);
    }

    @Override
    public void processingInstruction(String string, String string2) throws SAXException {
        if (!this.inDTD) {
            this.flushText();
        }
        if (this.inDTD && !this.inInternalSubset()) {
            return;
        }
        Nodes nodes = this.factory.makeProcessingInstruction(string, string2);
        for (int i = 0; i < nodes.size(); ++i) {
            Node node = nodes.get(i);
            if (!this.inDTD) {
                if (this.inProlog) {
                    this.parent.insertChild(node, this.position);
                    ++this.position;
                    continue;
                }
                if (node.isAttribute()) {
                    ((Element)this.parent).addAttribute((Attribute)node);
                    continue;
                }
                this.parent.appendChild(node);
                continue;
            }
            if (node.isProcessingInstruction() || node.isComment()) {
                this.internalDTDSubset.append("  ");
                this.internalDTDSubset.append(node.toXML());
                this.internalDTDSubset.append("\n");
                continue;
            }
            throw new XMLException("Factory tried to put a " + node.getClass().getName() + " in the internal DTD subset");
        }
    }

    @Override
    public void startPrefixMapping(String string, String string2) {
    }

    @Override
    public void endPrefixMapping(String string) {
    }

    @Override
    public void skippedEntity(String string) {
        if (string.startsWith("%")) {
            return;
        }
        this.flushText();
        throw new XMLException("Could not resolve entity " + string);
    }

    @Override
    public void startDTD(String string, String string2, String string3) throws SAXException {
        this.inDTD = true;
        Nodes nodes = this.factory.makeDocType(string, string2, string3);
        for (int i = 0; i < nodes.size(); ++i) {
            Node node = nodes.get(i);
            this.document.insertChild(node, this.position);
            ++this.position;
            if (!node.isDocType()) continue;
            DocType docType = (DocType)node;
            this.internalDTDSubset = new StringBuffer();
            this.doctype = docType;
        }
    }

    @Override
    public void endDTD() {
        this.inDTD = false;
        if (this.doctype != null) {
            this.doctype.setInternalDTDSubset(this.internalDTDSubset.toString());
        }
    }

    @Override
    public void startEntity(String string) {
        if (string.equals("[dtd]")) {
            this.inExternalSubset = true;
        }
    }

    @Override
    public void endEntity(String string) {
        if (string.equals("[dtd]")) {
            this.inExternalSubset = false;
        }
    }

    @Override
    public void startCDATA() {
        if (this.textString == null) {
            this.inCDATA = true;
        }
        this.finishedCDATA = false;
    }

    @Override
    public void endCDATA() {
        this.finishedCDATA = true;
    }

    @Override
    public void comment(char[] cArray, int n, int n2) throws SAXException {
        if (!this.inDTD) {
            this.flushText();
        }
        if (this.inDTD && !this.inInternalSubset()) {
            return;
        }
        Nodes nodes = this.factory.makeComment(new String(cArray, n, n2));
        for (int i = 0; i < nodes.size(); ++i) {
            Node node = nodes.get(i);
            if (!this.inDTD) {
                if (this.inProlog) {
                    this.parent.insertChild(node, this.position);
                    ++this.position;
                    continue;
                }
                if (node instanceof Attribute) {
                    ((Element)this.parent).addAttribute((Attribute)node);
                    continue;
                }
                this.parent.appendChild(node);
                continue;
            }
            if (node.isComment() || node.isProcessingInstruction()) {
                this.internalDTDSubset.append("  ");
                this.internalDTDSubset.append(node.toXML());
                this.internalDTDSubset.append("\n");
                continue;
            }
            throw new XMLException("Factory tried to put a " + node.getClass().getName() + " in the internal DTD subset");
        }
    }

    @Override
    public void elementDecl(String string, String string2) {
        if (this.inInternalSubset() && this.doctype != null) {
            this.internalDTDSubset.append("  <!ELEMENT ");
            this.internalDTDSubset.append(string);
            this.internalDTDSubset.append(' ');
            this.internalDTDSubset.append(string2);
            if (string2.indexOf("#PCDATA") > 0 && string2.indexOf(124) > 0 && string2.endsWith(")")) {
                this.internalDTDSubset.append('*');
            }
            this.internalDTDSubset.append(">\n");
        }
    }

    protected boolean inInternalSubset() {
        if (!this.usingCrimson) {
            return !this.inExternalSubset;
        }
        String string = this.locator.getSystemId();
        if (string == this.documentBaseURI) {
            return true;
        }
        if (string == null) {
            return false;
        }
        return string.equals(this.documentBaseURI);
    }

    @Override
    public void attributeDecl(String string, String string2, String string3, String string4, String string5) {
        if (string3.startsWith("NOTATION ") && string3.indexOf(40) == -1 && !string3.endsWith(")")) {
            string3 = "NOTATION (" + string3.substring("NOTATION ".length()) + ")";
        }
        if (this.inInternalSubset() && this.doctype != null) {
            this.internalDTDSubset.append("  <!ATTLIST ");
            this.internalDTDSubset.append(string);
            this.internalDTDSubset.append(' ');
            this.internalDTDSubset.append(string2);
            this.internalDTDSubset.append(' ');
            this.internalDTDSubset.append(string3);
            if (string4 != null) {
                this.internalDTDSubset.append(' ');
                this.internalDTDSubset.append(string4);
            }
            if (string5 != null) {
                this.internalDTDSubset.append(' ');
                this.internalDTDSubset.append('\"');
                this.internalDTDSubset.append(XOMHandler.escapeReservedCharactersInDefaultAttributeValues(string5));
                this.internalDTDSubset.append('\"');
            }
            this.internalDTDSubset.append(">\n");
        }
    }

    @Override
    public void internalEntityDecl(String string, String string2) {
        if (this.inInternalSubset() && this.doctype != null) {
            this.internalDTDSubset.append("  <!ENTITY ");
            if (string.startsWith("%")) {
                this.internalDTDSubset.append("% ");
                this.internalDTDSubset.append(string.substring(1));
            } else {
                this.internalDTDSubset.append(string);
            }
            this.internalDTDSubset.append(" \"");
            this.internalDTDSubset.append(XOMHandler.escapeReservedCharactersInDeclarations(string2));
            this.internalDTDSubset.append("\">\n");
        }
    }

    @Override
    public void externalEntityDecl(String string, String string2, String string3) {
        if (this.inInternalSubset() && this.doctype != null) {
            String string4;
            this.internalDTDSubset.append("  <!ENTITY ");
            if (string.startsWith("%")) {
                this.internalDTDSubset.append("% ");
                this.internalDTDSubset.append(string.substring(1));
            } else {
                this.internalDTDSubset.append(string);
            }
            if (this.locator != null && URIUtil.isAbsolute(string3) && (string4 = this.locator.getSystemId()) != null) {
                if (string4.startsWith("file:/") && !string4.startsWith("file:///")) {
                    string4 = "file://" + string4.substring(5);
                }
                if (string3.startsWith("file:/") && !string3.startsWith("file:///")) {
                    string3 = "file://" + string3.substring(5);
                }
                string3 = URIUtil.relativize(string4, string3);
            }
            if (string2 != null) {
                this.internalDTDSubset.append(" PUBLIC \"");
                this.internalDTDSubset.append(string2);
                this.internalDTDSubset.append("\" \"");
                this.internalDTDSubset.append(string3);
            } else {
                this.internalDTDSubset.append(" SYSTEM \"");
                this.internalDTDSubset.append(string3);
            }
            this.internalDTDSubset.append("\">\n");
        }
    }

    @Override
    public void notationDecl(String string, String string2, String string3) {
        if (string3 != null) {
            string3 = XOMHandler.escapeReservedCharactersInDeclarations(string3);
        }
        if (this.inInternalSubset() && this.doctype != null) {
            this.internalDTDSubset.append("  <!NOTATION ");
            this.internalDTDSubset.append(string);
            if (string2 != null) {
                this.internalDTDSubset.append(" PUBLIC \"");
                this.internalDTDSubset.append(string2);
                this.internalDTDSubset.append('\"');
                if (string3 != null) {
                    this.internalDTDSubset.append(" \"");
                    this.internalDTDSubset.append(string3);
                    this.internalDTDSubset.append('\"');
                }
            } else {
                this.internalDTDSubset.append(" SYSTEM \"");
                this.internalDTDSubset.append(string3);
                this.internalDTDSubset.append('\"');
            }
            this.internalDTDSubset.append(">\n");
        }
    }

    @Override
    public void unparsedEntityDecl(String string, String string2, String string3, String string4) {
        if (this.inInternalSubset() && this.doctype != null) {
            this.internalDTDSubset.append("  <!ENTITY ");
            if (string2 != null) {
                this.internalDTDSubset.append(string);
                this.internalDTDSubset.append(" PUBLIC \"");
                this.internalDTDSubset.append(string2);
                this.internalDTDSubset.append("\" \"");
                this.internalDTDSubset.append(string3);
                this.internalDTDSubset.append("\" NDATA ");
                this.internalDTDSubset.append(string4);
            } else {
                this.internalDTDSubset.append(string);
                this.internalDTDSubset.append(" SYSTEM \"");
                this.internalDTDSubset.append(string3);
                this.internalDTDSubset.append("\" NDATA ");
                this.internalDTDSubset.append(string4);
            }
            this.internalDTDSubset.append(">\n");
        }
    }

    private static String escapeReservedCharactersInDeclarations(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        block28: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\r': {
                    stringBuffer.append("&#x0D;");
                    continue block28;
                }
                case '\u000e': {
                    continue block28;
                }
                case '\u000f': {
                    continue block28;
                }
                case '\u0010': {
                    continue block28;
                }
                case '\u0011': {
                    continue block28;
                }
                case '\u0012': {
                    continue block28;
                }
                case '\u0013': {
                    continue block28;
                }
                case '\u0014': {
                    continue block28;
                }
                case '\u0015': {
                    continue block28;
                }
                case '\u0016': {
                    continue block28;
                }
                case '\u0017': {
                    continue block28;
                }
                case '\u0018': {
                    continue block28;
                }
                case '\u0019': {
                    continue block28;
                }
                case '\u001a': {
                    continue block28;
                }
                case '\u001b': {
                    continue block28;
                }
                case '\u001c': {
                    continue block28;
                }
                case '\u001d': {
                    continue block28;
                }
                case '\u001e': {
                    continue block28;
                }
                case '\u001f': {
                    continue block28;
                }
                case ' ': {
                    stringBuffer.append(' ');
                    continue block28;
                }
                case '!': {
                    stringBuffer.append('!');
                    continue block28;
                }
                case '\"': {
                    stringBuffer.append("&#x22;");
                    continue block28;
                }
                case '#': {
                    stringBuffer.append('#');
                    continue block28;
                }
                case '$': {
                    stringBuffer.append('$');
                    continue block28;
                }
                case '%': {
                    stringBuffer.append("&#x25;");
                    continue block28;
                }
                case '&': {
                    stringBuffer.append("&#x26;");
                    continue block28;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    private static String escapeReservedCharactersInDefaultAttributeValues(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        block50: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\r': {
                    stringBuffer.append("&#x0D;");
                    continue block50;
                }
                case '\u000e': {
                    continue block50;
                }
                case '\u000f': {
                    continue block50;
                }
                case '\u0010': {
                    continue block50;
                }
                case '\u0011': {
                    continue block50;
                }
                case '\u0012': {
                    continue block50;
                }
                case '\u0013': {
                    continue block50;
                }
                case '\u0014': {
                    continue block50;
                }
                case '\u0015': {
                    continue block50;
                }
                case '\u0016': {
                    continue block50;
                }
                case '\u0017': {
                    continue block50;
                }
                case '\u0018': {
                    continue block50;
                }
                case '\u0019': {
                    continue block50;
                }
                case '\u001a': {
                    continue block50;
                }
                case '\u001b': {
                    continue block50;
                }
                case '\u001c': {
                    continue block50;
                }
                case '\u001d': {
                    continue block50;
                }
                case '\u001e': {
                    continue block50;
                }
                case '\u001f': {
                    continue block50;
                }
                case ' ': {
                    stringBuffer.append(' ');
                    continue block50;
                }
                case '!': {
                    stringBuffer.append('!');
                    continue block50;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    continue block50;
                }
                case '#': {
                    stringBuffer.append('#');
                    continue block50;
                }
                case '$': {
                    stringBuffer.append('$');
                    continue block50;
                }
                case '%': {
                    stringBuffer.append("&#x25;");
                    continue block50;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    continue block50;
                }
                case '\'': {
                    stringBuffer.append('\'');
                    continue block50;
                }
                case '(': {
                    stringBuffer.append('(');
                    continue block50;
                }
                case ')': {
                    stringBuffer.append(')');
                    continue block50;
                }
                case '*': {
                    stringBuffer.append('*');
                    continue block50;
                }
                case '+': {
                    stringBuffer.append('+');
                    continue block50;
                }
                case ',': {
                    stringBuffer.append(',');
                    continue block50;
                }
                case '-': {
                    stringBuffer.append('-');
                    continue block50;
                }
                case '.': {
                    stringBuffer.append('.');
                    continue block50;
                }
                case '/': {
                    stringBuffer.append('/');
                    continue block50;
                }
                case '0': {
                    stringBuffer.append('0');
                    continue block50;
                }
                case '1': {
                    stringBuffer.append('1');
                    continue block50;
                }
                case '2': {
                    stringBuffer.append('2');
                    continue block50;
                }
                case '3': {
                    stringBuffer.append('3');
                    continue block50;
                }
                case '4': {
                    stringBuffer.append('4');
                    continue block50;
                }
                case '5': {
                    stringBuffer.append('5');
                    continue block50;
                }
                case '6': {
                    stringBuffer.append('6');
                    continue block50;
                }
                case '7': {
                    stringBuffer.append('7');
                    continue block50;
                }
                case '8': {
                    stringBuffer.append('8');
                    continue block50;
                }
                case '9': {
                    stringBuffer.append('9');
                    continue block50;
                }
                case ':': {
                    stringBuffer.append(':');
                    continue block50;
                }
                case ';': {
                    stringBuffer.append(';');
                    continue block50;
                }
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block50;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }
}

