/*
 * Decompiled with CFR 0.152.
 */
package nu.xom.xslt;

import java.util.ArrayList;
import nu.xom.Attribute;
import nu.xom.Element;
import nu.xom.NamespaceConflictException;
import nu.xom.Node;
import nu.xom.NodeFactory;
import nu.xom.Nodes;
import nu.xom.ParentNode;
import nu.xom.XMLException;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;

class XSLTHandler
implements ContentHandler,
LexicalHandler {
    private final Nodes result;
    private final ArrayList parents;
    private final NodeFactory factory;
    private StringBuffer buffer;
    private Element current;
    private AttributesImpl namespaceDeclarations = new AttributesImpl();

    XSLTHandler(NodeFactory nodeFactory) {
        this.factory = nodeFactory;
        this.result = new Nodes();
        this.parents = new ArrayList();
        this.buffer = new StringBuffer();
    }

    Nodes getResult() {
        this.flushText();
        return this.result;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void startDocument() {
    }

    @Override
    public void endDocument() {
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) {
        Object object;
        String string4;
        String string5;
        String string6;
        int n;
        this.flushText();
        int n2 = attributes.getLength();
        for (int i = 0; i < n2; ++i) {
            this.namespaceDeclarations.addAttribute(attributes.getURI(i), attributes.getLocalName(i), attributes.getQName(i), attributes.getType(i), attributes.getValue(i));
        }
        attributes = this.namespaceDeclarations;
        Element element = this.factory.startMakingElement(string3, string);
        if (this.parents.isEmpty()) {
            this.current = element;
        } else {
            ParentNode parentNode = (ParentNode)this.parents.get(this.parents.size() - 1);
            parentNode.appendChild(element);
        }
        this.parents.add(element);
        n2 = attributes.getLength();
        for (n = 0; n < n2; ++n) {
            string6 = attributes.getQName(n);
            if (string6.equals("xmlns") || string6.startsWith("xmlns:")) continue;
            string5 = attributes.getURI(n);
            string4 = attributes.getValue(n);
            object = this.factory.makeAttribute(string6, string5, string4, Attribute.Type.UNDECLARED);
            int n3 = ((Nodes)object).size();
            block8: for (int i = 0; i < n3; ++i) {
                Node node = ((Nodes)object).get(i);
                if (node instanceof Attribute) {
                    Attribute attribute = (Attribute)node;
                    while (true) {
                        try {
                            element.addAttribute(attribute);
                            continue block8;
                        }
                        catch (NamespaceConflictException namespaceConflictException) {
                            attribute.setNamespace("p" + attribute.getNamespacePrefix(), attribute.getNamespaceURI());
                            continue;
                        }
                        break;
                    }
                }
                element.appendChild(node);
            }
        }
        for (n = 0; n < n2; ++n) {
            string6 = attributes.getQName(n);
            if (string6.startsWith("xmlns:")) {
                string5 = attributes.getValue(n);
                if (string5.equals(object = element.getNamespaceURI(string4 = string6.substring(6)))) continue;
                try {
                    element.addNamespaceDeclaration(string4, string5);
                }
                catch (NamespaceConflictException namespaceConflictException) {}
                continue;
            }
            if (!string6.equals("xmlns")) continue;
            string5 = attributes.getValue(n);
            if (string5 == null) {
                string5 = "";
            }
            if (string5.equals(object = element.getNamespaceURI(string4 = ""))) continue;
            try {
                element.addNamespaceDeclaration(string4, string5);
                continue;
            }
            catch (NamespaceConflictException namespaceConflictException) {
                if (!"http://www.w3.org/XML/1998/namespace".equals(string5) || !"".equals(string4)) continue;
                element.addNamespaceDeclaration("", "");
            }
        }
        this.namespaceDeclarations = new AttributesImpl();
    }

    @Override
    public void endElement(String string, String string2, String string3) {
        this.flushText();
        Element element = (Element)this.parents.remove(this.parents.size() - 1);
        if (this.parents.isEmpty()) {
            Nodes nodes = this.factory.finishMakingElement(this.current);
            for (int i = 0; i < nodes.size(); ++i) {
                this.result.append(nodes.get(i));
            }
            this.current = null;
        } else {
            Nodes nodes = this.factory.finishMakingElement(element);
            ParentNode parentNode = element.getParent();
            element.detach();
            for (int i = 0; i < nodes.size(); ++i) {
                Node node = nodes.get(i);
                if (node instanceof Attribute) {
                    ((Element)parentNode).addAttribute((Attribute)node);
                    continue;
                }
                parentNode.appendChild(node);
            }
        }
    }

    @Override
    public void characters(char[] cArray, int n, int n2) {
        this.buffer.append(cArray, n, n2);
    }

    private void flushText() {
        if (this.buffer.length() > 0) {
            Nodes nodes = this.factory.makeText(this.buffer.toString());
            this.addToResultTree(nodes);
            this.buffer = new StringBuffer();
        }
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n, int n2) {
        this.characters(cArray, n, n2);
    }

    @Override
    public void processingInstruction(String string, String string2) throws SAXException {
        if ("saxon:warning".equals(string)) {
            throw new SAXException("continue");
        }
        if ("javax.xml.transform.disable-output-escaping".equals(string) || "javax.xml.transform.enable-output-escaping".equals(string)) {
            return;
        }
        this.flushText();
        int n = string2.indexOf("?>");
        while (n != -1) {
            string2 = string2.substring(0, n) + "? >" + string2.substring(n + 2);
            n = string2.indexOf("?>");
        }
        Nodes nodes = this.factory.makeProcessingInstruction(string, string2);
        this.addToResultTree(nodes);
    }

    private void addToResultTree(Nodes nodes) {
        if (this.parents.isEmpty()) {
            for (int i = 0; i < nodes.size(); ++i) {
                this.result.append(nodes.get(i));
            }
        } else {
            ParentNode parentNode = (ParentNode)this.parents.get(this.parents.size() - 1);
            for (int i = 0; i < nodes.size(); ++i) {
                Node node = nodes.get(i);
                if (node instanceof Attribute) {
                    ((Element)parentNode).addAttribute((Attribute)node);
                    continue;
                }
                parentNode.appendChild(node);
            }
        }
    }

    @Override
    public void endPrefixMapping(String string) {
    }

    @Override
    public void startPrefixMapping(String string, String string2) {
        if ("".equals(string)) {
            this.namespaceDeclarations.addAttribute("", "xmlns", "xmlns", "CDATA", string2);
        } else {
            this.namespaceDeclarations.addAttribute("", "xmlns:" + string, "xmlns:" + string, "CDATA", string2);
        }
    }

    @Override
    public void skippedEntity(String string) {
        this.flushText();
        throw new XMLException("Could not resolve entity " + string);
    }

    @Override
    public void startCDATA() {
    }

    @Override
    public void endCDATA() {
    }

    @Override
    public void startDTD(String string, String string2, String string3) {
    }

    @Override
    public void endDTD() {
    }

    @Override
    public void startEntity(String string) {
    }

    @Override
    public void endEntity(String string) {
    }

    @Override
    public void comment(char[] cArray, int n, int n2) {
        this.flushText();
        String string = new String(cArray, n, n2);
        int n3 = string.indexOf("--");
        while (n3 != -1) {
            string = string.substring(0, n3) + "- -" + string.substring(n3 + 2);
            n3 = string.indexOf("--");
        }
        if (string.endsWith("-")) {
            string = string + ' ';
        }
        this.addToResultTree(this.factory.makeComment(string));
    }
}

