/*
 * ====================================================================
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 *
 */
package org.apache.http.benchmark;

import java.io.IOException;
import java.io.OutputStream;

import org.apache.http.entity.ContentProducer;
import org.apache.http.entity.FileEntity;

public class BustaContentProducer implements ContentProducer {

    private static StringBuffer header;
    private static FileEntity payload;

    private static final String SOAP_START = "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\r\n<soapenv:Header>\r\n";
    private static final String SOAP_BODY_START = "</soapenv:Header>\r\n<soapenv:Body>\r\n";
    private static final String SOAP_END = "</soapenv:Body>\r\n</soapenv:Envelope>\r\n";




    public BustaContentProducer(final StringBuffer h ,final FileEntity p){
        header = h ;
        payload = p ;
    }

    public long getContentLength() {

        // update Length
        try{
            this.writeTo(null); // con null vengono solo calcolati i templates
        }catch(final Exception e){
            throw new RuntimeException(e.getMessage(),e);
        }

        final long payloadLength = payload.getContentLength();

        final long newCount = (header.length() - this.templateLength) + this.templateReplacedValueLength + payloadLength +
                SOAP_START.getBytes().length + SOAP_BODY_START.getBytes().length + SOAP_END.getBytes().length ;
        //System.out.println("newX:"+newCount);
        return newCount;
    }




    private long templateLength = 0;
    private long templateReplacedValueLength = 0;
    private long actualCount = -1;



    public void writeTo(final OutputStream os) throws IOException {

        if(os!=null){
            os.write(SOAP_START.getBytes());
            os.flush();
        }

        this.templateLength = 0;
        this.templateReplacedValueLength = 0;

        // Scrivo l'header http sostituendo i templates
        final TemplateUtils tUtils = new TemplateUtils();
        tUtils.template(header, os, this.actualCount, false);
        this.templateLength = tUtils.templateLength;
        this.templateReplacedValueLength = tUtils.templateReplacedValueLength;
        this.actualCount = tUtils.actualCountCalcolato;

        if(os!=null){

            os.write(SOAP_BODY_START.getBytes());

            // write payload
            payload.writeTo(os);

            //os.write("\n".getBytes());
            os.write(SOAP_END.getBytes());
            os.flush();

        }
    }


    public void stop() {
        TemplateUtils.stopCountInMinute();
    }
}
