/*
 * ====================================================================
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 *
 */

package org.apache.http.benchmark;

import java.io.IOException;
import java.io.OutputStream;

import org.apache.http.entity.ContentProducer;

public class XmlTemplateContentProducer implements ContentProducer {

    private static StringBuffer payload;


    public XmlTemplateContentProducer(final StringBuffer p){
        payload = p ;
    }

    public long getContentLength() {

        // update Length
        try{
            this.writeTo(null); // con null vengono solo calcolati i templates
        }catch(final Exception e){
            throw new RuntimeException(e.getMessage(),e);
        }

        final long newCount = (payload.length() - this.templateLength) + this.templateReplacedValueLength;
        //System.out.println("newX:"+newCount);
        return newCount;
    }


    private long templateLength = 0;
    private long templateReplacedValueLength = 0;
    private long actualCount = -1;

    public void writeTo(final OutputStream os) throws IOException {

        this.templateLength = 0;
        this.templateReplacedValueLength = 0;

        // Scrivo l'header http sostituendo i templates
        final TemplateUtils tUtils = new TemplateUtils();
        tUtils.template(payload, os, this.actualCount, true);
        this.templateLength = tUtils.templateLength;
        this.templateReplacedValueLength = tUtils.templateReplacedValueLength;
        //System.out.println("templateLength["+templateLength+"]");
        //System.out.println("templateReplacedValueLength["+templateReplacedValueLength+"]");
        this.actualCount = tUtils.actualCountCalcolato;

    }

    public void stop() {
        TemplateUtils.stopCountAbsolute();
    }
}
