package org.openapi4j.core.model.v3;

/**
 * All the keywords for Open API 3 Schema Object.
 */
public final class OAI3SchemaKeywords {
  private OAI3SchemaKeywords() {}

  public static final String ADDITIONALPROPERTIES = "additionalProperties";
  public static final String ALLOF = "allOf";
  public static final String ANYOF = "anyOf";
  public static final String DEFAULT = "default";
  public static final String DEPENDENCIES = "dependencies";
  public static final String DISCRIMINATOR = "discriminator";
  public static final String ENUM = "enum";
  public static final String FORMAT = "format";
  public static final String ITEMS = "items";
  public static final String MAXIMUM = "maximum";
  public static final String EXCLUSIVEMAXIMUM = "exclusiveMaximum";
  public static final String MAXITEMS = "maxItems";
  public static final String MAXLENGTH = "maxLength";
  public static final String MAXPROPERTIES = "maxProperties";
  public static final String MINIMUM = "minimum";
  public static final String EXCLUSIVEMINIMUM = "exclusiveMinimum";
  public static final String MAPPING = "mapping";
  public static final String MINITEMS = "minItems";
  public static final String MINLENGTH = "minLength";
  public static final String MINPROPERTIES = "minProperties";
  public static final String MULTIPLEOF = "multipleOf";
  public static final String NOT = "not";
  public static final String NULLABLE = "nullable";
  public static final String ONEOF = "oneOf";
  public static final String PATTERNPROPERTIES = "patternProperties";
  public static final String PATTERN = "pattern";
  public static final String PROPERTIES = "properties";
  public static final String PROPERTYNAME = "propertyName";
  public static final String $REF = "$ref";
  public static final String REQUIRED = "required";
  public static final String TYPE = "type";
  public static final String UNIQUEITEMS = "uniqueItems";

  public static final String TYPE_ARRAY = "array";
  public static final String TYPE_BOOLEAN = "boolean";
  public static final String TYPE_INTEGER = "integer";
  public static final String TYPE_NUMBER = "number";
  public static final String TYPE_OBJECT = "object";
  public static final String TYPE_STRING = "string";

  public static final String FORMAT_INT32 = "int32";
  public static final String FORMAT_INT64 = "int64";
  public static final String FORMAT_FLOAT = "float";
  public static final String FORMAT_DOUBLE = "double";
  public static final String FORMAT_BYTE = "byte";
  public static final String FORMAT_BINARY = "binary";
  public static final String FORMAT_BASE64 = "base64";
  public static final String FORMAT_PASSWORD = "password";
  public static final String FORMAT_DATE = "date";
  public static final String FORMAT_DATE_TIME = "date-time";
  public static final String FORMAT_EMAIL = "email";
  public static final String FORMAT_HOSTNAME = "hostname";
  public static final String FORMAT_IPV4 = "ipv4";
  public static final String FORMAT_IPV6 = "ipv6";
  public static final String FORMAT_URI = "uri";
  public static final String FORMAT_URIREF = "uriref";
  public static final String FORMAT_URI_REFERENCE = "uri-reference";
  public static final String FORMAT_UUID = "uuid";
}
