

-- GovWay Runtime

-- **** Repository Buste ****

CREATE TABLE REPOSITORY_BUSTE
(
	ID_MESSAGGIO VARCHAR2(255) NOT NULL,
	TIPO VARCHAR2(255) NOT NULL,
	MITTENTE VARCHAR2(255),
	IDPORTA_MITTENTE VARCHAR2(255),
	TIPO_MITTENTE VARCHAR2(255),
	IND_TELEMATICO_MITT VARCHAR2(255),
	DESTINATARIO VARCHAR2(255),
	IDPORTA_DESTINATARIO VARCHAR2(255),
	TIPO_DESTINATARIO VARCHAR2(255),
	IND_TELEMATICO_DEST VARCHAR2(255),
	VERSIONE_SERVIZIO VARCHAR2(255),
	SERVIZIO VARCHAR2(255),
	TIPO_SERVIZIO VARCHAR2(255),
	AZIONE VARCHAR2(255),
	PROFILO_DI_COLLABORAZIONE VARCHAR2(255),
	SERVIZIO_CORRELATO VARCHAR2(255),
	TIPO_SERVIZIO_CORRELATO VARCHAR2(255),
	COLLABORAZIONE VARCHAR2(255),
	SEQUENZA NUMBER,
	INOLTRO_SENZA_DUPLICATI NUMBER NOT NULL,
	CONFERMA_RICEZIONE NUMBER NOT NULL,
	ORA_REGISTRAZIONE TIMESTAMP,
	TIPO_ORA_REGISTRAZIONE VARCHAR2(255),
	RIFERIMENTO_MESSAGGIO VARCHAR2(255),
	SCADENZA_BUSTA TIMESTAMP NOT NULL,
	DUPLICATI NUMBER NOT NULL,
	-- Dati di integrazione
	LOCATION_PD VARCHAR2(255),
	SERVIZIO_APPLICATIVO VARCHAR2(255),
	MODULO_IN_ATTESA VARCHAR2(255),
	SCENARIO VARCHAR2(255),
	PROTOCOLLO VARCHAR2(255) NOT NULL,
	-- Booleani che indicano l'attuali modalita' di utilizzo del repository:
	--  HISTORY: Busta usata per funzionalita di confermaRicezione(OUTBOX)/FiltroDuplicati(INBOX)
	--  PROFILI: Busta usata per funzionalita di profili di collaborazione
	--  PDD:     Busta usata eventualmente da un PdD
	--  
	--  DEFAULT CONTROLLER: 3 interi con semantica booleana (1->true, 0->false)
	HISTORY NUMBER NOT NULL,
	PROFILO NUMBER NOT NULL,
	PDD NUMBER NOT NULL,
	REPOSITORY_ACCESS RAW(8) DEFAULT 'C101' NOT NULL,
	DATA_REGISTRAZIONE TIMESTAMP NOT NULL,
	-- fk/pk columns
	-- check constraints
	CONSTRAINT chk_REPOSITORY_BUSTE_1 CHECK (TIPO IN ('INBOX','OUTBOX')),
	-- fk/pk keys constraints
	CONSTRAINT pk_REPOSITORY_BUSTE PRIMARY KEY (ID_MESSAGGIO,TIPO)
);

-- index
CREATE INDEX REP_BUSTE_SEARCH ON REPOSITORY_BUSTE (SCADENZA_BUSTA,TIPO,HISTORY,PROFILO,PDD);
CREATE INDEX REP_BUSTE_SEARCH_RA ON REPOSITORY_BUSTE (SCADENZA_BUSTA,TIPO,REPOSITORY_ACCESS);
CREATE INDEX REP_BUSTE_SEARCH_TIPO ON REPOSITORY_BUSTE (TIPO,HISTORY,PROFILO,PDD);
CREATE INDEX REP_BUSTE_SEARCH_TIPO_RA ON REPOSITORY_BUSTE (TIPO,REPOSITORY_ACCESS);
CREATE INDEX REP_BUSTE_DATAREG ON REPOSITORY_BUSTE (DATA_REGISTRAZIONE,TIPO,HISTORY,PROFILO,PDD);
CREATE INDEX REP_BUSTE_DATAREG_RA ON REPOSITORY_BUSTE (DATA_REGISTRAZIONE,TIPO,REPOSITORY_ACCESS);

ALTER TABLE REPOSITORY_BUSTE MODIFY HISTORY DEFAULT 0;
ALTER TABLE REPOSITORY_BUSTE MODIFY PROFILO DEFAULT 0;
ALTER TABLE REPOSITORY_BUSTE MODIFY PDD DEFAULT 0;



CREATE SEQUENCE seq_LISTA_RISCONTRI MINVALUE 1 MAXVALUE 9223372036854775807 START WITH 1 INCREMENT BY 1 CACHE 2 CYCLE;

CREATE TABLE LISTA_RISCONTRI
(
	ID_MESSAGGIO VARCHAR2(255) NOT NULL,
	TIPO VARCHAR2(255) NOT NULL,
	ID_RISCONTRO VARCHAR2(255),
	RICEVUTA CLOB,
	ORA_REGISTRAZIONE TIMESTAMP,
	TIPO_ORA_REGISTRAZIONE VARCHAR2(255),
	DATA_REGISTRAZIONE TIMESTAMP NOT NULL,
	-- fk/pk columns
	id NUMBER NOT NULL,
	-- check constraints
	CONSTRAINT chk_LISTA_RISCONTRI_1 CHECK (TIPO IN ('INBOX','OUTBOX')),
	-- fk/pk keys constraints
	CONSTRAINT fk_LISTA_RISCONTRI_1 FOREIGN KEY (ID_MESSAGGIO,TIPO) REFERENCES REPOSITORY_BUSTE(ID_MESSAGGIO,TIPO) ON DELETE CASCADE,
	CONSTRAINT pk_LISTA_RISCONTRI PRIMARY KEY (id)
);

-- index
CREATE INDEX LISTA_RISC_ID ON LISTA_RISCONTRI (ID_MESSAGGIO,TIPO);
CREATE TRIGGER trg_LISTA_RISCONTRI
BEFORE
insert on LISTA_RISCONTRI
for each row
begin
   IF (:new.id IS NULL) THEN
      SELECT seq_LISTA_RISCONTRI.nextval INTO :new.id
                FROM DUAL;
   END IF;
end;
/



CREATE SEQUENCE seq_LISTA_TRASMISSIONI MINVALUE 1 MAXVALUE 9223372036854775807 START WITH 1 INCREMENT BY 1 CACHE 2 CYCLE;

CREATE TABLE LISTA_TRASMISSIONI
(
	ID_MESSAGGIO VARCHAR2(255) NOT NULL,
	TIPO VARCHAR2(255) NOT NULL,
	ORIGINE VARCHAR2(255),
	TIPO_ORIGINE VARCHAR2(255),
	DESTINAZIONE VARCHAR2(255),
	TIPO_DESTINAZIONE VARCHAR2(255),
	ORA_REGISTRAZIONE TIMESTAMP,
	TIPO_ORA_REGISTRAZIONE VARCHAR2(255),
	DATA_REGISTRAZIONE TIMESTAMP NOT NULL,
	-- fk/pk columns
	id NUMBER NOT NULL,
	-- check constraints
	CONSTRAINT chk_LISTA_TRASMISSIONI_1 CHECK (TIPO IN ('INBOX','OUTBOX')),
	-- fk/pk keys constraints
	CONSTRAINT fk_LISTA_TRASMISSIONI_1 FOREIGN KEY (ID_MESSAGGIO,TIPO) REFERENCES REPOSITORY_BUSTE(ID_MESSAGGIO,TIPO) ON DELETE CASCADE,
	CONSTRAINT pk_LISTA_TRASMISSIONI PRIMARY KEY (id)
);

-- index
CREATE INDEX LISTA_TRASM_ID ON LISTA_TRASMISSIONI (ID_MESSAGGIO,TIPO);
CREATE TRIGGER trg_LISTA_TRASMISSIONI
BEFORE
insert on LISTA_TRASMISSIONI
for each row
begin
   IF (:new.id IS NULL) THEN
      SELECT seq_LISTA_TRASMISSIONI.nextval INTO :new.id
                FROM DUAL;
   END IF;
end;
/



CREATE SEQUENCE seq_LISTA_ECCEZIONI MINVALUE 1 MAXVALUE 9223372036854775807 START WITH 1 INCREMENT BY 1 CACHE 2 CYCLE;

CREATE TABLE LISTA_ECCEZIONI
(
	ID_MESSAGGIO VARCHAR2(255) NOT NULL,
	TIPO VARCHAR2(255) NOT NULL,
	VALIDAZIONE NUMBER,
	CONTESTO VARCHAR2(255),
	CODICE VARCHAR2(255),
	RILEVANZA VARCHAR2(255),
	POSIZIONE CLOB,
	DATA_REGISTRAZIONE TIMESTAMP NOT NULL,
	-- fk/pk columns
	id NUMBER NOT NULL,
	-- check constraints
	CONSTRAINT chk_LISTA_ECCEZIONI_1 CHECK (TIPO IN ('INBOX','OUTBOX')),
	-- fk/pk keys constraints
	CONSTRAINT fk_LISTA_ECCEZIONI_1 FOREIGN KEY (ID_MESSAGGIO,TIPO) REFERENCES REPOSITORY_BUSTE(ID_MESSAGGIO,TIPO) ON DELETE CASCADE,
	CONSTRAINT pk_LISTA_ECCEZIONI PRIMARY KEY (id)
);

-- index
CREATE INDEX LISTA_ECC_ID ON LISTA_ECCEZIONI (ID_MESSAGGIO,TIPO);
CREATE INDEX LISTA_ECC_VALIDAZIONE ON LISTA_ECCEZIONI (ID_MESSAGGIO,TIPO,VALIDAZIONE);
CREATE TRIGGER trg_LISTA_ECCEZIONI
BEFORE
insert on LISTA_ECCEZIONI
for each row
begin
   IF (:new.id IS NULL) THEN
      SELECT seq_LISTA_ECCEZIONI.nextval INTO :new.id
                FROM DUAL;
   END IF;
end;
/



CREATE SEQUENCE seq_LISTA_EXT_PROTOCOL_INFO MINVALUE 1 MAXVALUE 9223372036854775807 START WITH 1 INCREMENT BY 1 CACHE 2 CYCLE;

CREATE TABLE LISTA_EXT_PROTOCOL_INFO
(
	ID_MESSAGGIO VARCHAR2(255) NOT NULL,
	TIPO VARCHAR2(255) NOT NULL,
	NOME VARCHAR2(255) NOT NULL,
	VALORE CLOB NOT NULL,
	DATA_REGISTRAZIONE TIMESTAMP NOT NULL,
	-- fk/pk columns
	id NUMBER NOT NULL,
	-- check constraints
	CONSTRAINT chk_LISTA_EXT_PROTOCOL_INFO_1 CHECK (TIPO IN ('INBOX','OUTBOX')),
	-- fk/pk keys constraints
	CONSTRAINT fk_LISTA_EXT_PROTOCOL_INFO_1 FOREIGN KEY (ID_MESSAGGIO,TIPO) REFERENCES REPOSITORY_BUSTE(ID_MESSAGGIO,TIPO) ON DELETE CASCADE,
	CONSTRAINT pk_LISTA_EXT_PROTOCOL_INFO PRIMARY KEY (id)
);

-- index
CREATE INDEX LISTA_EXT_ID ON LISTA_EXT_PROTOCOL_INFO (ID_MESSAGGIO,TIPO);
CREATE TRIGGER trg_LISTA_EXT_PROTOCOL_INFO
BEFORE
insert on LISTA_EXT_PROTOCOL_INFO
for each row
begin
   IF (:new.id IS NULL) THEN
      SELECT seq_LISTA_EXT_PROTOCOL_INFO.nextval INTO :new.id
                FROM DUAL;
   END IF;
end;
/



-- **** Riscontri ****

CREATE TABLE RISCONTRI_DA_RICEVERE
(
	ID_MESSAGGIO VARCHAR2(255) NOT NULL,
	DATA_INVIO TIMESTAMP NOT NULL,
	-- fk/pk columns
	-- fk/pk keys constraints
	CONSTRAINT pk_RISCONTRI_DA_RICEVERE PRIMARY KEY (ID_MESSAGGIO)
);

-- index
CREATE INDEX RISCONTRI_NON_RICEVUTI ON RISCONTRI_DA_RICEVERE (DATA_INVIO);

-- **** Sequenze ****

CREATE TABLE SEQUENZA_DA_INVIARE
(
	MITTENTE VARCHAR2(255) NOT NULL,
	TIPO_MITTENTE VARCHAR2(255) NOT NULL,
	DESTINATARIO VARCHAR2(255) NOT NULL,
	TIPO_DESTINATARIO VARCHAR2(255) NOT NULL,
	SERVIZIO VARCHAR2(255) NOT NULL,
	TIPO_SERVIZIO VARCHAR2(255) NOT NULL,
	AZIONE VARCHAR2(255) NOT NULL,
	PROSSIMA_SEQUENZA NUMBER NOT NULL,
	ID_COLLABORAZIONE VARCHAR2(255) NOT NULL,
	DATA_REGISTRAZIONE TIMESTAMP NOT NULL,
	-- fk/pk columns
	-- fk/pk keys constraints
	CONSTRAINT pk_SEQUENZA_DA_INVIARE PRIMARY KEY (MITTENTE,TIPO_MITTENTE,DESTINATARIO,TIPO_DESTINATARIO,SERVIZIO,TIPO_SERVIZIO,AZIONE)
);


ALTER TABLE SEQUENZA_DA_INVIARE MODIFY AZIONE DEFAULT '';


CREATE TABLE SEQUENZA_DA_RICEVERE
(
	ID_COLLABORAZIONE VARCHAR2(255) NOT NULL,
	SEQUENZA_ATTESA NUMBER NOT NULL,
	-- le informazioni su mitt/dest/servizio/azione servono per un controllo di validazione sulla collaborazione
	MITTENTE VARCHAR2(255) NOT NULL,
	TIPO_MITTENTE VARCHAR2(255) NOT NULL,
	DESTINATARIO VARCHAR2(255) NOT NULL,
	TIPO_DESTINATARIO VARCHAR2(255) NOT NULL,
	SERVIZIO VARCHAR2(255) NOT NULL,
	TIPO_SERVIZIO VARCHAR2(255) NOT NULL,
	AZIONE VARCHAR2(255),
	DATA_REGISTRAZIONE TIMESTAMP NOT NULL,
	-- fk/pk columns
	-- fk/pk keys constraints
	CONSTRAINT pk_SEQUENZA_DA_RICEVERE PRIMARY KEY (ID_COLLABORAZIONE)
);


-- **** Asincroni ****

CREATE TABLE ASINCRONO
(
	ID_MESSAGGIO VARCHAR2(255) NOT NULL,
	TIPO VARCHAR2(255) NOT NULL,
	ORA_REGISTRAZIONE TIMESTAMP NOT NULL,
	RICEVUTA_ASINCRONA NUMBER NOT NULL,
	TIPO_SERVIZIO_CORRELATO VARCHAR2(255),
	SERVIZIO_CORRELATO VARCHAR2(255),
	VERSIONE_SERVIZIO_CORRELATO NUMBER,
	-- per diversificare il flusso di richiesta/ricevuta da risposta(richiestaStato)/ricevuta(Risposta)
	IS_RICHIESTA NUMBER NOT NULL,
	ID_ASINCRONO VARCHAR2(255) NOT NULL,
	ID_COLLABORAZIONE VARCHAR2(255),
	-- 1 se la ricevuta applicativa e' abilitata, 0 se non lo e'
	RICEVUTA_APPLICATIVA NUMBER NOT NULL,
	-- serve per la re-spedizione di una risposta asincrona
	BACKUP_ID_RICHIESTA VARCHAR2(255),
	-- fk/pk columns
	-- check constraints
	CONSTRAINT chk_ASINCRONO_1 CHECK (TIPO IN ('INBOX','OUTBOX')),
	-- fk/pk keys constraints
	CONSTRAINT pk_ASINCRONO PRIMARY KEY (ID_MESSAGGIO,TIPO)
);

-- index
CREATE INDEX ASINCRONO_BACKUP_ID ON ASINCRONO (BACKUP_ID_RICHIESTA);
CREATE INDEX ASINCRONO_IS_RICEVUTA ON ASINCRONO (ID_MESSAGGIO,TIPO,RICEVUTA_ASINCRONA);
CREATE INDEX ASINCRONO_NON_RICEVUTE ON ASINCRONO (ORA_REGISTRAZIONE,TIPO,RICEVUTA_ASINCRONA,RICEVUTA_APPLICATIVA);


-- govway
		  		
-- **** Serial for ID ****

CREATE TABLE ID_MESSAGGIO
(
	COUNTER NUMBER NOT NULL,
	PROTOCOLLO VARCHAR2(255) NOT NULL,
	ora_registrazione TIMESTAMP,
	-- fk/pk columns
	-- fk/pk keys constraints
	CONSTRAINT pk_ID_MESSAGGIO PRIMARY KEY (PROTOCOLLO)
);


ALTER TABLE ID_MESSAGGIO MODIFY ora_registrazione DEFAULT CURRENT_TIMESTAMP;


CREATE TABLE ID_MESSAGGIO_RELATIVO
(
	COUNTER NUMBER NOT NULL,
	PROTOCOLLO VARCHAR2(255) NOT NULL,
	INFO_ASSOCIATA VARCHAR2(255) NOT NULL,
	ora_registrazione TIMESTAMP,
	-- fk/pk columns
	-- fk/pk keys constraints
	CONSTRAINT pk_ID_MESSAGGIO_RELATIVO PRIMARY KEY (PROTOCOLLO,INFO_ASSOCIATA)
);


ALTER TABLE ID_MESSAGGIO_RELATIVO MODIFY ora_registrazione DEFAULT CURRENT_TIMESTAMP;


CREATE TABLE ID_MESSAGGIO_PRG
(
	PROGRESSIVO VARCHAR2(255) NOT NULL,
	PROTOCOLLO VARCHAR2(255) NOT NULL,
	ora_registrazione TIMESTAMP,
	-- fk/pk columns
	-- fk/pk keys constraints
	CONSTRAINT pk_ID_MESSAGGIO_PRG PRIMARY KEY (PROTOCOLLO)
);


ALTER TABLE ID_MESSAGGIO_PRG MODIFY ora_registrazione DEFAULT CURRENT_TIMESTAMP;


CREATE TABLE ID_MESSAGGIO_RELATIVO_PRG
(
	PROGRESSIVO VARCHAR2(255) NOT NULL,
	PROTOCOLLO VARCHAR2(255) NOT NULL,
	INFO_ASSOCIATA VARCHAR2(255) NOT NULL,
	ora_registrazione TIMESTAMP,
	-- fk/pk columns
	-- fk/pk keys constraints
	CONSTRAINT pk_ID_MESSAGGIO_RELATIVO_PRG PRIMARY KEY (PROTOCOLLO,INFO_ASSOCIATA)
);


ALTER TABLE ID_MESSAGGIO_RELATIVO_PRG MODIFY ora_registrazione DEFAULT CURRENT_TIMESTAMP;



-- govway
		  		
-- **** Messaggi ****

CREATE TABLE MESSAGGI
(
	ID_MESSAGGIO VARCHAR2(255) NOT NULL,
	TIPO VARCHAR2(255) NOT NULL,
	RIFERIMENTO_MSG VARCHAR2(255),
	ERRORE_PROCESSAMENTO CLOB,
	-- data dalla quale il msg puo' essere rispedito in caso di errori
	RISPEDIZIONE TIMESTAMP NOT NULL,
	ORA_REGISTRAZIONE TIMESTAMP NOT NULL,
	PROPRIETARIO VARCHAR2(255),
	-- le colonne seguenti servono per il servizio di TransactionManager
	MOD_RICEZ_CONT_APPLICATIVI VARCHAR2(255),
	MOD_RICEZ_BUSTE VARCHAR2(255),
	MOD_INOLTRO_BUSTE VARCHAR2(255),
	MOD_INOLTRO_RISPOSTE VARCHAR2(255),
	MOD_IMBUSTAMENTO VARCHAR2(255),
	MOD_IMBUSTAMENTO_RISPOSTE VARCHAR2(255),
	MOD_SBUSTAMENTO VARCHAR2(255),
	MOD_SBUSTAMENTO_RISPOSTE VARCHAR2(255),
	-- Thread Pool:impedisce la gestione di messaggi gia schedulati
	SCHEDULING NUMBER,
	-- permette la riconsegna del messaggio dopo tot tempo
	REDELIVERY_DELAY TIMESTAMP NOT NULL,
	-- numero di riconsegne effettuate
	REDELIVERY_COUNT NUMBER,
	-- id del nodo del cluster che deve gestire questo messaggio.
	CLUSTER_ID VARCHAR2(255),
	-- memorizza l'ora in cui il messaggio e stato schedulato la prima volta
	SCHEDULING_TIME TIMESTAMP,
	-- contiene un messaggio serializzato
	MSG_BYTES BLOB,
	CORRELAZIONE_APPLICATIVA VARCHAR2(255),
	CORRELAZIONE_RISPOSTA VARCHAR2(255),
	PROTOCOLLO VARCHAR2(255) NOT NULL,
	id_transazione VARCHAR2(255) NOT NULL,
	-- fk/pk columns
	-- check constraints
	CONSTRAINT chk_MESSAGGI_1 CHECK (TIPO IN ('INBOX','OUTBOX')),
	-- fk/pk keys constraints
	CONSTRAINT pk_MESSAGGI PRIMARY KEY (ID_MESSAGGIO,TIPO)
);

-- index
CREATE INDEX MESSAGGI_TRANS ON MESSAGGI (id_transazione,TIPO);
CREATE INDEX MESSAGGI_SEARCH ON MESSAGGI (ORA_REGISTRAZIONE,RIFERIMENTO_MSG,TIPO,PROPRIETARIO);
CREATE INDEX MESSAGGI_ACQUIRE_SEND ON MESSAGGI (ORA_REGISTRAZIONE,PROPRIETARIO,TIPO,ID_MESSAGGIO);
CREATE INDEX MESSAGGI_RIFMSG ON MESSAGGI (RIFERIMENTO_MSG);
CREATE INDEX MESSAGGI_TESTSUITE ON MESSAGGI (PROPRIETARIO,ID_MESSAGGIO,RIFERIMENTO_MSG);

ALTER TABLE MESSAGGI MODIFY SCHEDULING DEFAULT 0;
ALTER TABLE MESSAGGI MODIFY REDELIVERY_COUNT DEFAULT 0;


CREATE TABLE MSG_SERVIZI_APPLICATIVI
(
	ID_MESSAGGIO VARCHAR2(255) NOT NULL,
	TIPO VARCHAR2(255) NOT NULL,
	SERVIZIO_APPLICATIVO VARCHAR2(2000) NOT NULL,
	SBUSTAMENTO_SOAP NUMBER NOT NULL,
	SBUSTAMENTO_INFO_PROTOCOL NUMBER NOT NULL,
	INTEGRATION_MANAGER NUMBER NOT NULL,
	MOD_CONSEGNA_CONT_APPLICATIVI VARCHAR2(255),
	-- Assume il valore 'Connettore' se la consegna avviente tramite un connettore,
	-- 'ConnectionReply' se viene ritornato tramite connectionReply,
	-- 'IntegrationManager' se e' solo ottenibile tramite IntegrationManager
	TIPO_CONSEGNA VARCHAR2(40) NOT NULL,
	ERRORE_PROCESSAMENTO_COMPACT VARCHAR2(255),
	ERRORE_PROCESSAMENTO CLOB,
	-- data dalla quale il msg puo' essere rispedito in caso di errori
	RISPEDIZIONE TIMESTAMP NOT NULL,
	-- Informazioni relative alla consegna con threads
	NOME_PORTA VARCHAR2(255),
	LOCK_CONSEGNA TIMESTAMP,
	CLUSTER_ID VARCHAR2(255),
	ATTESA_ESITO NUMBER NOT NULL,
	ORA_REGISTRAZIONE TIMESTAMP NOT NULL,
	CODA VARCHAR2(10),
	PRIORITA VARCHAR2(10),
	-- fk/pk columns
	-- check constraints
	CONSTRAINT chk_MSG_SERVIZI_APPLICATIVI_1 CHECK (TIPO IN ('INBOX','OUTBOX')),
	CONSTRAINT chk_MSG_SERVIZI_APPLICATIVI_2 CHECK (TIPO_CONSEGNA IN ('Connettore','ConnectionReply','IntegrationManager')),
	-- fk/pk keys constraints
	CONSTRAINT fk_MSG_SERVIZI_APPLICATIVI_1 FOREIGN KEY (ID_MESSAGGIO,TIPO) REFERENCES MESSAGGI(ID_MESSAGGIO,TIPO) ON DELETE CASCADE,
	CONSTRAINT pk_MSG_SERVIZI_APPLICATIVI PRIMARY KEY (ID_MESSAGGIO,SERVIZIO_APPLICATIVO)
);

-- index
CREATE INDEX MSG_SERV_APPL_LIST ON MSG_SERVIZI_APPLICATIVI (SERVIZIO_APPLICATIVO,INTEGRATION_MANAGER);
CREATE INDEX MSG_SERV_APPL_GET_IM_MSG_ID ON MSG_SERVIZI_APPLICATIVI (ID_MESSAGGIO,SERVIZIO_APPLICATIVO,INTEGRATION_MANAGER);
CREATE INDEX MSG_SERV_APPL_TIMEOUT ON MSG_SERVIZI_APPLICATIVI (ID_MESSAGGIO,TIPO_CONSEGNA,INTEGRATION_MANAGER);
CREATE INDEX MSG_SERV_APPL_ACQUIRE_SEND ON MSG_SERVIZI_APPLICATIVI (ID_MESSAGGIO,TIPO_CONSEGNA,ATTESA_ESITO,CODA,PRIORITA,SERVIZIO_APPLICATIVO,ERRORE_PROCESSAMENTO_COMPACT,RISPEDIZIONE,LOCK_CONSEGNA);
CREATE INDEX MSG_SERV_APPL_RELEASE_SEND ON MSG_SERVIZI_APPLICATIVI (CLUSTER_ID,CODA,LOCK_CONSEGNA);

ALTER TABLE MSG_SERVIZI_APPLICATIVI MODIFY TIPO DEFAULT 'INBOX';
ALTER TABLE MSG_SERVIZI_APPLICATIVI MODIFY ATTESA_ESITO DEFAULT 0;
ALTER TABLE MSG_SERVIZI_APPLICATIVI MODIFY CODA DEFAULT 'UNSET';
ALTER TABLE MSG_SERVIZI_APPLICATIVI MODIFY PRIORITA DEFAULT 'UNSET';


CREATE TABLE DEFINIZIONE_MESSAGGI
(
	ID_MESSAGGIO VARCHAR2(255) NOT NULL,
	TIPO VARCHAR2(255) NOT NULL,
	CONTENT_TYPE VARCHAR2(255) NOT NULL,
	MSG_BYTES BLOB,
	MSG_CONTEXT BLOB,
	RESPONSE_CONTENT_TYPE VARCHAR2(255),
	RESPONSE_MSG_BYTES BLOB,
	RESPONSE_MSG_CONTEXT BLOB,
	TRANSACTION_CONTEXT BLOB,
	ORA_REGISTRAZIONE TIMESTAMP NOT NULL,
	-- fk/pk columns
	-- check constraints
	CONSTRAINT chk_DEFINIZIONE_MESSAGGI_1 CHECK (TIPO IN ('INBOX','OUTBOX')),
	-- fk/pk keys constraints
	CONSTRAINT fk_DEFINIZIONE_MESSAGGI_1 FOREIGN KEY (ID_MESSAGGIO,TIPO) REFERENCES MESSAGGI(ID_MESSAGGIO,TIPO) ON DELETE CASCADE,
	CONSTRAINT pk_DEFINIZIONE_MESSAGGI PRIMARY KEY (ID_MESSAGGIO,TIPO)
);


-- **** Correlazione Applicativa ****

CREATE SEQUENCE seq_CORRELAZIONE_APPLICATIVA MINVALUE 1 MAXVALUE 9223372036854775807 START WITH 1 INCREMENT BY 1 CACHE 2 CYCLE;

CREATE TABLE CORRELAZIONE_APPLICATIVA
(
	ID_MESSAGGIO VARCHAR2(255) NOT NULL,
	ID_APPLICATIVO VARCHAR2(255) NOT NULL,
	SERVIZIO_APPLICATIVO VARCHAR2(255) NOT NULL,
	TIPO_MITTENTE VARCHAR2(255) NOT NULL,
	MITTENTE VARCHAR2(255) NOT NULL,
	TIPO_DESTINATARIO VARCHAR2(255) NOT NULL,
	DESTINATARIO VARCHAR2(255) NOT NULL,
	TIPO_SERVIZIO VARCHAR2(255),
	SERVIZIO VARCHAR2(255),
	VERSIONE_SERVIZIO NUMBER NOT NULL,
	AZIONE VARCHAR2(255),
	SCADENZA TIMESTAMP,
	ORA_REGISTRAZIONE TIMESTAMP NOT NULL,
	-- fk/pk columns
	id NUMBER NOT NULL,
	-- fk/pk keys constraints
	CONSTRAINT pk_CORRELAZIONE_APPLICATIVA PRIMARY KEY (id)
);

-- index
CREATE INDEX CORR_APPL_SCADUTE ON CORRELAZIONE_APPLICATIVA (SCADENZA);
CREATE INDEX CORR_APPL_OLD ON CORRELAZIONE_APPLICATIVA (ORA_REGISTRAZIONE);

ALTER TABLE CORRELAZIONE_APPLICATIVA MODIFY ORA_REGISTRAZIONE DEFAULT CURRENT_TIMESTAMP;

CREATE TRIGGER trg_CORRELAZIONE_APPLICATIVA
BEFORE
insert on CORRELAZIONE_APPLICATIVA
for each row
begin
   IF (:new.id IS NULL) THEN
      SELECT seq_CORRELAZIONE_APPLICATIVA.nextval INTO :new.id
                FROM DUAL;
   END IF;
end;
/



-- **** Controllo Traffico ****

CREATE SEQUENCE seq_ct_map MINVALUE 1 MAXVALUE 9223372036854775807 START WITH 1 INCREMENT BY 1 CACHE 2 CYCLE;

CREATE TABLE ct_map
(
	map_key VARCHAR2(300) NOT NULL,
	map_update_time TIMESTAMP NOT NULL,
	map_value BLOB NOT NULL,
	-- fk/pk columns
	id NUMBER NOT NULL,
	-- unique constraints
	CONSTRAINT unique_ct_map_1 UNIQUE (map_key),
	-- fk/pk keys constraints
	CONSTRAINT pk_ct_map PRIMARY KEY (id)
);

CREATE TRIGGER trg_ct_map
BEFORE
insert on ct_map
for each row
begin
   IF (:new.id IS NULL) THEN
      SELECT seq_ct_map.nextval INTO :new.id
                FROM DUAL;
   END IF;
end;
/




-- govway
		  		
-- **** Semaphore ****

CREATE SEQUENCE seq_OP2_SEMAPHORE MINVALUE 1 MAXVALUE 9223372036854775807 START WITH 1 INCREMENT BY 1 CACHE 2 CYCLE;

CREATE TABLE OP2_SEMAPHORE
(
	node_id VARCHAR2(255),
	creation_time TIMESTAMP,
	update_time TIMESTAMP,
	details CLOB,
	applicative_id VARCHAR2(255) NOT NULL,
	-- fk/pk columns
	id NUMBER NOT NULL,
	-- unique constraints
	CONSTRAINT uniq_semaphore_1 UNIQUE (applicative_id),
	-- fk/pk keys constraints
	CONSTRAINT pk_OP2_SEMAPHORE PRIMARY KEY (id)
);

CREATE TRIGGER trg_OP2_SEMAPHORE
BEFORE
insert on OP2_SEMAPHORE
for each row
begin
   IF (:new.id IS NULL) THEN
      SELECT seq_OP2_SEMAPHORE.nextval INTO :new.id
                FROM DUAL;
   END IF;
end;
/




-- govway
		  		
CREATE SEQUENCE seq_db_info MINVALUE 1 MAXVALUE 9223372036854775807 START WITH 1 INCREMENT BY 1 CACHE 2 NOCYCLE;

CREATE TABLE db_info
(
	major_version NUMBER NOT NULL,
	minor_version NUMBER NOT NULL,
	notes VARCHAR2(255) NOT NULL,
	-- fk/pk columns
	id NUMBER NOT NULL,
	-- fk/pk keys constraints
	CONSTRAINT pk_db_info PRIMARY KEY (id)
);

CREATE TRIGGER trg_db_info
BEFORE
insert on db_info
for each row
begin
   IF (:new.id IS NULL) THEN
      SELECT seq_db_info.nextval INTO :new.id
                FROM DUAL;
   END IF;
end;
/




-- govway
		  		
INSERT INTO OP2_SEMAPHORE (applicative_id) VALUES ('RepositoryMessaggi');
INSERT INTO OP2_SEMAPHORE (applicative_id) VALUES ('PuliziaRepositoryMessaggi');
INSERT INTO OP2_SEMAPHORE (applicative_id) VALUES ('PuliziaRepositoryBuste');
INSERT INTO OP2_SEMAPHORE (applicative_id) VALUES ('CorrelazioneApplicativa');
INSERT INTO OP2_SEMAPHORE (applicative_id) VALUES ('BusteNonRiscontrate');
INSERT INTO OP2_SEMAPHORE (applicative_id) VALUES ('PuliziaMessaggiAnomali');
INSERT INTO OP2_SEMAPHORE (applicative_id) VALUES ('StartupGateway');


-- govway
			  		


INSERT INTO db_info (major_version,minor_version,notes) VALUES (3,3,'[3.3.18] Database di GovWay');

