/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.lib.queue.config;

import java.io.InputStream;
import java.util.Properties;
import org.openspcoop2.pdd.config.OpenSPCoop2ConfigurationException;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.web.lib.queue.config.QueueInstanceProperties;
import org.slf4j.Logger;

public class QueueProperties {
    private Logger log = null;
    private QueueInstanceProperties reader;
    private static QueueProperties queueProperties = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QueueProperties(String confDir, Logger log) throws UtilsException {
        this.log = log != null ? log : LoggerWrapperFactory.getLogger(QueueProperties.class);
        Properties propertiesReader = new Properties();
        InputStream properties = null;
        try {
            properties = QueueProperties.class.getResourceAsStream("/queue.properties");
            if (properties == null) {
                throw new UtilsException("File '/queue.properties' not found");
            }
            propertiesReader.load(properties);
        }
        catch (Exception e) {
            this.doError(e);
        }
        finally {
            try {
                if (properties != null) {
                    properties.close();
                }
            }
            catch (Exception exception) {}
        }
        this.reader = new QueueInstanceProperties(propertiesReader, this.log, confDir);
    }

    private void doError(Exception e) throws UtilsException {
        String msg = "Riscontrato errore durante la lettura del file 'queue.properties': " + e.getMessage();
        this.log.error(msg, (Throwable)e);
        throw new UtilsException("ConsoleProperties initialize error: " + e.getMessage());
    }

    public static boolean initialize(String confDir, Logger log) {
        try {
            queueProperties = new QueueProperties(confDir, log);
            return true;
        }
        catch (Exception e) {
            log.error("Inizializzazione fallita: " + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public static QueueProperties getInstance() throws OpenSPCoop2ConfigurationException {
        if (queueProperties == null) {
            Class<QueueProperties> clazz = QueueProperties.class;
            synchronized (QueueProperties.class) {
                throw new OpenSPCoop2ConfigurationException("QueueProperties non inizializzato");
            }
        }
        return queueProperties;
    }

    public static void updateLocalImplementation(Properties prop) {
        QueueProperties.queueProperties.reader.setLocalObjectImplementation(prop);
    }

    private String readProperty(boolean required, String property) throws UtilsException {
        String tmp = this.reader.getValueConvertEnvProperties(property);
        if (tmp == null) {
            if (required) {
                throw new UtilsException("Property [" + property + "] not found");
            }
            return null;
        }
        return tmp.trim();
    }

    private Integer readIntegerProperty(boolean required, String property) throws UtilsException {
        String tmp = this.readProperty(required, property);
        try {
            return Integer.parseInt(tmp);
        }
        catch (Exception e) {
            throw new UtilsException("Property [" + property + "] with uncorrect value [" + tmp + "] (int value expected)");
        }
    }

    public String getConnectionFactory() throws UtilsException {
        return this.readProperty(true, "ConnectionFactory");
    }

    public Properties getConnectionFactoryContext() throws UtilsException {
        return this.reader.readPropertiesConvertEnvProperties("ConnectionFactory.property.");
    }

    public Integer getWaitTime() throws UtilsException {
        return this.readIntegerProperty(true, "WAIT_TIME");
    }
}

