/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.lib.queue.dao;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openspcoop2.web.lib.queue.costanti.OperationStatus;
import org.openspcoop2.web.lib.queue.dao.Parameter;

public class Operation {
    private Long id;
    private String operation;
    private String tipo;
    private String details;
    private String superUser;
    private String hostname;
    private OperationStatus status;
    private int waitTime;
    private Date timeReq;
    private Date timeExecute;
    private boolean deleted;
    private List<Operation> operazioniPrecedentiAncoraDaGestire = new ArrayList<Operation>();
    private List<Parameter> parameters = new ArrayList<Parameter>();
    private Map<String, String> parametersHash = new HashMap<String, String>();

    public void addOperazionePrecedenteAncoraDaGestire(Operation operation) {
        this.operazioniPrecedentiAncoraDaGestire.add(operation);
    }

    public int sizeOperazioniPrecedentiAncoraDaGestireList() {
        return this.operazioniPrecedentiAncoraDaGestire.size();
    }

    public Operation getOperazionePrecedenteAncoraDaGestire(int index) {
        return this.operazioniPrecedentiAncoraDaGestire.get(index);
    }

    public void addParameter(Parameter p) {
        this.parameters.add(p);
        if (p.getValue() != null) {
            if (this.parametersHash.containsKey(p.getName())) {
                String oldValue = this.parametersHash.get(p.getName());
                this.parametersHash.put(p.getName(), oldValue + " " + p.getValue());
            } else {
                this.parametersHash.put(p.getName(), p.getValue());
            }
        }
    }

    public Parameter getParameter(int index) {
        return this.parameters.get(index);
    }

    public Parameter removeParameter(int index) {
        return this.parameters.remove(index);
    }

    public Parameter[] getParameters() {
        return this.parameters.toArray(new Parameter[0]);
    }

    public String getParameterValue(String name) {
        return this.parametersHash.get(name);
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public String getTipo() {
        return this.tipo;
    }

    public void setTipo(String tipo) {
        this.tipo = tipo;
    }

    public String getSuperUser() {
        return this.superUser;
    }

    public void setSuperUser(String superUser) {
        this.superUser = superUser;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public OperationStatus getStatus() {
        return this.status;
    }

    public void setStatus(OperationStatus status) {
        this.status = status;
    }

    public int getWaitTime() {
        return this.waitTime;
    }

    public void setWaitTime(int waitTime) {
        this.waitTime = waitTime;
    }

    public Date getTimeReq() {
        return this.timeReq;
    }

    public void setTimeReq(Date timeReq) {
        this.timeReq = timeReq;
    }

    public Date getTimeExecute() {
        return this.timeExecute;
    }

    public void setTimeExecute(Date timeExecute) {
        this.timeExecute = timeExecute;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public String getDetails() {
        return this.details;
    }

    public void setDetails(String details) {
        this.details = details;
    }

    public String toString() {
        String pattern = "id [{0,number,#}] operation [{1}] tipo [{2}] superUser [{3}] hostname [{4}] status [{5}] timeReq [{6}] timeExecute [{7}] deleted [{8}] details [{9}]";
        return MessageFormat.format(pattern, this.id, this.operation, this.tipo, this.superUser, this.hostname, this.status.toString(), this.timeReq.toString(), this.timeExecute.toString(), "" + this.deleted, this.details);
    }
}

