/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class UtilsMultiException
extends Exception {
    private final List<Throwable> exceptions = new ArrayList<Throwable>();
    private static final long serialVersionUID = 1L;

    public List<Throwable> getExceptions() {
        return this.exceptions;
    }

    public UtilsMultiException(String message, Throwable cause) {
        super(message, cause);
        this.exceptions.add(cause);
    }

    public UtilsMultiException(Throwable cause) {
        super(cause);
        this.exceptions.add(cause);
    }

    public UtilsMultiException(String message, Throwable ... cause) {
        super(message, cause != null && cause.length > 0 ? cause[0] : null);
        if (cause != null && cause.length > 0) {
            for (int i = 0; i < cause.length; ++i) {
                this.exceptions.add(cause[i]);
            }
        }
    }

    public UtilsMultiException(Throwable ... cause) {
        super(cause != null && cause.length > 0 ? cause[0] : null);
        if (cause != null && cause.length > 0) {
            for (int i = 0; i < cause.length; ++i) {
                this.exceptions.add(cause[i]);
            }
        }
    }

    public String getMultiMessage() {
        StringBuilder sb = new StringBuilder();
        if (!this.exceptions.isEmpty()) {
            for (int i = this.exceptions.size() - 1; i >= 0; --i) {
                if (sb.length() > 0) {
                    sb.append("\n");
                }
                sb.append("- error " + (i + 1) + ": ");
                sb.append(this.exceptions.get(i).getMessage());
            }
        }
        return sb.toString();
    }

    @Override
    public void printStackTrace(PrintStream s) {
        if (!this.exceptions.isEmpty()) {
            for (int i = this.exceptions.size() - 1; i >= 0; --i) {
                if (i > 0) {
                    s.print("\n");
                }
                s.print("MultiException at position " + (i + 1) + ": \n");
                this.exceptions.get(i).printStackTrace(s);
            }
        } else {
            super.printStackTrace(s);
        }
    }

    @Override
    public void printStackTrace(PrintWriter s) {
        if (!this.exceptions.isEmpty()) {
            for (int i = this.exceptions.size() - 1; i >= 0; --i) {
                if (i > 0) {
                    s.print("\n");
                }
                s.print("MultiException at position " + (i + 1) + ": \n");
                this.exceptions.get(i).printStackTrace(s);
            }
        } else {
            super.printStackTrace(s);
        }
    }

    @Override
    public StackTraceElement[] getStackTrace() {
        if (!this.exceptions.isEmpty()) {
            ArrayList<StackTraceElement> listStackTraceElement = new ArrayList<StackTraceElement>();
            for (int i = this.exceptions.size() - 1; i >= 0; --i) {
                StackTraceElement sElement = new StackTraceElement(UtilsMultiException.class.getName(), "Position_" + (i + 1), "MultiException_" + (i + 1), i + 1);
                listStackTraceElement.add(sElement);
                StackTraceElement[] tmp = this.exceptions.get(i).getStackTrace();
                if (tmp == null || tmp.length <= 0) continue;
                listStackTraceElement.addAll(Arrays.asList(tmp));
            }
            return listStackTraceElement.toArray(new StackTraceElement[1]);
        }
        return super.getStackTrace();
    }

    public UtilsMultiException() {
    }

    public UtilsMultiException(String msg) {
        super(msg);
    }
}

