/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils;

import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.utils.IVersionInfo;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.UtilsException;

public class VersionUtilities {
    private static String PROPERTY_FILE_RESOURCE_NAME = "/govwayVersion.properties";
    private static String BUILD_VERSION_PROPERTY = "buildVersion";
    private static String VERSION_PROPERTY = "version";
    private static String INFO_VERSION_PROPERTY = "infoVersion";

    public static void setPROPERTY_FILE_RESOURCE_NAME(String PROPERTY_FILE_RESOURCE_NAME) {
        VersionUtilities.PROPERTY_FILE_RESOURCE_NAME = PROPERTY_FILE_RESOURCE_NAME;
    }

    public static void setBUILD_VERSION_PROPERTY(String bUILD_VERSION_PROPERTY) {
        BUILD_VERSION_PROPERTY = bUILD_VERSION_PROPERTY;
    }

    public static void setVERSION_PROPERTY(String VERSION_PROPERTY) {
        VersionUtilities.VERSION_PROPERTY = VERSION_PROPERTY;
    }

    public static void setINFO_VERSION_PROPERTY(String INFO_VERSION_PROPERTY) {
        VersionUtilities.INFO_VERSION_PROPERTY = INFO_VERSION_PROPERTY;
    }

    public static String readVersion() throws UtilsException {
        return VersionUtilities._read(VERSION_PROPERTY);
    }

    public static String readVersion(InputStream is) throws UtilsException {
        return VersionUtilities._read(is, VERSION_PROPERTY);
    }

    public static String readVersion(Properties p) {
        return VersionUtilities._read(p, VERSION_PROPERTY);
    }

    public static String readBuildVersion() throws UtilsException {
        return VersionUtilities._read(BUILD_VERSION_PROPERTY);
    }

    public static String readBuildVersion(InputStream is) throws UtilsException {
        return VersionUtilities._read(is, BUILD_VERSION_PROPERTY);
    }

    public static String readBuildVersion(Properties p) {
        return VersionUtilities._read(p, BUILD_VERSION_PROPERTY);
    }

    public static IVersionInfo readInfoVersion() throws UtilsException {
        return VersionUtilities._instance(VersionUtilities._read(INFO_VERSION_PROPERTY));
    }

    public static IVersionInfo readInfoVersion(InputStream is) throws UtilsException {
        return VersionUtilities._instance(VersionUtilities._read(is, INFO_VERSION_PROPERTY));
    }

    public static IVersionInfo readInfoVersion(Properties p) throws UtilsException {
        return VersionUtilities._instance(VersionUtilities._read(p, INFO_VERSION_PROPERTY));
    }

    private static IVersionInfo _instance(String className) throws UtilsException {
        if (className != null && !StringUtils.isEmpty((String)className)) {
            try {
                return (IVersionInfo)Utilities.newInstance(className);
            }
            catch (Exception e) {
                throw new UtilsException(e.getMessage(), e);
            }
        }
        return null;
    }

    private static String _read(String propertyName) throws UtilsException {
        InputStream is = VersionUtilities.class.getResourceAsStream(PROPERTY_FILE_RESOURCE_NAME);
        return VersionUtilities._read(is, propertyName);
    }

    private static String _read(InputStream is, String propertyName) throws UtilsException {
        try {
            if (is != null) {
                Properties p = new Properties();
                p.load(is);
                return VersionUtilities._read(p, propertyName);
            }
            return null;
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    private static String _read(Properties p, String propertyName) {
        String s = p.getProperty(propertyName);
        if (s != null) {
            s = s.trim();
        }
        return s;
    }
}

