/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.cache;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.openspcoop2.utils.Semaphore;
import org.openspcoop2.utils.SemaphoreLock;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.cache.Cache;
import org.openspcoop2.utils.cache.CacheAlgorithm;
import org.openspcoop2.utils.cache.CacheResponse;
import org.openspcoop2.utils.cache.CacheType;
import org.slf4j.Logger;

public abstract class AbstractCacheWrapper {
    private final Semaphore lockCache = new Semaphore("AbstractCacheWrapper");
    private Cache cache = null;
    private Logger log = null;
    private String cacheName = null;

    public AbstractCacheWrapper(CacheType cacheType, String cacheName, Logger log) throws UtilsException {
        this(cacheType, cacheName, true, log, null, null, null, null);
    }

    public AbstractCacheWrapper(CacheType cacheType, String cacheName, boolean initializeCache, Logger log) throws UtilsException {
        this(cacheType, cacheName, initializeCache, log, null, null, null, null);
    }

    public AbstractCacheWrapper(CacheType cacheType, String cacheName, Logger log, Integer cacheSize, CacheAlgorithm cacheAlgorithm, Integer itemIdleTimeSeconds, Integer itemLifeTimeSeconds) throws UtilsException {
        this(cacheType, cacheName, true, log, cacheSize, cacheAlgorithm, itemIdleTimeSeconds, itemLifeTimeSeconds);
    }

    private AbstractCacheWrapper(CacheType cacheType, String cacheName, boolean initializeCache, Logger log, Integer cacheSize, CacheAlgorithm cacheAlgorithm, Integer itemIdleTimeSeconds, Integer itemLifeTimeSeconds) throws UtilsException {
        if (cacheName == null) {
            throw new UtilsException("Cache name undefined");
        }
        this.cacheName = cacheName;
        if (log == null) {
            throw new UtilsException("Logger undefined");
        }
        this.log = log;
        if (initializeCache) {
            this.initCacheConfigurazione(cacheType, cacheSize, cacheAlgorithm, itemIdleTimeSeconds, itemLifeTimeSeconds);
        }
    }

    public String getCacheName() {
        return this.cacheName;
    }

    private void initCacheConfigurazione(CacheType cacheType, Integer cacheSize, CacheAlgorithm cacheAlgorithm, Integer itemIdleTimeSeconds, Integer itemLifeTimeSeconds) throws UtilsException {
        this.cache = new Cache(cacheType, this.cacheName);
        String msg = null;
        if (cacheSize != null || cacheAlgorithm != null) {
            if (cacheSize != null) {
                int dimensione = -1;
                try {
                    dimensione = cacheSize;
                    msg = "Cache size (" + this.cacheName + "): " + dimensione;
                    this.log.debug(msg);
                    this.cache.setCacheSize(dimensione);
                }
                catch (Exception error) {
                    throw new UtilsException("Cache size parameter wrong (" + this.cacheName + "): " + error.getMessage());
                }
            }
            if (cacheAlgorithm != null) {
                msg = "Cache algorithm (" + this.cacheName + "): " + cacheAlgorithm.name();
                this.log.debug(msg);
                this.cache.setCacheAlgoritm(cacheAlgorithm);
            }
        }
        if (itemIdleTimeSeconds != null || itemLifeTimeSeconds != null) {
            if (itemIdleTimeSeconds != null) {
                int itemIdleTime = -1;
                try {
                    itemIdleTime = itemIdleTimeSeconds;
                    msg = "Cache 'IdleTime' attribute (" + this.cacheName + "): " + itemIdleTimeSeconds;
                    this.log.debug(msg);
                    this.cache.setItemIdleTime(itemIdleTime);
                }
                catch (Exception error) {
                    throw new UtilsException("Cache 'IdleTime' attribute wrong (" + this.cacheName + "): " + error.getMessage());
                }
            }
            if (itemLifeTimeSeconds != null) {
                int itemLifeSecond = -1;
                try {
                    itemLifeSecond = itemLifeTimeSeconds;
                    msg = "Cache 'LifeTime' attribute (" + this.cacheName + "): " + itemLifeSecond;
                    this.log.debug(msg);
                    this.cache.setItemLifeTime(itemLifeSecond);
                }
                catch (Exception error) {
                    throw new UtilsException("Cache 'LifeTime' attribute wrong (" + this.cacheName + "): " + error.getMessage());
                }
            }
        }
        this.cache.build();
    }

    public Logger getLog() {
        return this.log;
    }

    public boolean isCacheEnabled() {
        return this.cache != null;
    }

    @Deprecated
    public void disableSyncronizedGet() throws UtilsException {
        if (this.cache == null) {
            throw new UtilsException("Cache disabled");
        }
        this.cache.disableSyncronizedGet();
    }

    @Deprecated
    public boolean isDisableSyncronizedGet() throws UtilsException {
        if (this.cache == null) {
            throw new UtilsException("Cache disabled");
        }
        return this.cache.isDisableSyncronizedGet();
    }

    public void resetCache() throws UtilsException {
        if (this.cache != null) {
            try {
                this.cache.clear();
            }
            catch (Exception e) {
                throw new UtilsException(e.getMessage(), e);
            }
        }
    }

    public String printStatsCache(String separator) throws UtilsException {
        if (this.cache != null) {
            try {
                return this.cache.printStats(separator);
            }
            catch (Exception e) {
                throw new UtilsException(e.getMessage(), e);
            }
        }
        throw new UtilsException("Cache disabled");
    }

    public void enableCache() throws UtilsException {
        if (this.cache != null) {
            throw new UtilsException("Cache already enabled");
        }
        try {
            this.cache = new Cache(CacheType.JCS, this.cacheName);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public void enableCache(Integer cacheSize, Boolean cacheAlgorithmLRU, Integer itemIdleTimeSeconds, Integer itemLifeTimeSeconds) throws UtilsException {
        CacheAlgorithm cacheAlgorithm = null;
        if (cacheAlgorithmLRU != null) {
            cacheAlgorithm = cacheAlgorithmLRU != false ? CacheAlgorithm.LRU : CacheAlgorithm.MRU;
        }
        this.enableCache(cacheSize, cacheAlgorithm, itemIdleTimeSeconds, itemLifeTimeSeconds);
    }

    public void enableCache(Integer cacheSize, CacheAlgorithm cacheAlgorithm, Integer itemIdleTimeSeconds, Integer itemLifeTimeSeconds) throws UtilsException {
        if (this.cache != null) {
            throw new UtilsException("Cache already enabled");
        }
        try {
            this.initCacheConfigurazione(CacheType.JCS, cacheSize, cacheAlgorithm, itemIdleTimeSeconds, itemLifeTimeSeconds);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public void disableCache() throws UtilsException {
        if (this.cache == null) {
            throw new UtilsException("Cache already disabled");
        }
        try {
            this.cache.clear();
            this.cache = null;
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public String listKeysCache(String separator) throws UtilsException {
        if (this.cache != null) {
            try {
                return this.cache.printKeys(separator);
            }
            catch (Exception e) {
                throw new UtilsException(e.getMessage(), e);
            }
        }
        throw new UtilsException("Cache disabled");
    }

    public String getObjectCache(String key) throws UtilsException {
        if (this.cache != null) {
            try {
                Object o = this.cache.get(key);
                if (o != null) {
                    return o.toString();
                }
                return "Object with key [" + key + "] not exists";
            }
            catch (Exception e) {
                throw new UtilsException(e.getMessage(), e);
            }
        }
        throw new UtilsException("Cache disabled");
    }

    public String removeObjectCache(String key) throws UtilsException {
        if (this.cache != null) {
            try {
                Object o = this.cache.get(key);
                if (o != null) {
                    this.cache.remove(key);
                    return "Object with key [" + key + "] deleted";
                }
                return "Object with key [" + key + "] not exists";
            }
            catch (Exception e) {
                throw new UtilsException(e.getMessage(), e);
            }
        }
        throw new UtilsException("Cache disabled");
    }

    public abstract Object getDriver(Object var1) throws UtilsException;

    public abstract boolean isCachableException(Throwable var1);

    public String getKeyCache(String keyCacheParam, String methodName) {
        return this.buildKeyCache(keyCacheParam, methodName);
    }

    private String buildKeyCache(String keyCacheParam, String methodName) {
        if (keyCacheParam != null && !"".equals(keyCacheParam)) {
            return methodName + "." + keyCacheParam;
        }
        return methodName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void duplicateObjectCache(String oldKeyCacheParam, String oldMethodName, String newKeyCacheParam, String newMethodName, boolean debug, boolean throwExceptionIfNotExists) throws UtilsException {
        if (this.cache == null) {
            throw new UtilsException("Cache disabled");
        }
        SemaphoreLock lock = this.lockCache.acquireThrowRuntime("duplicateObjectCache");
        try {
            String oldKey = this.buildKeyCache(oldKeyCacheParam, oldMethodName);
            CacheResponse response = (CacheResponse)this.cache.get(oldKey);
            if (response != null) {
                String newKey = this.buildKeyCache(newKeyCacheParam, newMethodName);
                this.cache.remove(newKey);
                this.cache.put(newKey, response);
                this.log.debug("@" + newKey + "@ Entry add");
            } else {
                if (debug) {
                    this.log.debug("@" + oldKey + "@ Entry not exists");
                }
                if (throwExceptionIfNotExists) {
                    throw new UtilsException("Entry with key [" + oldKey + "] not exists");
                }
            }
        }
        finally {
            this.lockCache.release(lock, "duplicateObjectCache");
        }
    }

    public Object getObjectCache(Object driverParam, boolean debug, String keyCacheParam, String methodName, Object ... arguments) throws Throwable {
        return this._getObjectCache(driverParam, debug, keyCacheParam, methodName, null, arguments);
    }

    public Object getObjectCache(Object driverParam, boolean debug, String keyCacheParam, String methodName, Class<?>[] cArguments, Object ... arguments) throws Throwable {
        return this._getObjectCache(driverParam, debug, keyCacheParam, methodName, cArguments, arguments);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public Object _getObjectCache(Object driverParam, boolean debug, String keyCacheParam, String methodName, Class<?>[] cArguments, Object ... arguments) throws Throwable {
        block43: {
            block45: {
                block44: {
                    block46: {
                        cachableException = null;
                        notCachableException = null;
                        obj = null;
                        throwException = false;
                        if (methodName == null) {
                            throw new UtilsException("MethodName undefined");
                        }
                        keyCache = null;
                        if (this.cache != null) break block46;
                        if (debug) {
                            this.log.debug("@method:" + methodName + "@ (Cache Disabled) search object with driver...");
                        }
                        try {
                            obj = this.getObject(driverParam, debug, methodName, cArguments, arguments);
                        }
                        catch (Throwable e) {
                            if (this.isCachableException(e)) {
                                cachableException = e;
                                break block43;
                            }
                            notCachableException = e;
                        }
                        break block43;
                    }
                    keyCache = this.buildKeyCache(keyCacheParam, methodName);
                    response = (CacheResponse)this.cache.get(keyCache);
                    if (response != null) {
                        if (response.getObject() != null) {
                            if (debug) {
                                this.log.debug("@" + keyCache + "@ Object (type:" + response.getObject().getClass().getName() + ") (method:" + methodName + ") found in cache.");
                            }
                            return response.getObject();
                        }
                        if (response.isObjectNull()) {
                            if (debug) {
                                this.log.debug("@" + keyCache + "@ Response null (method:" + methodName + ") found in cache.");
                            }
                            return null;
                        }
                        if (response.getException() != null) {
                            this.log.debug("@" + keyCache + "@ Exception (type:" + response.getException().getClass().getName() + ") (method:" + methodName + ") found in cache.");
                            throwException = true;
                            throw (Throwable)response.getException();
                        }
                        this.log.error("@" + keyCache + "@ Found entry in cache with key [" + keyCache + "] (method:" + methodName + ") without object and exception???");
                    }
                    lock = this.lockCache.acquire("getObjectCache");
                    response = (CacheResponse)this.cache.get(keyCache);
                    if (response == null) ** GOTO lbl63
                    if (response.getObject() == null) break block44;
                    if (debug) {
                        this.log.debug("@" + keyCache + "@ Object (type:" + response.getObject().getClass().getName() + ") (method:" + methodName + ") found in cache.");
                    }
                    var14_15 = response.getObject();
                    this.lockCache.release(lock, "getObjectCache");
                    return var14_15;
                }
                if (!response.isObjectNull()) break block45;
                if (debug) {
                    this.log.debug("@" + keyCache + "@ Response null (method:" + methodName + ") found in cache.");
                }
                var14_16 = null;
                this.lockCache.release(lock, "getObjectCache");
                return var14_16;
            }
            try {
                try {
                    if (response.getException() != null) {
                        this.log.debug("@" + keyCache + "@ Exception (type:" + response.getException().getClass().getName() + ") (method:" + methodName + ") found in cache.");
                        throwException = true;
                        throw (Throwable)response.getException();
                    }
                    this.log.error("@" + keyCache + "@ Found entry in cache with key [" + keyCache + "] (method:" + methodName + ") without object and exception???");
lbl63:
                    // 2 sources

                    if (debug) {
                        this.log.debug("@" + keyCache + "@ search object (method:" + methodName + ") with driver...");
                    }
                    nullObject = false;
                    cacheble = false;
                    try {
                        obj = this.getObject(driverParam, debug, methodName, cArguments, arguments);
                        nullObject = true;
                        cacheble = true;
                    }
                    catch (Throwable e) {
                        if (this.isCachableException(e)) {
                            cachableException = e;
                            cacheble = true;
                        }
                        notCachableException = e;
                    }
                    if (!cacheble) break block43;
                    try {
                        responseCache = new CacheResponse();
                        if (cachableException != null) {
                            if (debug) {
                                this.log.debug("@" + keyCache + "@ Add Exception in cache");
                            }
                            responseCache.setException(cachableException);
                        } else if (obj != null) {
                            if (debug) {
                                this.log.debug("@" + keyCache + "@ Add Object in cache");
                            }
                            responseCache.setObject((Serializable)obj);
                        } else if (nullObject) {
                            if (debug) {
                                this.log.debug("@" + keyCache + "@ Add Null Response in cache");
                            }
                            responseCache.setObjectNull(true);
                        }
                        this.cache.put(keyCache, responseCache);
                    }
                    catch (UtilsException e) {
                        this.log.error("@" + keyCache + "@ error occurs during insert in cache: " + e.getMessage(), (Throwable)e);
                    }
                }
                catch (Throwable e) {
                    if (!throwException) {
                        this.log.error("@" + keyCache + "@ Error occurs: " + e.getMessage(), e);
                        throw new UtilsException(e.getMessage(), e);
                    }
                    cachableException = e;
                }
            }
            catch (Throwable var17_23) {
                throw var17_23;
            }
            finally {
                this.lockCache.release(lock, "getObjectCache");
            }
        }
        cacheMsg = "";
        cacheMsg = this.cache != null && keyCache != null ? "@key:" + keyCache + "@" : "@method:" + methodName + "@";
        if (cachableException != null) {
            if (debug) {
                this.log.debug((String)cacheMsg + " throw CachableException: " + cachableException.getClass().getName());
            }
            throw cachableException;
        }
        if (notCachableException != null) {
            if (debug) {
                this.log.debug((String)cacheMsg + " throw NotCachableException: " + notCachableException.getClass().getName());
            }
            throw notCachableException;
        }
        if (obj != null) {
            if (debug) {
                this.log.debug((String)cacheMsg + " return Object: " + obj.getClass().getName());
            }
            return obj;
        }
        if (debug) {
            this.log.debug((String)cacheMsg + " return null response");
        }
        return null;
    }

    private Object getObject(Object driverParam, boolean debug, String methodName, Class<?>[] cArguments, Object ... arguments) throws Throwable {
        Object obj;
        block21: {
            obj = null;
            try {
                Object driver = this.getDriver(driverParam);
                if (driver == null) {
                    throw new UtilsException("Driver undefined");
                }
                if (arguments.length == 0) {
                    Method method = driver.getClass().getMethod(methodName, new Class[0]);
                    obj = method.invoke(driver, new Object[0]);
                    break block21;
                }
                if (arguments.length == 1) {
                    Method method = driver.getClass().getMethod(methodName, cArguments != null ? cArguments[0] : arguments[0].getClass());
                    obj = method.invoke(driver, arguments[0]);
                    break block21;
                }
                if (arguments.length == 2) {
                    Method method = driver.getClass().getMethod(methodName, cArguments != null ? cArguments[0] : arguments[0].getClass(), cArguments != null ? cArguments[1] : arguments[1].getClass());
                    obj = method.invoke(driver, arguments[0], arguments[1]);
                    break block21;
                }
                if (arguments.length == 3) {
                    Method method = driver.getClass().getMethod(methodName, cArguments != null ? cArguments[0] : arguments[0].getClass(), cArguments != null ? cArguments[1] : arguments[1].getClass(), cArguments != null ? cArguments[2] : arguments[2].getClass());
                    obj = method.invoke(driver, arguments[0], arguments[1], arguments[2]);
                    break block21;
                }
                if (arguments.length == 4) {
                    Method method = driver.getClass().getMethod(methodName, cArguments != null ? cArguments[0] : arguments[0].getClass(), cArguments != null ? cArguments[1] : arguments[1].getClass(), cArguments != null ? cArguments[2] : arguments[2].getClass(), cArguments != null ? cArguments[3] : arguments[3].getClass());
                    obj = method.invoke(driver, arguments[0], arguments[1], arguments[2], arguments[3]);
                    break block21;
                }
                if (arguments.length == 5) {
                    Method method = driver.getClass().getMethod(methodName, cArguments != null ? cArguments[0] : arguments[0].getClass(), cArguments != null ? cArguments[1] : arguments[1].getClass(), cArguments != null ? cArguments[2] : arguments[2].getClass(), cArguments != null ? cArguments[3] : arguments[3].getClass(), cArguments != null ? cArguments[4] : arguments[4].getClass());
                    obj = method.invoke(driver, arguments[0], arguments[1], arguments[2], arguments[3], arguments[4]);
                    break block21;
                }
                if (arguments.length == 6) {
                    Method method = driver.getClass().getMethod(methodName, cArguments != null ? cArguments[0] : arguments[0].getClass(), cArguments != null ? cArguments[1] : arguments[1].getClass(), cArguments != null ? cArguments[2] : arguments[2].getClass(), cArguments != null ? cArguments[3] : arguments[3].getClass(), cArguments != null ? cArguments[4] : arguments[4].getClass(), cArguments != null ? cArguments[5] : arguments[5].getClass());
                    obj = method.invoke(driver, arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5]);
                    break block21;
                }
                if (arguments.length == 7) {
                    Method method = driver.getClass().getMethod(methodName, cArguments != null ? cArguments[0] : arguments[0].getClass(), cArguments != null ? cArguments[1] : arguments[1].getClass(), cArguments != null ? cArguments[2] : arguments[2].getClass(), cArguments != null ? cArguments[3] : arguments[3].getClass(), cArguments != null ? cArguments[4] : arguments[4].getClass(), cArguments != null ? cArguments[5] : arguments[5].getClass(), cArguments != null ? cArguments[6] : arguments[6].getClass());
                    obj = method.invoke(driver, arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6]);
                    break block21;
                }
                if (arguments.length == 8) {
                    Method method = driver.getClass().getMethod(methodName, cArguments != null ? cArguments[0] : arguments[0].getClass(), cArguments != null ? cArguments[1] : arguments[1].getClass(), cArguments != null ? cArguments[2] : arguments[2].getClass(), cArguments != null ? cArguments[3] : arguments[3].getClass(), cArguments != null ? cArguments[4] : arguments[4].getClass(), cArguments != null ? cArguments[5] : arguments[5].getClass(), cArguments != null ? cArguments[6] : arguments[6].getClass(), cArguments != null ? cArguments[7] : arguments[7].getClass());
                    obj = method.invoke(driver, arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7]);
                    break block21;
                }
                if (arguments.length == 9) {
                    Method method = driver.getClass().getMethod(methodName, cArguments != null ? cArguments[0] : arguments[0].getClass(), cArguments != null ? cArguments[1] : arguments[1].getClass(), cArguments != null ? cArguments[2] : arguments[2].getClass(), cArguments != null ? cArguments[3] : arguments[3].getClass(), cArguments != null ? cArguments[4] : arguments[4].getClass(), cArguments != null ? cArguments[5] : arguments[5].getClass(), cArguments != null ? cArguments[6] : arguments[6].getClass(), cArguments != null ? cArguments[7] : arguments[7].getClass(), cArguments != null ? cArguments[8] : arguments[8].getClass());
                    obj = method.invoke(driver, arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8]);
                    break block21;
                }
                if (arguments.length == 10) {
                    Method method = driver.getClass().getMethod(methodName, cArguments != null ? cArguments[0] : arguments[0].getClass(), cArguments != null ? cArguments[1] : arguments[1].getClass(), cArguments != null ? cArguments[2] : arguments[2].getClass(), cArguments != null ? cArguments[3] : arguments[3].getClass(), cArguments != null ? cArguments[4] : arguments[4].getClass(), cArguments != null ? cArguments[5] : arguments[5].getClass(), cArguments != null ? cArguments[6] : arguments[6].getClass(), cArguments != null ? cArguments[7] : arguments[7].getClass(), cArguments != null ? cArguments[8] : arguments[8].getClass(), cArguments != null ? cArguments[9] : arguments[9].getClass());
                    obj = method.invoke(driver, arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9]);
                    break block21;
                }
                if (arguments.length == 11) {
                    Method method = driver.getClass().getMethod(methodName, cArguments != null ? cArguments[0] : arguments[0].getClass(), cArguments != null ? cArguments[1] : arguments[1].getClass(), cArguments != null ? cArguments[2] : arguments[2].getClass(), cArguments != null ? cArguments[3] : arguments[3].getClass(), cArguments != null ? cArguments[4] : arguments[4].getClass(), cArguments != null ? cArguments[5] : arguments[5].getClass(), cArguments != null ? cArguments[6] : arguments[6].getClass(), cArguments != null ? cArguments[7] : arguments[7].getClass(), cArguments != null ? cArguments[8] : arguments[8].getClass(), cArguments != null ? cArguments[9] : arguments[9].getClass(), cArguments != null ? cArguments[10] : arguments[10].getClass());
                    obj = method.invoke(driver, arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9], arguments[10]);
                    break block21;
                }
                if (arguments.length == 12) {
                    Method method = driver.getClass().getMethod(methodName, cArguments != null ? cArguments[0] : arguments[0].getClass(), cArguments != null ? cArguments[1] : arguments[1].getClass(), cArguments != null ? cArguments[2] : arguments[2].getClass(), cArguments != null ? cArguments[3] : arguments[3].getClass(), cArguments != null ? cArguments[4] : arguments[4].getClass(), cArguments != null ? cArguments[5] : arguments[5].getClass(), cArguments != null ? cArguments[6] : arguments[6].getClass(), cArguments != null ? cArguments[7] : arguments[7].getClass(), cArguments != null ? cArguments[8] : arguments[8].getClass(), cArguments != null ? cArguments[9] : arguments[9].getClass(), cArguments != null ? cArguments[10] : arguments[10].getClass(), cArguments != null ? cArguments[11] : arguments[11].getClass());
                    obj = method.invoke(driver, arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9], arguments[10], arguments[11]);
                    break block21;
                }
                if (arguments.length == 13) {
                    Method method = driver.getClass().getMethod(methodName, cArguments != null ? cArguments[0] : arguments[0].getClass(), cArguments != null ? cArguments[1] : arguments[1].getClass(), cArguments != null ? cArguments[2] : arguments[2].getClass(), cArguments != null ? cArguments[3] : arguments[3].getClass(), cArguments != null ? cArguments[4] : arguments[4].getClass(), cArguments != null ? cArguments[5] : arguments[5].getClass(), cArguments != null ? cArguments[6] : arguments[6].getClass(), cArguments != null ? cArguments[7] : arguments[7].getClass(), cArguments != null ? cArguments[8] : arguments[8].getClass(), cArguments != null ? cArguments[9] : arguments[9].getClass(), cArguments != null ? cArguments[10] : arguments[10].getClass(), cArguments != null ? cArguments[11] : arguments[11].getClass(), cArguments != null ? cArguments[12] : arguments[12].getClass());
                    obj = method.invoke(driver, arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9], arguments[10], arguments[11], arguments[12]);
                    break block21;
                }
                if (arguments.length == 14) {
                    Method method = driver.getClass().getMethod(methodName, cArguments != null ? cArguments[0] : arguments[0].getClass(), cArguments != null ? cArguments[1] : arguments[1].getClass(), cArguments != null ? cArguments[2] : arguments[2].getClass(), cArguments != null ? cArguments[3] : arguments[3].getClass(), cArguments != null ? cArguments[4] : arguments[4].getClass(), cArguments != null ? cArguments[5] : arguments[5].getClass(), cArguments != null ? cArguments[6] : arguments[6].getClass(), cArguments != null ? cArguments[7] : arguments[7].getClass(), cArguments != null ? cArguments[8] : arguments[8].getClass(), cArguments != null ? cArguments[9] : arguments[9].getClass(), cArguments != null ? cArguments[10] : arguments[10].getClass(), cArguments != null ? cArguments[11] : arguments[11].getClass(), cArguments != null ? cArguments[12] : arguments[12].getClass(), cArguments != null ? cArguments[13] : arguments[13].getClass());
                    obj = method.invoke(driver, arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9], arguments[10], arguments[11], arguments[12], arguments[13]);
                    break block21;
                }
                if (arguments.length == 15) {
                    Method method = driver.getClass().getMethod(methodName, cArguments != null ? cArguments[0] : arguments[0].getClass(), cArguments != null ? cArguments[1] : arguments[1].getClass(), cArguments != null ? cArguments[2] : arguments[2].getClass(), cArguments != null ? cArguments[3] : arguments[3].getClass(), cArguments != null ? cArguments[4] : arguments[4].getClass(), cArguments != null ? cArguments[5] : arguments[5].getClass(), cArguments != null ? cArguments[6] : arguments[6].getClass(), cArguments != null ? cArguments[7] : arguments[7].getClass(), cArguments != null ? cArguments[8] : arguments[8].getClass(), cArguments != null ? cArguments[9] : arguments[9].getClass(), cArguments != null ? cArguments[10] : arguments[10].getClass(), cArguments != null ? cArguments[11] : arguments[11].getClass(), cArguments != null ? cArguments[12] : arguments[12].getClass(), cArguments != null ? cArguments[13] : arguments[13].getClass(), cArguments != null ? cArguments[14] : arguments[14].getClass());
                    obj = method.invoke(driver, arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9], arguments[10], arguments[11], arguments[12], arguments[13], arguments[14]);
                    break block21;
                }
                throw new Exception("More than 15 arguments unsupported");
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() != null) {
                    throw e.getTargetException();
                }
                throw e;
            }
            catch (Exception e) {
                throw e;
            }
        }
        return obj;
    }
}

