/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.certificate;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.security.cert.CertStore;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.X509CRL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.certificate.CertificateFactory;

public class CRLCertstore
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<byte[]> crlBytes = null;
    private List<String> crlPaths = null;
    private transient java.security.cert.CertificateFactory certFactory = null;
    private transient List<X509CRL> caCrls = null;
    private transient CertStore certStore = null;

    public String toString() {
        StringBuilder bf = new StringBuilder();
        bf.append("CRLCertstore (");
        boolean first = true;
        if (this.crlPaths != null) {
            for (String crlPath : this.crlPaths) {
                if (!first) {
                    bf.append(", ");
                }
                bf.append(crlPath);
                first = false;
            }
        } else {
            bf.append("Nessuna crl definita");
        }
        bf.append(")");
        return bf.toString();
    }

    public static List<String> readCrlPaths(String crlPaths) {
        ArrayList<String> crlPathsList = new ArrayList<String>();
        if (crlPaths != null && StringUtils.isNotEmpty((String)crlPaths)) {
            if (crlPaths.contains(",")) {
                String[] tmp;
                for (String crlPath : tmp = crlPaths.split(",")) {
                    crlPathsList.add(crlPath.trim());
                }
            } else {
                crlPathsList.add(crlPaths.trim());
            }
        }
        return crlPathsList;
    }

    public static String convertToCrlPaths(List<String> crlPathsList) {
        StringBuilder sb = new StringBuilder();
        if (crlPathsList == null || crlPathsList.isEmpty()) {
            return null;
        }
        for (String path : crlPathsList) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(path);
        }
        return sb.toString();
    }

    public CRLCertstore(String crlPaths) throws UtilsException {
        this(crlPaths, null);
    }

    public CRLCertstore(String crlPaths, Map<String, byte[]> localResources) throws UtilsException {
        List<String> crlPathsList = CRLCertstore.readCrlPaths(crlPaths);
        this.initEngine(crlPathsList, localResources);
    }

    public CRLCertstore(List<String> crlPaths) throws UtilsException {
        this(crlPaths, null);
    }

    public CRLCertstore(List<String> crlPaths, Map<String, byte[]> localResources) throws UtilsException {
        this.initEngine(crlPaths, localResources);
    }

    private void initEngine(List<String> crlPaths, Map<String, byte[]> localResources) throws UtilsException {
        try {
            if (crlPaths == null || crlPaths.isEmpty()) {
                throw new UtilsException("crlPaths non indicato");
            }
            this.crlPaths = crlPaths;
            this.crlBytes = new ArrayList<byte[]>();
            for (String crlPath : crlPaths) {
                if (localResources != null && !localResources.isEmpty() && localResources.containsKey(crlPath)) {
                    byte[] r = localResources.get(crlPath);
                    if (r == null || r.length <= 0) continue;
                    this.crlBytes.add(r);
                    continue;
                }
                this.initEngineCrl(crlPath);
            }
            this.initCRL();
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    private void initEngineCrl(String crlPath) throws UtilsException, IOException {
        byte[] crlBytesAdd = null;
        File fStore = new File(crlPath);
        boolean fStoreExists = fStore.exists();
        try (InputStream isStore = fStoreExists ? new FileInputStream(fStore) : CRLCertstore.class.getResourceAsStream(crlPath);){
            if (isStore != null) {
                crlBytesAdd = Utilities.getAsByteArray(isStore);
            }
        }
        if (crlBytesAdd == null && !fStoreExists) {
            isStore = CRLCertstore.class.getResourceAsStream("/" + crlPath);
            try {
                if (isStore != null) {
                    crlBytesAdd = Utilities.getAsByteArray(isStore);
                }
            }
            finally {
                if (isStore != null) {
                    isStore.close();
                }
            }
        }
        if (crlBytesAdd == null) {
            throw new UtilsException("Store [" + crlPath + "] not found");
        }
        this.crlBytes.add(crlBytesAdd);
    }

    private void checkInit() throws UtilsException {
        if (this.caCrls == null) {
            this.initCRL();
        }
    }

    private synchronized void initCRL() throws UtilsException {
        if (this.caCrls == null) {
            try {
                this.certFactory = CertificateFactory.getCertificateFactory();
            }
            catch (Exception e) {
                throw new UtilsException("Error getInstance CertificateFactory: " + e.getMessage(), e);
            }
            this.caCrls = new ArrayList<X509CRL>();
            for (int i = 0; i < this.crlBytes.size(); ++i) {
                byte[] crl = this.crlBytes.get(i);
                try (ByteArrayInputStream bin = new ByteArrayInputStream(crl);){
                    X509CRL caCrl = (X509CRL)this.certFactory.generateCRL(bin);
                    this.caCrls.add(caCrl);
                    continue;
                }
                catch (Exception e) {
                    throw new UtilsException("Error loading CRL '" + this.crlPaths.get(i) + "': " + e.getMessage(), e);
                }
            }
            try {
                CollectionCertStoreParameters certStoreParams = new CollectionCertStoreParameters(this.caCrls);
                this.certStore = CertStore.getInstance("Collection", certStoreParams);
            }
            catch (Exception e) {
                throw new UtilsException("Build CertStore failed: " + e.getMessage(), e);
            }
        }
    }

    public java.security.cert.CertificateFactory getCertFactory() throws UtilsException {
        this.checkInit();
        return this.certFactory;
    }

    public List<X509CRL> getCaCrls() throws UtilsException {
        this.checkInit();
        return this.caCrls;
    }

    public CertStore getCertStore() throws UtilsException {
        this.checkInit();
        return this.certStore;
    }

    public int countCrls() {
        return this.crlBytes != null ? this.crlBytes.size() : 0;
    }
}

