/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.certificate;

import java.security.cert.CertificateParsingException;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DLSequence;

public class CertificatePolicyEntry {
    private ASN1ObjectIdentifier asn1ObjectIdentifier;
    private List<Object> value = new ArrayList<Object>();
    private List<CertificatePolicyEntry> entries = new ArrayList<CertificatePolicyEntry>();

    public CertificatePolicyEntry(DLSequence dl) {
        this(dl, 0);
    }

    private CertificatePolicyEntry(DLSequence dl, int level) {
        for (int j = 0; j < dl.size(); ++j) {
            ASN1Encodable o = dl.getObjectAt(j);
            if (o == null) continue;
            this.init(o, level);
        }
    }

    private void init(Object o, int level) {
        if (o instanceof ASN1ObjectIdentifier) {
            this.asn1ObjectIdentifier = (ASN1ObjectIdentifier)o;
        } else if (o instanceof DLSequence) {
            if (level < 10) {
                CertificatePolicyEntry cpe = new CertificatePolicyEntry((DLSequence)o, level + 1);
                this.entries.add(cpe);
            }
        } else {
            this.value.add(o);
        }
    }

    public ASN1ObjectIdentifier getAsn1ObjectIdentifier() {
        return this.asn1ObjectIdentifier;
    }

    public String getOID() {
        return this.asn1ObjectIdentifier != null ? this.asn1ObjectIdentifier.getId() : null;
    }

    public List<Object> getObjectValues() {
        return this.value;
    }

    public Object getObjectValue(int index) {
        return this.value != null && this.value.size() > index ? this.value.get(index) : null;
    }

    public List<String> getValues() {
        ArrayList<String> s = new ArrayList<String>();
        if (this.value != null && !this.value.isEmpty()) {
            for (Object o : this.value) {
                s.add(o.toString());
            }
        }
        return s;
    }

    public String getValue(int index) {
        if (this.value != null && this.value.size() > index) {
            return this.value.get(index) != null ? this.value.get(index).toString() : null;
        }
        return null;
    }

    public boolean containsValue(String value) throws CertificateParsingException {
        if (value == null) {
            throw new CertificateParsingException("Param value undefined");
        }
        if (this.value != null && !this.value.isEmpty()) {
            for (Object o : this.value) {
                if (!value.equals(o.toString())) continue;
                return true;
            }
        }
        return false;
    }

    public List<CertificatePolicyEntry> getEntries() {
        return this.entries;
    }

    public CertificatePolicyEntry getEntry(int index) {
        return this.entries != null && this.entries.size() > index ? this.entries.get(index) : null;
    }

    public CertificatePolicyEntry getEntry(String oid) throws CertificateParsingException {
        return this.getEntryByOID(oid);
    }

    public CertificatePolicyEntry getEntryByOID(String oid) throws CertificateParsingException {
        if (oid == null) {
            throw new CertificateParsingException("Param oid undefined");
        }
        if (this.entries != null && !this.entries.isEmpty()) {
            for (CertificatePolicyEntry certificatePolicyEntry : this.entries) {
                if (!oid.equals(certificatePolicyEntry.getOID())) continue;
                return certificatePolicyEntry;
            }
        }
        return null;
    }

    public boolean hasCertificatePolicyEntry(String oid) throws CertificateParsingException {
        if (oid == null) {
            throw new CertificateParsingException("Param oid undefined");
        }
        return this.getEntryByOID(oid) != null;
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String prefix) {
        int index;
        StringBuilder sb = new StringBuilder();
        if (this.asn1ObjectIdentifier != null) {
            sb.append(prefix);
            sb.append("OID:");
            sb.append(this.asn1ObjectIdentifier.getId());
        }
        if (this.value != null && !this.value.isEmpty()) {
            index = 0;
            for (Object object : this.value) {
                sb.append("\n");
                sb.append(prefix);
                sb.append("Value[" + index + "]:");
                sb.append(object.toString());
                ++index;
            }
        }
        if (this.entries != null && !this.entries.isEmpty()) {
            index = 0;
            for (CertificatePolicyEntry certificatePolicyEntry : this.entries) {
                sb.append("\n");
                sb.append(prefix);
                sb.append("CertificatePolicyEntry[" + index + "]{\n");
                sb.append(certificatePolicyEntry.toString(prefix + "\t"));
                sb.append("\n" + prefix + "}");
                ++index;
            }
        }
        return sb.toString();
    }
}

