/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.certificate;

import java.security.PrivateKey;
import java.security.PublicKey;
import javax.crypto.SecretKey;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKey;
import org.apache.cxf.rs.security.jose.jwk.KeyType;

public class JwkUtils {
    private JwkUtils() {
    }

    public static PrivateKey toPrivateKey(JsonWebKey jsonWebKey) {
        if (KeyType.EC.equals((Object)jsonWebKey.getKeyType())) {
            return org.apache.cxf.rs.security.jose.jwk.JwkUtils.toECPrivateKey((JsonWebKey)jsonWebKey);
        }
        return org.apache.cxf.rs.security.jose.jwk.JwkUtils.toRSAPrivateKey((JsonWebKey)jsonWebKey);
    }

    public static PublicKey toPublicKey(JsonWebKey jsonWebKey) {
        if (KeyType.EC.equals((Object)jsonWebKey.getKeyType())) {
            return org.apache.cxf.rs.security.jose.jwk.JwkUtils.toECPublicKey((JsonWebKey)jsonWebKey);
        }
        return org.apache.cxf.rs.security.jose.jwk.JwkUtils.toRSAPublicKey((JsonWebKey)jsonWebKey);
    }

    public static SecretKey toSecretKey(JsonWebKey jsonWebKey) {
        return org.apache.cxf.rs.security.jose.jwk.JwkUtils.toSecretKey((JsonWebKey)jsonWebKey);
    }
}

