/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.certificate;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.Provider;
import java.security.Security;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.UtilsException;

public class KeystoreUtils {
    private KeystoreUtils() {
    }

    public static KeyStore readKeystore(InputStream is, String tipoKeystore, String passwordKeystore) throws UtilsException {
        byte[] keystoreBytes = Utilities.getAsByteArray(is);
        return KeystoreUtils.readKeystore(keystoreBytes, tipoKeystore, passwordKeystore);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static KeyStore readKeystore(byte[] keystoreBytes, String tipoKeystore, String passwordKeystore) throws UtilsException {
        try (ByteArrayInputStream bin = new ByteArrayInputStream(keystoreBytes);){
            KeyStore keystore = KeyStore.getInstance(tipoKeystore);
            keystore.load(bin, passwordKeystore != null ? passwordKeystore.toCharArray() : "".toCharArray());
            KeyStore keyStore = keystore;
            return keyStore;
        }
        catch (Exception e) {
            try (ByteArrayInputStream bin2 = new ByteArrayInputStream(keystoreBytes);){
                Provider p = Security.getProvider("BC");
                if (p == null) throw new UtilsException(e.getMessage(), e);
                KeyStore keystore2 = KeyStore.getInstance(tipoKeystore, p);
                keystore2.load(bin2, passwordKeystore != null ? passwordKeystore.toCharArray() : "".toCharArray());
                KeyStore keyStore2 = keystore2;
                return keyStore2;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new UtilsException(e.getMessage(), e);
        }
    }
}

