/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.certificate.byok;

import org.apache.commons.lang.StringUtils;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.certificate.byok.BYOKInstance;
import org.openspcoop2.utils.io.Base64Utilities;
import org.openspcoop2.utils.io.HexBinaryUtilities;
import org.openspcoop2.utils.json.JSONUtils;
import org.openspcoop2.utils.json.JsonPathExpressionEngine;
import org.slf4j.Logger;

public class BYOKRemoteUtils {
    private BYOKRemoteUtils() {
    }

    public static byte[] normalizeResponse(BYOKInstance instance, byte[] content, Logger log) throws UtilsException {
        if (content != null && content.length > 0) {
            if (instance.getConfig().getRemoteConfig().isHttpResponseBase64Encoded()) {
                content = Base64Utilities.decode(content);
            } else if (instance.getConfig().getRemoteConfig().isHttpResponseHexEncoded()) {
                content = HexBinaryUtilities.decode(new String(content).toCharArray());
            }
            return BYOKRemoteUtils.normalizeResponseByJsonPath(instance, content, log);
        }
        return content;
    }

    private static byte[] normalizeResponseByJsonPath(BYOKInstance instance, byte[] content, Logger log) throws UtilsException {
        JSONUtils jsonUtils;
        String pattern = instance.getConfig().getRemoteConfig().getHttpResponseJsonPath();
        if (pattern != null && StringUtils.isNotEmpty((String)pattern) && (jsonUtils = JSONUtils.getInstance()).isJson(content)) {
            String elementJson = new String(content);
            try {
                String valoreEstratto = JsonPathExpressionEngine.extractAndConvertResultAsString(elementJson, pattern, log);
                if (valoreEstratto == null || StringUtils.isEmpty((String)valoreEstratto)) {
                    throw new UtilsException("Read failure with pattern '" + pattern + "'");
                }
                content = valoreEstratto.getBytes();
                if (instance.getConfig().getRemoteConfig().isHttpResponseJsonPathBase64Encoded()) {
                    content = Base64Utilities.decode(content);
                } else if (instance.getConfig().getRemoteConfig().isHttpResponseJsonPathHexEncoded()) {
                    content = HexBinaryUtilities.decode(new String(content).toCharArray());
                }
            }
            catch (Exception e) {
                throw new UtilsException(e.getMessage(), e);
            }
        }
        return content;
    }
}

