/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.certificate.ocsp.test;

import java.io.File;
import java.io.InputStream;
import java.security.Provider;
import java.security.Security;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.Level;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.openspcoop2.utils.LoggerBuffer;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.certificate.ArchiveLoader;
import org.openspcoop2.utils.certificate.CRLDistributionPoint;
import org.openspcoop2.utils.certificate.Certificate;
import org.openspcoop2.utils.certificate.CertificateInfo;
import org.openspcoop2.utils.certificate.KeyStore;
import org.openspcoop2.utils.certificate.KeystoreType;
import org.openspcoop2.utils.certificate.ocsp.CertificateStatus;
import org.openspcoop2.utils.certificate.ocsp.CertificateStatusCode;
import org.openspcoop2.utils.certificate.ocsp.IOCSPResourceReader;
import org.openspcoop2.utils.certificate.ocsp.OCSPConfig;
import org.openspcoop2.utils.certificate.ocsp.OCSPManager;
import org.openspcoop2.utils.certificate.ocsp.OCSPRequestParams;
import org.openspcoop2.utils.certificate.ocsp.OCSPResourceReader;
import org.openspcoop2.utils.certificate.ocsp.OCSPValidator;
import org.openspcoop2.utils.certificate.ocsp.test.OpenSSLThread;
import org.openspcoop2.utils.io.Base64Utilities;
import org.openspcoop2.utils.resources.Charset;
import org.openspcoop2.utils.resources.FileSystemUtilities;
import org.openspcoop2.utils.transport.http.SSLUtilities;
import org.openspcoop2.utils.transport.ldap.test.LdapServerTest;
import org.slf4j.Logger;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class OCSPTest {
    public static Level LEVEL_LOG = Level.DEBUG;
    private static Logger log = null;
    private static boolean initialized = false;
    private static OCSPResourceReader ocspResourceReader;
    private static OCSPManager ocspManager;

    public static void main(String[] args) throws Exception {
        String tmp;
        String tmp2;
        LoggerWrapperFactory.setDefaultConsoleLogConfiguration(LEVEL_LOG, "%p %m %n %n");
        OCSPTest.checkGovWay();
        OCSPTest.checkGoogle();
        OCSPTest.checkAlternativeCrlCheck();
        OCSPTest.checkAlternativeCrlLdapCheck(false);
        OCSPTest.checkAlternativeCrlLdapCheck(true);
        String com = null;
        if (args != null && args.length > 0 && (tmp2 = args[0]) != null && StringUtils.isNotEmpty((String)tmp2)) {
            com = tmp2;
        }
        String waitStartupServer = null;
        if (args != null && args.length > 1 && (tmp = args[1]) != null && StringUtils.isNotEmpty((String)tmp)) {
            waitStartupServer = tmp;
        }
        OCSPTest.checkOCSPResponse_signedByResponderCertificate_case2(com, waitStartupServer);
        OCSPTest.checkOCSPResponse_signedByResponderCertificate_case2_differentNonce(com, waitStartupServer);
        OCSPTest.checkOCSPResponse_signedByResponderCertificate_case3(com, waitStartupServer);
        System.out.println("\n\nTestsuite completata con successo");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void _initialize() throws Exception {
        if (!initialized) {
            log = LoggerWrapperFactory.getLogger(OCSPTest.class);
            File f = null;
            try (InputStream is = OCSPTest.class.getResourceAsStream("/org/openspcoop2/utils/certificate/ocsp/test/ocsp_test.properties");){
                byte[] content = Utilities.getAsByteArray(is);
                f = File.createTempFile("test", ".properties");
                FileSystemUtilities.writeFile(f, content);
                OCSPManager.init(f.getAbsoluteFile(), true, false, log);
            }
            finally {
                if (f != null) {
                    f.delete();
                }
            }
            ocspResourceReader = new OCSPResourceReader();
            ocspManager = OCSPManager.getInstance();
            initialized = true;
        }
    }

    private static void initialize() throws Exception {
        if (!initialized) {
            OCSPTest._initialize();
        }
    }

    public static void checkGovWay() throws Exception {
        Security.insertProviderAt((Provider)new BouncyCastleProvider(), 2);
        try {
            OCSPTest.initialize();
            String host = "govway.org";
            int port = 443;
            OCSPTest._check(host, port, "govway");
            System.out.println("\n\nTest 'checkGovWay' terminato");
        }
        finally {
            Security.removeProvider("BC");
        }
    }

    public static void checkGoogle() throws Exception {
        Security.insertProviderAt((Provider)new BouncyCastleProvider(), 2);
        try {
            OCSPTest.initialize();
            String host = "google.it";
            int port = 443;
            OCSPTest._check(host, port, "google");
            OCSPTest._check(host, port, "google-alternative-url");
            System.out.println("\n\nTest 'checkGoogle' terminato");
        }
        finally {
            Security.removeProvider("BC");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkAlternativeCrlCheck() throws Exception {
        Security.insertProviderAt((Provider)new BouncyCastleProvider(), 2);
        try {
            OCSPTest.initialize();
            String configType = "alternativeCrlCheck";
            KeyStore trustStoreCA = null;
            try (InputStream is = OCSPTest.class.getResourceAsStream("/org/openspcoop2/utils/certificate/ocsp/test/crl/trustStore_ca.jks");){
                byte[] content = Utilities.getAsByteArray(is);
                trustStoreCA = new KeyStore(content, KeystoreType.JKS.getNome(), "123456");
            }
            File fCrl = null;
            try (InputStream is = OCSPTest.class.getResourceAsStream("/org/openspcoop2/utils/certificate/ocsp/test/crl/ExampleCA.crl");){
                String certificate;
                byte[] content = Utilities.getAsByteArray(is);
                fCrl = File.createTempFile("test", ".crl");
                FileSystemUtilities.writeFile(fCrl, content);
                String crl = fCrl.getAbsolutePath();
                try (InputStream isCert = OCSPTest.class.getResourceAsStream("/org/openspcoop2/utils/certificate/ocsp/test/crl/ExampleClient1.crt");){
                    certificate = Utilities.getAsString(isCert, Charset.UTF_8.getValue());
                    OCSPTest._check(certificate, "AlternativeCrlCheck-ExampleClient1", trustStoreCA, crl, configType, CertificateStatusCode.GOOD);
                }
                isCert = OCSPTest.class.getResourceAsStream("/org/openspcoop2/utils/certificate/ocsp/test/crl/ExampleClientScaduto.crt");
                try {
                    certificate = Utilities.getAsString(isCert, Charset.UTF_8.getValue());
                    OCSPTest._check(certificate, "AlternativeCrlCheck-ExampleClientScaduto", trustStoreCA, crl, configType, CertificateStatusCode.EXPIRED);
                }
                finally {
                    if (isCert != null) {
                        isCert.close();
                    }
                }
                isCert = OCSPTest.class.getResourceAsStream("/org/openspcoop2/utils/certificate/ocsp/test/crl/ExampleClientRevocato.crt");
                try {
                    certificate = Utilities.getAsString(isCert, Charset.UTF_8.getValue());
                    OCSPTest._check(certificate, "AlternativeCrlCheck-ExampleClientRevocato", trustStoreCA, crl, configType, CertificateStatusCode.REVOKED);
                }
                finally {
                    if (isCert != null) {
                        isCert.close();
                    }
                }
            }
            finally {
                if (fCrl != null) {
                    fCrl.delete();
                }
            }
            System.out.println("\n\nTest 'checkAlternativeCrlCheck' terminato");
        }
        finally {
            Security.removeProvider("BC");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkAlternativeCrlLdapCheck(boolean withCredentials) throws Exception {
        Security.insertProviderAt((Provider)new BouncyCastleProvider(), 2);
        try {
            File fLdapServer;
            block51: {
                OCSPTest.initialize();
                String configType = "alternativeCrlCheck";
                if (withCredentials) {
                    configType = "alternativeCrlCheckLdapCredentials";
                }
                KeyStore trustStoreCA = null;
                try (InputStream is = OCSPTest.class.getResourceAsStream("/org/openspcoop2/utils/certificate/ocsp/test/crl/trustStore_ca.jks");){
                    byte[] content = Utilities.getAsByteArray(is);
                    trustStoreCA = new KeyStore(content, KeystoreType.JKS.getNome(), "123456");
                }
                File fLdiff = null;
                fLdapServer = null;
                LdapServerTest server = null;
                try {
                    try (InputStream is = OCSPTest.class.getResourceAsStream("/org/openspcoop2/utils/certificate/ocsp/test/crl/ExampleCA.crl");
                         InputStream isLdiff = OCSPTest.class.getResourceAsStream("/org/openspcoop2/utils/certificate/ocsp/test/crl/server.ldif");){
                        String certificate;
                        byte[] content = Utilities.getAsByteArray(is);
                        String contentLdif = Utilities.getAsString(isLdiff, Charset.UTF_8.getValue());
                        contentLdif = contentLdif.replace("CRL-BASE-64", Base64Utilities.encodeAsString(content));
                        fLdapServer = File.createTempFile("testServer", ".dat");
                        FileSystemUtilities.deleteFile(fLdapServer);
                        FileSystemUtilities.mkdir(fLdapServer);
                        fLdiff = File.createTempFile("testServer", ".ldiff");
                        FileSystemUtilities.writeFile(fLdiff, contentLdif.getBytes());
                        FileSystemResource ldif = new FileSystemResource(fLdiff);
                        server = new LdapServerTest((Resource)ldif, Level.INFO);
                        server.setRootPartition("o=example,c=it");
                        server.setPort(9322);
                        boolean allowAnonymousAccess = !withCredentials;
                        server.start(fLdapServer.getPath(), allowAnonymousAccess);
                        String crl = "ldap://127.0.0.1:9322/cn=CRL%20Holder,o=example,c=it?certificateRevocationList";
                        try (InputStream isCert = OCSPTest.class.getResourceAsStream("/org/openspcoop2/utils/certificate/ocsp/test/crl/ExampleClient1.crt");){
                            certificate = Utilities.getAsString(isCert, Charset.UTF_8.getValue());
                            OCSPTest._check(certificate, "AlternativeCrlCheck-ExampleClient1", trustStoreCA, crl, configType, CertificateStatusCode.GOOD);
                        }
                        isCert = OCSPTest.class.getResourceAsStream("/org/openspcoop2/utils/certificate/ocsp/test/crl/ExampleClientScaduto.crt");
                        try {
                            certificate = Utilities.getAsString(isCert, Charset.UTF_8.getValue());
                            OCSPTest._check(certificate, "AlternativeCrlCheck-ExampleClientScaduto", trustStoreCA, crl, configType, CertificateStatusCode.EXPIRED);
                        }
                        finally {
                            if (isCert != null) {
                                isCert.close();
                            }
                        }
                        isCert = OCSPTest.class.getResourceAsStream("/org/openspcoop2/utils/certificate/ocsp/test/crl/ExampleClientRevocato.crt");
                        try {
                            certificate = Utilities.getAsString(isCert, Charset.UTF_8.getValue());
                            OCSPTest._check(certificate, "AlternativeCrlCheck-ExampleClientRevocato", trustStoreCA, crl, configType, CertificateStatusCode.REVOKED);
                        }
                        finally {
                            if (isCert != null) {
                                isCert.close();
                            }
                        }
                    }
                    if (server != null) {
                        server.shutdown(true);
                    }
                    if (fLdiff == null) break block51;
                }
                catch (Throwable throwable) {
                    if (server != null) {
                        server.shutdown(true);
                    }
                    if (fLdiff != null) {
                        FileSystemUtilities.deleteFile(fLdiff);
                    }
                    if (fLdapServer != null) {
                        FileSystemUtilities.deleteDir(fLdapServer);
                    }
                    throw throwable;
                }
                FileSystemUtilities.deleteFile(fLdiff);
            }
            if (fLdapServer != null) {
                FileSystemUtilities.deleteDir(fLdapServer);
            }
            System.out.println("\n\nTest 'checkAlternativeCrlCheck' terminato");
        }
        finally {
            Security.removeProvider("BC");
        }
    }

    public static String normalizeOpensslCommand(String opensslCmd) {
        String tmp;
        String com = "/usr/bin/openssl";
        if (opensslCmd != null && StringUtils.isNotEmpty((String)opensslCmd) && !"${opensslCmd}".equals(opensslCmd) && (tmp = opensslCmd) != null && StringUtils.isNotEmpty((String)tmp)) {
            com = tmp;
        }
        return com;
    }

    public static int normalizeWaitStartupServer(String waitStartupServer) {
        String tmp;
        int WAIT_STARTUP_SERVER = 3000;
        if (waitStartupServer != null && StringUtils.isNotEmpty((String)waitStartupServer) && !"${waitStartupServerMs}".equals(waitStartupServer) && (tmp = waitStartupServer) != null && StringUtils.isNotEmpty((String)tmp)) {
            WAIT_STARTUP_SERVER = Integer.valueOf(tmp);
        }
        return WAIT_STARTUP_SERVER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkOCSPResponse_signedByResponderCertificate_case2(String opensslCommandParam, String waitStartupServerParam) throws Exception {
        Security.insertProviderAt((Provider)new BouncyCastleProvider(), 2);
        try {
            OCSPTest.initialize();
            String configType_nonce = "signedByResponderCertificate_case2";
            KeyStore trustStore_nonce = null;
            String configType_no_nonce = "signedByResponderCertificate_case2-no-nonce";
            KeyStore trustStore_no_nonce = null;
            try (InputStream is = OCSPTest.class.getResourceAsStream("/org/openspcoop2/utils/certificate/ocsp/test/ocsp/ca_TEST.jks");){
                byte[] content = Utilities.getAsByteArray(is);
                trustStore_no_nonce = new KeyStore(content, KeystoreType.JKS.getNome(), "123456");
            }
            OpenSSLThread sslThread = new OpenSSLThread(OCSPTest.normalizeOpensslCommand(opensslCommandParam), 64900, "ocsp/ocsp_TEST.cert.pem", "ocsp/ocsp_TEST.key.pem", "ocsp/ca_TEST.cert.pem", "ocsp/index.txt", false);
            sslThread.start();
            Utilities.sleep(OCSPTest.normalizeWaitStartupServer(waitStartupServerParam));
            try {
                OCSPTest._checkOCSPResponse_signedByResponderCertificate("checkOCSPResponse_signedByResponderCertificate_case2", configType_nonce, trustStore_nonce);
                OCSPTest._checkOCSPResponse_signedByResponderCertificate("checkOCSPResponse_signedByResponderCertificate_case2_no-nonce", configType_no_nonce, trustStore_no_nonce);
            }
            finally {
                sslThread.setStop(true);
                sslThread.waitShutdown(200, 10000);
                sslThread.close();
            }
            System.out.println("\n\nTest 'checkOCSPResponse_signedByResponderCertificate_case2' terminato");
        }
        finally {
            Security.removeProvider("BC");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkOCSPResponse_signedByResponderCertificate_case2_differentNonce(String opensslCommandParam, String waitStartupServerParam) throws Exception {
        Security.insertProviderAt((Provider)new BouncyCastleProvider(), 2);
        try {
            OCSPTest.initialize();
            String configType_different_nonce = "signedByResponderCertificate_case2-different-nonce";
            KeyStore trustStore_different_nonce = null;
            OpenSSLThread sslThread = new OpenSSLThread(OCSPTest.normalizeOpensslCommand(opensslCommandParam), 64902, "ocsp/ocsp_TEST.cert.pem", "ocsp/ocsp_TEST.key.pem", "ocsp/ca_TEST.cert.pem", "ocsp/index.txt", true);
            sslThread.start();
            Utilities.sleep(OCSPTest.normalizeWaitStartupServer(waitStartupServerParam));
            try {
                try {
                    OCSPTest._checkOCSPResponse_signedByResponderCertificate("checkOCSPResponse_signedByResponderCertificate_case2_different-nonce", configType_different_nonce, trustStore_different_nonce);
                    throw new Exception("Attesa eccezione");
                }
                catch (Exception e) {
                    if (!e.getMessage().contains("OCSP Response not valid: nonces do not match")) {
                        throw e;
                    }
                    System.out.println("Generata eccezione attesa: " + e.getMessage());
                    sslThread.setStop(true);
                    sslThread.waitShutdown(200, 10000);
                    sslThread.close();
                }
            }
            catch (Throwable throwable) {
                sslThread.setStop(true);
                sslThread.waitShutdown(200, 10000);
                sslThread.close();
                throw throwable;
            }
            System.out.println("\n\nTest 'checkOCSPResponse_signedByResponderCertificate_case2_differentNonce' terminato");
        }
        finally {
            Security.removeProvider("BC");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkOCSPResponse_signedByResponderCertificate_case3(String opensslCommandParam, String waitStartupServerParam) throws Exception {
        Security.insertProviderAt((Provider)new BouncyCastleProvider(), 2);
        try {
            OCSPTest.initialize();
            String configType_nonce = "signedByResponderCertificate_case3";
            KeyStore trustStore_nonce = null;
            String configType_no_nonce = "signedByResponderCertificate_case3-no-nonce";
            KeyStore trustStore_no_nonce = null;
            try (InputStream is = OCSPTest.class.getResourceAsStream("/org/openspcoop2/utils/certificate/ocsp/test/ocsp/ca_TEST.jks");){
                byte[] content = Utilities.getAsByteArray(is);
                trustStore_no_nonce = new KeyStore(content, KeystoreType.JKS.getNome(), "123456");
            }
            String configType_noextendedkeyusage = "signedByResponderCertificate_case3-noextendedkeyusage";
            KeyStore trustStore_noextendedkeyusage = null;
            String configType_noca = "signedByResponderCertificate_case3-noca";
            KeyStore trustStore_noca = null;
            OpenSSLThread sslThread = new OpenSSLThread(OCSPTest.normalizeOpensslCommand(opensslCommandParam), 64901, "crl/ExampleClient1.crt", "crl/ExampleClient1.key", "ocsp/ca_TEST.cert.pem", "ocsp/index.txt", false);
            sslThread.start();
            Utilities.sleep(OCSPTest.normalizeWaitStartupServer(waitStartupServerParam));
            try {
                OCSPTest._checkOCSPResponse_signedByResponderCertificate("checkOCSPResponse_signedByResponderCertificate_case3", configType_nonce, trustStore_nonce);
                OCSPTest._checkOCSPResponse_signedByResponderCertificate("checkOCSPResponse_signedByResponderCertificate_case3_no-nonce", configType_no_nonce, trustStore_no_nonce);
                try {
                    OCSPTest._checkOCSPResponse_signedByResponderCertificate("checkOCSPResponse_signedByResponderCertificate_case3_noextendedkeyusage", configType_noextendedkeyusage, trustStore_noextendedkeyusage);
                    throw new Exception("Attesa eccezione");
                }
                catch (Exception e) {
                    if (!e.getMessage().contains("Signing certificate not valid for signing OCSP responses: extended key usage 'OCSP_SIGNING' not found")) {
                        throw e;
                    }
                    System.out.println("Generata eccezione attesa: " + e.getMessage());
                    try {
                        OCSPTest._checkOCSPResponse_signedByResponderCertificate("checkOCSPResponse_signedByResponderCertificate_case3_noca", configType_noca, trustStore_noca);
                        throw new Exception("Attesa eccezione");
                    }
                    catch (Exception e2) {
                        if (!e2.getMessage().contains("Signing certificate is not authorized to sign OCSP responses: unauthorized different issuer certificate 'C=IT,ST=Italy,L=Pisa,O=Example,CN=ExampleCA'")) {
                            throw e2;
                        }
                        System.out.println("Generata eccezione attesa: " + e2.getMessage());
                        sslThread.setStop(true);
                        sslThread.waitShutdown(200, 10000);
                        sslThread.close();
                    }
                }
            }
            catch (Throwable throwable) {
                sslThread.setStop(true);
                sslThread.waitShutdown(200, 10000);
                sslThread.close();
                throw throwable;
            }
            System.out.println("\n\nTest 'checkOCSPResponse_signedByResponderCertificate_case3' terminato");
        }
        finally {
            Security.removeProvider("BC");
        }
    }

    private static void _checkOCSPResponse_signedByResponderCertificate(String scenario, String configType, KeyStore trustStore) throws Exception {
        String certificate;
        try (InputStream isCert = OCSPTest.class.getResourceAsStream("/org/openspcoop2/utils/certificate/ocsp/test/ocsp/ee_TEST_Client-test.esempio.it.cert.pem");){
            certificate = Utilities.getAsString(isCert, Charset.UTF_8.getValue());
            OCSPTest._check(certificate, scenario + "+ExampleCertificatoValido", trustStore, null, configType, CertificateStatusCode.GOOD);
        }
        isCert = OCSPTest.class.getResourceAsStream("/org/openspcoop2/utils/certificate/ocsp/test/ocsp/ee_TEST_test.esempio.it.cert.pem");
        try {
            certificate = Utilities.getAsString(isCert, Charset.UTF_8.getValue());
            OCSPTest._check(certificate, scenario + "-ExampleCertificatoRevocato", trustStore, null, configType, CertificateStatusCode.REVOKED);
        }
        finally {
            if (isCert != null) {
                isCert.close();
            }
        }
    }

    private static void _check(String host, int port, String configType) throws Exception {
        String certificate = SSLUtilities.readPeerCertificates(host, port);
        OCSPTest._check(certificate, "Address: " + host + ":" + port, null, null, configType, null);
    }

    private static void _check(String certificate, String description, KeyStore trustStore, String crlInput, String configType, CertificateStatusCode expected) throws Exception {
        System.out.println("\n\n===================================================");
        System.out.println(description);
        System.out.println("");
        System.out.println("PEM: \n" + certificate);
        OCSPConfig config = ocspManager.getOCSPConfig(configType);
        Certificate cert = ArchiveLoader.loadChain(certificate.getBytes());
        CertificateInfo certificatePrincipal = cert.getCertificate();
        if (expected == null) {
            expected = CertificateStatusCode.GOOD;
        }
        System.out.println("****************");
        System.out.println("");
        System.out.println("Principal Certificate");
        System.out.println("Subject: " + certificatePrincipal.getSubject().toString());
        System.out.println("Issuer: " + certificatePrincipal.getIssuer().toString());
        System.out.println("CAIssuer: " + (certificatePrincipal.getAuthorityInformationAccess() != null ? certificatePrincipal.getAuthorityInformationAccess().getCAIssuers() : null));
        System.out.println("OCSP: " + (certificatePrincipal.getAuthorityInformationAccess() != null ? certificatePrincipal.getAuthorityInformationAccess().getOCSPs() : null));
        if (certificatePrincipal.getCRLDistributionPoints() != null && certificatePrincipal.getCRLDistributionPoints().getCRLDistributionPoints() != null && !certificatePrincipal.getCRLDistributionPoints().getCRLDistributionPoints().isEmpty()) {
            for (CRLDistributionPoint point : certificatePrincipal.getCRLDistributionPoints().getCRLDistributionPoints()) {
                System.out.println("CRLIssuer: " + point.getCRLIssuers());
                System.out.println("CRL: " + point.getDistributionPointNames());
            }
        } else {
            System.out.println("CRL: null");
        }
        LoggerBuffer lb = new LoggerBuffer();
        lb.setLogDebug(log);
        lb.setLogError(log);
        StringBuilder sbLog = new StringBuilder();
        lb.setSbDebug(sbLog);
        lb.setLogErrorInDebug(true);
        lb.addSeverityPrefix(true);
        OCSPRequestParams params = OCSPRequestParams.build(lb, cert.getCertificate().getCertificate(), trustStore, config, (IOCSPResourceReader)ocspResourceReader);
        CertificateStatus certificatePrincipalStatus = OCSPValidator.check(lb, params, crlInput);
        System.out.println(sbLog.toString());
        System.out.println("Stato: " + certificatePrincipalStatus);
        if (!expected.equals(certificatePrincipalStatus.getCode())) {
            throw new Exception("Atteso stato '" + expected + "'");
        }
        if (certificatePrincipalStatus.isREVOKED()) {
            if (certificatePrincipalStatus.getRevocationTime() == null) {
                throw new Exception("Atteso revocation time");
            }
            if (certificatePrincipalStatus.getRevocationReason() == null) {
                throw new Exception("Atteso revocation reason");
            }
        }
        if (certificatePrincipalStatus.isEXPIRED()) {
            if (certificatePrincipalStatus.getRevocationTime() == null) {
                throw new Exception("Atteso revocation time");
            }
            if (certificatePrincipalStatus.getDetails() == null) {
                throw new Exception("Atteso details");
            }
        }
        System.out.println("");
        System.out.println("Certificate Chain: " + (cert.getCertificateChain() != null ? cert.getCertificateChain().size() : 0));
        int index = 1;
        for (CertificateInfo c : cert.getCertificateChain()) {
            System.out.println("****************");
            System.out.println("");
            System.out.println("Certificate Chain '" + index + "'");
            System.out.println("Subject: " + c.getSubject().toString());
            System.out.println("Issuer: " + c.getIssuer().toString());
            System.out.println("CAIssuer: " + (c.getAuthorityInformationAccess() != null ? c.getAuthorityInformationAccess().getCAIssuers() : null));
            System.out.println("OCSP: " + (c.getAuthorityInformationAccess() != null ? c.getAuthorityInformationAccess().getOCSPs() : null));
            if (c.getCRLDistributionPoints() != null && c.getCRLDistributionPoints().getCRLDistributionPoints() != null && !c.getCRLDistributionPoints().getCRLDistributionPoints().isEmpty()) {
                for (CRLDistributionPoint point : c.getCRLDistributionPoints().getCRLDistributionPoints()) {
                    System.out.println("CRLIssuer: " + point.getCRLIssuers());
                    System.out.println("CRL: " + point.getDistributionPointNames());
                }
            } else {
                System.out.println("CRL: null");
            }
            params = OCSPRequestParams.build(lb, c.getCertificate(), trustStore, config, (IOCSPResourceReader)ocspResourceReader);
            certificatePrincipalStatus = OCSPValidator.check(lb, params, crlInput);
            System.out.println(sbLog.toString());
            System.out.println("Stato: " + certificatePrincipalStatus);
            if (!expected.equals(certificatePrincipalStatus.getCode())) {
                throw new Exception("Atteso stato '" + expected + "'");
            }
            ++index;
        }
    }
}

