/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.certificate.remote;

import java.io.ByteArrayOutputStream;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.certificate.ArchiveLoader;
import org.openspcoop2.utils.certificate.Certificate;
import org.openspcoop2.utils.certificate.JWK;
import org.openspcoop2.utils.certificate.KeyUtils;
import org.openspcoop2.utils.certificate.remote.RemoteKeyType;
import org.openspcoop2.utils.certificate.remote.RemoteStoreConfig;
import org.openspcoop2.utils.json.JsonPathExpressionEngine;
import org.openspcoop2.utils.resources.Charset;
import org.openspcoop2.utils.transport.TransportUtils;
import org.openspcoop2.utils.transport.http.ExternalResourceUtils;
import org.openspcoop2.utils.transport.http.HttpResponse;

public class RemoteStoreUtils {
    private RemoteStoreUtils() {
    }

    public static JWK readJWK(String keyId, RemoteStoreConfig remoteConfig) throws UtilsException {
        return (JWK)RemoteStoreUtils.readResource(keyId, remoteConfig, RemoteKeyType.JWK, null);
    }

    public static JWK readJWK(String keyId, RemoteStoreConfig remoteConfig, ByteArrayOutputStream bout) throws UtilsException {
        return (JWK)RemoteStoreUtils.readResource(keyId, remoteConfig, RemoteKeyType.JWK, bout);
    }

    public static Certificate readX509(String keyId, RemoteStoreConfig remoteConfig) throws UtilsException {
        return (Certificate)RemoteStoreUtils.readResource(keyId, remoteConfig, RemoteKeyType.X509, null);
    }

    public static Certificate readX509(String keyId, RemoteStoreConfig remoteConfig, ByteArrayOutputStream bout) throws UtilsException {
        return (Certificate)RemoteStoreUtils.readResource(keyId, remoteConfig, RemoteKeyType.X509, bout);
    }

    public static PublicKey readPublicKey(String keyId, RemoteStoreConfig remoteConfig) throws UtilsException {
        return (PublicKey)RemoteStoreUtils.readResource(keyId, remoteConfig, RemoteKeyType.PUBLIC_KEY, null);
    }

    public static PublicKey readPublicKey(String keyId, RemoteStoreConfig remoteConfig, ByteArrayOutputStream bout) throws UtilsException {
        return (PublicKey)RemoteStoreUtils.readResource(keyId, remoteConfig, RemoteKeyType.PUBLIC_KEY, bout);
    }

    private static Object readResource(String keyId, RemoteStoreConfig remoteConfig, RemoteKeyType keyType, ByteArrayOutputStream bout) throws UtilsException {
        try {
            RemoteStoreUtils.checkParams(keyId, remoteConfig, keyType);
            StringBuilder jsonPathResponseHolder = new StringBuilder();
            byte[] resource = RemoteStoreUtils.invoke(remoteConfig, keyId, jsonPathResponseHolder);
            if (jsonPathResponseHolder.length() > 0) {
                resource = RemoteStoreUtils.extractResourceByJsonPath(resource, jsonPathResponseHolder.toString());
            }
            if (bout != null) {
                bout.write(resource);
            }
            switch (keyType) {
                case JWK: {
                    return new JWK(new String(resource));
                }
                case X509: {
                    return ArchiveLoader.load(resource);
                }
                case PUBLIC_KEY: {
                    if (remoteConfig.getKeyAlgorithm() == null) {
                        throw new UtilsException("Key algorithm undefined");
                    }
                    return KeyUtils.getInstance(remoteConfig.getKeyAlgorithm()).getPublicKey(resource);
                }
            }
            throw new UtilsException("Key unknown");
        }
        catch (Exception t) {
            throw new UtilsException("Retrieve remote key '" + keyId + "' failed: " + t.getMessage(), t);
        }
    }

    private static byte[] invoke(RemoteStoreConfig remoteConfig, String keyId, StringBuilder jsonPathResponseHolder) throws UtilsException {
        String jsonPathResponse = null;
        byte[] resource = null;
        boolean invokeFaultUrl = false;
        try {
            ArrayList<Integer> returnCodeHolder = new ArrayList<Integer>();
            resource = RemoteStoreUtils.invoke(remoteConfig, remoteConfig.getBaseUrl(), keyId, returnCodeHolder);
            jsonPathResponse = remoteConfig.getResponseJsonPath();
            if (!(remoteConfig.getBaseUrlFaultCheck() == null || returnCodeHolder.isEmpty() || returnCodeHolder.get(0) == null || (Integer)returnCodeHolder.get(0) >= 200 && (Integer)returnCodeHolder.get(0) <= 299)) {
                invokeFaultUrl = true;
            }
        }
        catch (Exception e) {
            if (remoteConfig.getBaseUrlFaultCheck() != null) {
                invokeFaultUrl = true;
            }
            throw e;
        }
        if (invokeFaultUrl) {
            try {
                resource = RemoteStoreUtils.invoke(remoteConfig, remoteConfig.getBaseUrlFaultCheck(), keyId, null);
                jsonPathResponse = remoteConfig.getResponseJsonPathFaultCheck();
            }
            catch (Exception eFaultCheck) {
                throw new UtilsException(eFaultCheck.getMessage(), eFaultCheck);
            }
        }
        if (jsonPathResponse != null) {
            jsonPathResponseHolder.append(jsonPathResponse);
        }
        return resource;
    }

    private static byte[] invoke(RemoteStoreConfig remoteConfig, String url, String keyId, List<Integer> returnCodeHolder) throws UtilsException {
        switch (remoteConfig.getIdMode()) {
            case URL_SUFFIX: {
                if (!remoteConfig.getBaseUrl().endsWith("/")) {
                    url = (String)url + "/";
                }
                url = (String)url + TransportUtils.urlEncodePath(keyId, Charset.UTF_8.getValue());
                break;
            }
            case URL_PARAMETER: {
                remoteConfig.setQueryParameters(new HashMap<String, String>());
                remoteConfig.getQueryParameters().put(remoteConfig.getParameterName(), TransportUtils.urlEncodeParam(keyId, Charset.UTF_8.getValue()));
                break;
            }
            case HEADER: {
                remoteConfig.setHeaders(new HashMap<String, String>());
                remoteConfig.getHeaders().put(remoteConfig.getParameterName(), keyId);
                break;
            }
        }
        HttpResponse response = ExternalResourceUtils.readResourceReturnHttpResponse((String)url, remoteConfig);
        if (response == null) {
            throw new UtilsException("Empty response?");
        }
        byte[] resource = response.getContent();
        if (resource == null || resource.length <= 0) {
            throw new UtilsException("Retrieved empty key?");
        }
        if (returnCodeHolder != null) {
            returnCodeHolder.add(response.getResultHTTPOperation());
        }
        return resource;
    }

    private static byte[] extractResourceByJsonPath(byte[] resource, String jsonPath) throws UtilsException {
        String s = new String(resource);
        try {
            return JsonPathExpressionEngine.extractAndConvertResultAsString(s, jsonPath, LoggerWrapperFactory.getLogger(RemoteStoreUtils.class)).getBytes();
        }
        catch (Exception e) {
            throw new UtilsException("Estrazione tramite pattern '" + jsonPath + "' dalla risorsa '" + s + "' non riuscita: " + e.getMessage(), e);
        }
    }

    private static void checkParams(String keyId, RemoteStoreConfig remoteConfig, RemoteKeyType keyType) throws UtilsException {
        if (keyId == null) {
            throw new UtilsException("KeyId undefined");
        }
        if (remoteConfig == null) {
            throw new UtilsException("Config undefined");
        }
        if (keyType == null) {
            throw new UtilsException("KeyType undefined");
        }
        if (remoteConfig.getBaseUrl() == null || StringUtils.isEmpty((String)remoteConfig.getBaseUrl())) {
            throw new UtilsException("BaseUrl undefined");
        }
        if (remoteConfig.getIdMode() == null) {
            throw new UtilsException("KeyId mode undefined");
        }
    }
}

