/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.datasource;

import java.io.PrintWriter;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Wrapper;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeoutException;
import org.openspcoop2.utils.TipiDatabase;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.datasource.Connection;
import org.openspcoop2.utils.datasource.InformazioniDatabaseChecker;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.date.DateUtils;
import org.openspcoop2.utils.id.UUIDUtilsGenerator;
import org.openspcoop2.utils.jdbc.JDBCUtilities;
import org.slf4j.Logger;

public class DataSource
implements javax.sql.DataSource,
Wrapper {
    static Logger checkLogger = null;
    static boolean checkIsClosed = true;
    static boolean checkAutocommit = true;
    private javax.sql.DataSource wrappedDatasource;
    private TipiDatabase tipoDatabase;
    private boolean wrapOriginalMethods;
    private String uuidDatasource;
    private String applicativeIdDatasource;
    private Date date = null;
    private int transactionIsolationLevelDefault;
    private String jndiName;
    private boolean closed = false;
    private Map<String, Connection> releasedConnections = new ConcurrentHashMap<String, Connection>();

    public static boolean isCheckIsClosed() {
        return checkIsClosed;
    }

    public static void setCheckIsClosed(boolean checkIsClosed) {
        DataSource.checkIsClosed = checkIsClosed;
    }

    public static boolean isCheckAutocommit() {
        return checkAutocommit;
    }

    public static void setCheckAutocommit(boolean checkAutocommit) {
        DataSource.checkAutocommit = checkAutocommit;
    }

    public static Logger getCheckLogger() {
        return checkLogger;
    }

    public static void setCheckLogger(Logger checkLogger) {
        DataSource.checkLogger = checkLogger;
    }

    public String[] getJmxStatus() {
        String[] sNull = null;
        if (this.releasedConnections == null || this.releasedConnections.size() <= 0) {
            return sNull;
        }
        Connection[] list = this.releasedConnections.values().toArray(new Connection[1]);
        ArrayList<String> listResource = new ArrayList<String>();
        for (int i = 0; i < list.length; ++i) {
            Connection connection = list[i];
            StringBuilder bf = new StringBuilder();
            SimpleDateFormat dateformat = DateUtils.getSimpleDateFormatMs();
            bf.append("(").append(dateformat.format(connection.getDate())).append(") ");
            if (connection.getIdTransazione() != null) {
                if (bf.length() > 0) {
                    bf.append(" ");
                }
                bf.append("idTransazione:");
                bf.append(connection.getIdTransazione());
            }
            if (connection.getModuloFunzionale() instanceof String) {
                if (bf.length() > 0) {
                    bf.append(" ");
                }
                bf.append("moduloFunzionale:");
                bf.append(connection.getModuloFunzionale());
            }
            listResource.add(bf.toString());
        }
        if (!listResource.isEmpty()) {
            Collections.sort(listResource);
            return listResource.toArray(new String[1]);
        }
        return sNull;
    }

    public String getInformazioniDatabase() throws TimeoutException, UtilsException {
        InformazioniDatabaseChecker versioneBaseDatiChecker = new InformazioniDatabaseChecker(this);
        return (String)Utilities.execute(5, versioneBaseDatiChecker);
    }

    protected DataSource(javax.sql.DataSource datasource, TipiDatabase tipoDatabase, boolean wrapOriginalMethods, String jndiName, String applicativeIdDatasource) throws SQLException {
        try {
            this.wrappedDatasource = datasource;
            this.tipoDatabase = tipoDatabase;
            this.wrapOriginalMethods = wrapOriginalMethods;
            this.uuidDatasource = UUIDUtilsGenerator.newUUID();
            this.jndiName = jndiName;
            this.applicativeIdDatasource = applicativeIdDatasource;
            this.date = DateManager.getDate();
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage(), e);
        }
        java.sql.Connection connectionTest = null;
        try {
            connectionTest = this.wrappedDatasource.getConnection();
            this.transactionIsolationLevelDefault = connectionTest.getTransactionIsolation();
        }
        catch (Exception e) {
            throw new SQLException("Test getConnection failed: " + e.getMessage(), e);
        }
        finally {
            if (connectionTest != null) {
                JDBCUtilities.closeConnection(checkLogger, connectionTest, checkAutocommit, checkIsClosed);
            }
        }
    }

    public String getUuidDatasource() {
        return this.uuidDatasource;
    }

    public String getApplicativeIdDatasource() {
        return this.applicativeIdDatasource;
    }

    public int size() {
        return this.releasedConnections.size();
    }

    public int getTransactionIsolationLevelDefault() {
        return this.transactionIsolationLevelDefault;
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public Date getDate() {
        return this.date;
    }

    public TipiDatabase getTipoDatabase() {
        return this.tipoDatabase;
    }

    boolean isClosed() {
        return this.closed;
    }

    void setClosed(boolean closed) {
        this.closed = closed;
    }

    void releaseConnnections() {
        Collection<Connection> list = this.releasedConnections.values();
        for (Connection connection : list) {
            try {
                connection.close();
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public java.sql.Connection getConnection() throws SQLException {
        if (this.wrapOriginalMethods) {
            return this.getWrappedConnection(null, null);
        }
        throw new SQLException("Not Supported, use getWrappedConnection");
    }

    @Override
    public java.sql.Connection getConnection(String idTransazione, String moduloFunzionale) throws SQLException {
        if (this.wrapOriginalMethods) {
            return this.getWrappedConnection(idTransazione, moduloFunzionale);
        }
        throw new SQLException("Not Supported, use getWrappedConnection");
    }

    public Connection getWrappedConnection() throws SQLException {
        return this.getWrappedConnection(null, null);
    }

    public Connection getWrappedConnection(String idTransazione) throws SQLException {
        return this.getWrappedConnection(idTransazione, null);
    }

    public Connection getWrappedConnection(String idTransazione, Object moduloFunzionale) throws SQLException {
        if (this.closed) {
            throw new SQLException("Shutdown in progress");
        }
        try {
            Connection c = new Connection(this.wrappedDatasource.getConnection(), this.tipoDatabase, idTransazione, moduloFunzionale, this.uuidDatasource);
            this.releasedConnections.put(c.getId(), c);
            return c;
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage(), e);
        }
    }

    protected void unregisterConnection(Connection connection) throws SQLException {
        if (this.releasedConnections.containsKey(connection.getId())) {
            this.releasedConnections.remove(connection.getId()).closeWrappedConnection();
        }
    }

    public void closeConnection(Connection connection) throws SQLException {
        if (connection == null) {
            throw new SQLException("Parameter undefined");
        }
        connection.close();
    }

    public void closeConnection(java.sql.Connection connection) throws SQLException {
        if (connection == null) {
            throw new SQLException("Parameter undefined");
        }
        if (!(connection instanceof Connection)) {
            throw new SQLException("Connection type unsupported, expected:" + Connection.class + " found:" + connection.getClass().getName());
        }
        ((Connection)connection).close();
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.wrappedDatasource.getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter pw) throws SQLException {
        this.wrappedDatasource.setLogWriter(pw);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.wrappedDatasource.getLoginTimeout();
    }

    @Override
    public void setLoginTimeout(int timeout) throws SQLException {
        this.wrappedDatasource.setLoginTimeout(timeout);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (this.wrappedDatasource instanceof Wrapper) {
            return this.wrappedDatasource.unwrap(iface);
        }
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        if (this.wrappedDatasource instanceof Wrapper) {
            return this.wrappedDatasource.isWrapperFor(iface);
        }
        return false;
    }

    @Override
    public java.util.logging.Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return this.wrappedDatasource.getParentLogger();
    }
}

