/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.datasource.test;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.datasource.Connection;
import org.openspcoop2.utils.datasource.DataSource;
import org.openspcoop2.utils.datasource.DataSourceFactory;
import org.openspcoop2.utils.datasource.test.ExampleServletInitListener;
import org.openspcoop2.utils.id.IDUtilities;
import org.openspcoop2.utils.id.UUIDUtilsGenerator;
import org.slf4j.Logger;

public class ExampleService
extends HttpServlet {
    private static Logger log = LoggerWrapperFactory.getLogger(ExampleService.class);
    private static final long serialVersionUID = 1L;

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        try {
            this.doGet(req, res);
        }
        catch (Exception e) {
            try {
                res.sendError(500, e.getMessage());
            }
            catch (Exception eSendError) {
                log.error(eSendError.getMessage(), (Throwable)eSendError);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        if (!ExampleServletInitListener.isInitialized()) {
            try {
                res.sendError(500, "Applicazione non inizializzata");
                return;
            }
            catch (Exception eSendError) {
                log.error(eSendError.getMessage(), (Throwable)eSendError);
            }
        }
        Object prefix = "";
        try {
            boolean useUUID = false;
            boolean useApplicativeID = false;
            if (req.getParameter("useUUID") != null) {
                useUUID = Boolean.parseBoolean(req.getParameter("useUUID").trim());
            } else if (req.getParameter("useApplicativeID") != null) {
                useApplicativeID = Boolean.parseBoolean(req.getParameter("useApplicativeID").trim());
            }
            String idTransazione = UUIDUtilsGenerator.newUUID();
            prefix = "[" + idTransazione + "] ";
            System.out.println((String)prefix + "Ricevuta richiesta ...");
            DataSource dsConfig = null;
            String idDsConfig = null;
            idDsConfig = useUUID ? ExampleServletInitListener.UUID_CONFIGURAZIONE : (useApplicativeID ? "Esempio2ConfigurazioneProdotto" : ExampleServletInitListener.JNDI_NAME_CONFIGURAZIONE);
            System.out.println((String)prefix + "Recupero datasource configurazione [" + idDsConfig + "] ...");
            dsConfig = DataSourceFactory.getInstance(idDsConfig);
            System.out.println((String)prefix + "Recuperato datasource configurazione [" + idDsConfig + "]");
            DataSource dsRuntime = null;
            String idDsRuntime = null;
            idDsRuntime = useUUID ? ExampleServletInitListener.UUID_RUNTIME : (useApplicativeID ? "Esempio1RuntimeProdotto" : ExampleServletInitListener.JNDI_NAME_RUNTIME);
            System.out.println((String)prefix + "Recupero datasource runtime [" + idDsRuntime + "] ...");
            dsRuntime = DataSourceFactory.getInstance(idDsRuntime);
            System.out.println((String)prefix + "Recuperato datasource runtime [" + idDsRuntime + "]");
            Connection conConfigInit = null;
            Connection conConfig1 = null;
            Connection conConfig2 = null;
            java.sql.Connection conRuntime1 = null;
            java.sql.Connection conRuntime2 = null;
            try {
                conConfigInit = dsConfig.getWrappedConnection();
                conConfig1 = dsConfig.getWrappedConnection(idTransazione);
                conConfig2 = dsConfig.getWrappedConnection(idTransazione, IDUtilities.generateAlphaNumericRandomString(10));
                System.out.println((String)prefix + "Recuperate connessioni dalla configurazione, sleep 10s ...");
                Utilities.sleep(10000L);
                conRuntime1 = dsRuntime.getConnection();
                conRuntime2 = dsRuntime.getConnection(idTransazione, IDUtilities.generateAlphaNumericRandomString(10));
                System.out.println((String)prefix + "Recuperate connessioni dalla runtime, sleep 20s ...");
                Utilities.sleep(20000L);
            }
            finally {
                try {
                    if (conConfigInit != null) {
                        conConfigInit.close();
                    }
                }
                catch (Exception eClose) {
                    System.err.println((String)prefix + "Rilascio connessione configInit non riuscito: " + eClose.getMessage());
                    eClose.printStackTrace(System.err);
                }
                try {
                    if (conConfig1 != null) {
                        conConfig1.close();
                    }
                }
                catch (Exception eClose) {
                    System.err.println((String)prefix + "Rilascio connessione config1 non riuscito: " + eClose.getMessage());
                    eClose.printStackTrace(System.err);
                }
                try {
                    if (conConfig2 != null) {
                        conConfig2.close();
                    }
                }
                catch (Exception eClose) {
                    System.err.println((String)prefix + "Rilascio connessione config2 non riuscito: " + eClose.getMessage());
                    eClose.printStackTrace(System.err);
                }
                try {
                    if (conRuntime1 != null) {
                        conRuntime1.close();
                    }
                }
                catch (Exception eClose) {
                    System.err.println((String)prefix + "Rilascio connessione runtime1 non riuscito: " + eClose.getMessage());
                    eClose.printStackTrace(System.err);
                }
                try {
                    if (conRuntime2 != null) {
                        conRuntime2.close();
                    }
                }
                catch (Exception eClose) {
                    System.err.println((String)prefix + "Rilascio connessione runtime2 non riuscito: " + eClose.getMessage());
                    eClose.printStackTrace(System.err);
                }
            }
            System.out.println((String)prefix + "Terminata attivita");
        }
        catch (Exception e) {
            System.err.println((String)prefix + "Errore: " + e.getMessage());
            e.printStackTrace(System.err);
        }
    }
}

