/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.date.test;

import java.text.SimpleDateFormat;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.openspcoop2.utils.date.DateManager;

class TestDate
extends Thread {
    private int n;
    private String formato;
    private boolean dateTime;
    private boolean jodaTime;
    private boolean convert;
    private volatile boolean finished = false;

    public boolean isFinished() {
        return this.finished;
    }

    public TestDate(int n, String formato, boolean dateTime, boolean jodaTime, boolean convert) {
        this.n = n;
        this.formato = formato;
        this.dateTime = dateTime;
        this.jodaTime = jodaTime;
        this.convert = convert;
    }

    @Override
    public void run() {
        if (this.dateTime && !this.convert) {
            java.time.format.DateTimeFormatter dateTimeFormatter = java.time.format.DateTimeFormatter.ofPattern(this.formato);
            for (int i = 0; i < this.n; ++i) {
                dateTimeFormatter.format(ZonedDateTime.now());
            }
        } else if (this.dateTime && this.convert) {
            java.time.format.DateTimeFormatter dateTimeFormatter = java.time.format.DateTimeFormatter.ofPattern(this.formato);
            ZoneId zoneId = ZoneId.systemDefault();
            for (int i = 0; i < this.n; ++i) {
                dateTimeFormatter.format(DateManager.getDate().toInstant().atZone(zoneId));
            }
        } else if (this.jodaTime && !this.convert) {
            String formatoJoda = this.formato.endsWith("X") ? this.formato.substring(0, this.formato.length() - 1) + "Z" : this.formato;
            DateTimeFormatter jodaDateTimeFormatter = DateTimeFormat.forPattern((String)formatoJoda);
            for (int i = 0; i < this.n; ++i) {
                DateTime.now().toString(jodaDateTimeFormatter);
            }
        } else if (this.jodaTime && this.convert) {
            String formatoJoda = this.formato.endsWith("X") ? this.formato.substring(0, this.formato.length() - 1) + "Z" : this.formato;
            DateTimeFormatter jodaDateTimeFormatter = DateTimeFormat.forPattern((String)formatoJoda);
            for (int i = 0; i < this.n; ++i) {
                new DateTime((Object)DateManager.getDate()).toString(jodaDateTimeFormatter);
            }
        } else {
            for (int i = 0; i < this.n; ++i) {
                new SimpleDateFormat(this.formato).format(DateManager.getDate());
            }
        }
        this.finished = true;
    }
}

