/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.id.apache.serial;

import org.openspcoop2.utils.id.apache.serial.MaxReachedException;
import org.openspcoop2.utils.id.apache.serial.NumericGenerator;

public class PrefixedNumericGenerator
extends NumericGenerator {
    private static final long serialVersionUID = 1L;
    private final String prefix;

    public PrefixedNumericGenerator(String prefix, boolean wrap, long initialValue) {
        super(wrap, initialValue);
        if (prefix == null) {
            throw new NullPointerException("prefix must not be null");
        }
        this.prefix = prefix;
    }

    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public long maxLength() {
        return super.maxLength() + (long)this.prefix.length();
    }

    @Override
    public long minLength() {
        return super.minLength() + (long)this.prefix.length();
    }

    @Override
    public String nextStringIdentifier() throws MaxReachedException {
        StringBuilder sb = new StringBuilder(this.prefix);
        sb.append(super.nextStringIdentifier());
        return sb.toString();
    }
}

