/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.id.serial.test;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import org.openspcoop2.utils.TipiDatabase;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.id.serial.IDSerialGenerator;
import org.openspcoop2.utils.id.serial.IDSerialGeneratorParameter;
import org.openspcoop2.utils.id.serial.test.ClientTest;
import org.openspcoop2.utils.regexp.RegularExpressionEngine;

class ClientTestThread
implements Runnable {
    private static List<String> check = new ArrayList<String>();
    private static volatile boolean valoriDuplicati = false;
    private IDSerialGenerator serialGenerator;
    private IDSerialGeneratorParameter param;
    private Connection con;
    private boolean isNumber;
    private List<String> valoriGenerati;
    private int index;
    private boolean debug;
    private TipiDatabase tipoDatabase;
    private volatile boolean finished = false;
    private volatile boolean error = false;

    private static synchronized void put(String v, boolean rilevaValoriDuplicati) throws Exception {
        if (!check.contains(v)) {
            check.add(v);
        } else {
            if (rilevaValoriDuplicati) {
                throw new Exception("Valore [" + v + "] gia generato");
            }
            valoriDuplicati = true;
        }
    }

    public static List<String> getValoriDistintiGenerati() {
        return check;
    }

    public static void reset() {
        check.clear();
        valoriDuplicati = false;
    }

    public static int count() {
        return check.size();
    }

    public static boolean isValoriDuplicati() {
        return valoriDuplicati;
    }

    public List<String> getValoriGenerati() {
        return this.valoriGenerati;
    }

    public boolean isError() {
        return this.error;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public ClientTestThread(IDSerialGenerator serialGenerator, IDSerialGeneratorParameter param, Connection con, boolean isNumber, int index, boolean debug, TipiDatabase tipoDatabase) {
        this.serialGenerator = serialGenerator;
        this.param = param;
        this.con = con;
        this.isNumber = isNumber;
        this.valoriGenerati = new ArrayList<String>();
        this.index = index;
        this.debug = debug;
        this.tipoDatabase = tipoDatabase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            Object v = null;
            int i = 0;
            boolean rilevaValoriDuplicati = false;
            if (!this.param.isWrap()) {
                rilevaValoriDuplicati = true;
            }
            while (i < ClientTest.ID_GENERATI_PER_THREAD) {
                if (this.debug && i % 10 == 0) {
                    ClientTest.log.info("[Thread-" + this.index + "] Generati " + i + " ids");
                }
                v = null;
                if (this.isNumber) {
                    long l = this.serialGenerator.buildIDAsNumber(this.param, this.con, this.tipoDatabase, ClientTest.log);
                    v = "" + l;
                } else {
                    v = this.serialGenerator.buildID(this.param, this.con, this.tipoDatabase, ClientTest.log);
                    if (!RegularExpressionEngine.isMatch((String)v, "^[a-zA-Z0-9]*$")) {
                        throw new UtilsException("Deve essere fornito [a-zA-Z0-9] trovato [" + (String)v + "]");
                    }
                }
                this.valoriGenerati.add((String)v);
                ClientTestThread.put((String)v, rilevaValoriDuplicati);
                ++i;
            }
        }
        catch (Exception e) {
            this.error = true;
        }
        finally {
            this.finished = true;
        }
    }
}

