/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.io.notifier.unblocked;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.openspcoop2.utils.Semaphore;
import org.openspcoop2.utils.SemaphoreLock;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.io.notifier.unblocked.IPipedUnblockedStream;
import org.slf4j.Logger;

public class PipedUnblockedStream
extends IPipedUnblockedStream {
    protected Logger log = null;
    private long sizeBuffer;
    private int timeoutMs;
    private final Semaphore lockPIPE = new Semaphore("PipedUnblockedStream");
    private ByteArrayOutputStream bout = new ByteArrayOutputStream();
    private byte[] bytesReceived = null;
    private int indexNextByteReceivedForRead = -1;
    private boolean stop = false;
    private boolean useThreadSleep = false;
    private static final int ITERAZIONI_WAIT = 128;
    private CompletableFuture<Boolean> asyncReadTask = null;
    private CompletableFuture<Boolean> asyncWriteTask = null;
    private String source = null;

    @Override
    public void init(Logger log, long sizeBuffer, int timeoutMs, String source) {
        this.log = log;
        if (sizeBuffer <= 0L) {
            sizeBuffer = 65536L;
        }
        this.sizeBuffer = sizeBuffer / 2L;
        this.timeoutMs = timeoutMs;
        this.source = source;
    }

    @Override
    public void setTimeout(int timeoutMs) {
        this.timeoutMs = timeoutMs;
    }

    public String getPrefixSource() {
        return this.source != null ? "[" + this.source + "] " : "";
    }

    private void readWaitBytes() throws IOException {
        block16: {
            try {
                if (this.useThreadSleep) {
                    int i;
                    for (i = 0; !this.stop && this.bout != null && this.bout.size() == 0 && i < 128; i += i) {
                        Utilities.sleep(i + 1);
                    }
                    if (i >= 128) {
                        throw new IOException(this.getPrefixSource() + "Timeout, no bytes available for read");
                    }
                    break block16;
                }
                boolean wait = false;
                SemaphoreLock lock = this.lockPIPE.acquireThrowRuntime("readWaitBytes");
                try {
                    if (!this.stop && this.bout != null && this.bout.size() == 0) {
                        this.asyncReadTask = new CompletableFuture();
                        wait = true;
                    }
                }
                finally {
                    this.lockPIPE.release(lock, "readWaitBytes");
                }
                if (!wait) break block16;
                try {
                    if (this.timeoutMs > 0) {
                        this.asyncReadTask.get(this.timeoutMs, TimeUnit.MILLISECONDS);
                    } else {
                        this.asyncReadTask.get();
                    }
                }
                catch (InterruptedException timeout) {
                    Thread.currentThread().interrupt();
                    throw new IOException(this.getPrefixSource() + "Timeout, no bytes available for read: " + timeout.getMessage(), timeout);
                }
                catch (Exception timeout) {
                    throw new IOException(this.getPrefixSource() + "Timeout, no bytes available for read: " + timeout.getMessage(), timeout);
                }
            }
            catch (IOException io) {
                throw io;
            }
            catch (Throwable t) {
                if (t != null && t instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                throw new IOException(t.getMessage(), t);
            }
        }
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        try {
            int bytesAvailableForRead;
            if (this.bytesReceived == null) {
                if (this.stop) {
                    if (this.bout == null) {
                        if (this.asyncWriteTask != null) {
                            this.asyncWriteTask.complete(true);
                        }
                        return -1;
                    }
                    if (this.bout.size() <= 0) {
                        this.bout.close();
                        this.bout = null;
                        if (this.asyncWriteTask != null) {
                            this.asyncWriteTask.complete(true);
                        }
                        return -1;
                    }
                } else if (this.bout.size() == 0) {
                    this.readWaitBytes();
                    if (this.bout == null) {
                        if (this.asyncWriteTask != null) {
                            this.asyncWriteTask.complete(true);
                        }
                        return -1;
                    }
                }
            }
            if (this.bytesReceived == null && this.stop && this.bout.size() <= 0) {
                this.bout.close();
                this.bout = null;
                if (this.asyncWriteTask != null) {
                    this.asyncWriteTask.complete(true);
                }
                return -1;
            }
            if (this.bytesReceived == null) {
                SemaphoreLock lock = this.lockPIPE.acquireThrowRuntime("read");
                try {
                    this.bout.flush();
                    this.bytesReceived = this.bout.toByteArray();
                    this.indexNextByteReceivedForRead = 0;
                    this.bout.reset();
                    if (this.asyncWriteTask != null) {
                        this.asyncWriteTask.complete(true);
                    }
                }
                finally {
                    this.lockPIPE.release(lock, "read");
                }
            }
            if ((bytesAvailableForRead = this.bytesReceived.length - this.indexNextByteReceivedForRead) == len) {
                for (int i = 0; i < len; ++i) {
                    b[off + i] = this.bytesReceived[this.indexNextByteReceivedForRead];
                    ++this.indexNextByteReceivedForRead;
                }
                this.bytesReceived = null;
                this.indexNextByteReceivedForRead = -1;
                return len;
            }
            if (bytesAvailableForRead > len) {
                int i = 0;
                for (i = 0; i < len; ++i) {
                    b[off + i] = this.bytesReceived[this.indexNextByteReceivedForRead];
                    ++this.indexNextByteReceivedForRead;
                }
                return len;
            }
            for (int i = 0; i < bytesAvailableForRead; ++i) {
                b[off + i] = this.bytesReceived[this.indexNextByteReceivedForRead];
                ++this.indexNextByteReceivedForRead;
            }
            this.bytesReceived = null;
            this.indexNextByteReceivedForRead = -1;
            return bytesAvailableForRead;
        }
        catch (IOException io) {
            throw io;
        }
        catch (Throwable t) {
            throw new IOException(t.getMessage(), t);
        }
    }

    @Override
    public int read() throws IOException {
        byte[] b = new byte[1];
        int len = this.read(b);
        if (len == 1) {
            return b[0] & 0xFF;
        }
        if (len == -1) {
            return -1;
        }
        throw new IOException("Cannot read single byte");
    }

    @Override
    public void close() throws IOException {
        try {
            SemaphoreLock lock = this.lockPIPE.acquireThrowRuntime("close");
            try {
                if (!this.stop) {
                    if (this.bout.size() <= 0) {
                        this.bout.flush();
                        this.bout.close();
                    }
                    this.stop = true;
                }
            }
            finally {
                this.lockPIPE.release(lock, "close");
            }
            if (this.asyncWriteTask != null) {
                this.asyncWriteTask.complete(true);
            }
            if (this.asyncReadTask != null) {
                this.asyncReadTask.complete(true);
            }
        }
        catch (IOException io) {
            throw io;
        }
        catch (Throwable t) {
            throw new IOException(t.getMessage(), t);
        }
    }

    private void writeWaitEmptyBuffer() throws IOException {
        block17: {
            try {
                if (this.useThreadSleep) {
                    if ((long)this.bout.size() > this.sizeBuffer) {
                        int i;
                        for (i = 0; !this.stop && this.bout.size() > 0 && i < 128; i += i) {
                            Utilities.sleep(i + 1);
                        }
                        if (i >= 128) {
                            throw new IOException(this.getPrefixSource() + "Timeout, no buffer available for write");
                        }
                    }
                    break block17;
                }
                boolean wait = false;
                SemaphoreLock lock = this.lockPIPE.acquireThrowRuntime("writeWaitEmptyBuffer");
                try {
                    if ((long)this.bout.size() > this.sizeBuffer && !this.stop && this.bout.size() > 0) {
                        this.asyncWriteTask = new CompletableFuture();
                        wait = true;
                    }
                }
                finally {
                    this.lockPIPE.release(lock, "writeWaitEmptyBuffer");
                }
                if (!wait) break block17;
                try {
                    if (this.timeoutMs > 0) {
                        this.asyncWriteTask.get(this.timeoutMs, TimeUnit.MILLISECONDS);
                    } else {
                        this.asyncWriteTask.get();
                    }
                }
                catch (InterruptedException timeout) {
                    Thread.currentThread().interrupt();
                    throw new IOException(this.getPrefixSource() + "Timeout, no bytes available for read: " + timeout.getMessage(), timeout);
                }
                catch (Exception timeout) {
                    throw new IOException(this.getPrefixSource() + "Timeout, no bytes available for read: " + timeout.getMessage(), timeout);
                }
            }
            catch (IOException io) {
                throw io;
            }
            catch (Throwable t) {
                if (t != null && t instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                throw new IOException(t.getMessage(), t);
            }
        }
    }

    @Override
    public void write(byte b) throws IOException {
        try {
            if (this.bout == null) {
                throw new IOException(this.getPrefixSource() + "Stream already closed");
            }
            this.writeWaitEmptyBuffer();
            SemaphoreLock lock = this.lockPIPE.acquireThrowRuntime("write(b)");
            try {
                this.bout.write(b);
                if (this.asyncReadTask != null) {
                    this.asyncReadTask.complete(true);
                }
            }
            finally {
                this.lockPIPE.release(lock, "write(b)");
            }
        }
        catch (IOException io) {
            throw io;
        }
        catch (Throwable t) {
            throw new IOException(t.getMessage(), t);
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        try {
            if (this.bout == null) {
                throw new IOException(this.getPrefixSource() + "Stream already closed");
            }
            this.writeWaitEmptyBuffer();
            SemaphoreLock lock = this.lockPIPE.acquireThrowRuntime("write(b[])");
            try {
                this.bout.write(b);
                if (this.asyncReadTask != null) {
                    this.asyncReadTask.complete(true);
                }
            }
            finally {
                this.lockPIPE.release(lock, "write(b[])");
            }
        }
        catch (IOException io) {
            throw io;
        }
        catch (Throwable t) {
            throw new IOException(t.getMessage(), t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        try {
            if (this.bout == null) {
                throw new IOException(this.getPrefixSource() + "Stream already closed");
            }
            this.writeWaitEmptyBuffer();
            SemaphoreLock lock = this.lockPIPE.acquireThrowRuntime("write(b[],off,len)");
            try {
                this.bout.write(b, off, len);
                if (this.asyncReadTask != null) {
                    this.asyncReadTask.complete(true);
                }
            }
            finally {
                this.lockPIPE.release(lock, "write(b[],off,len)");
            }
        }
        catch (IOException io) {
            throw io;
        }
        catch (Throwable t) {
            throw new IOException(t.getMessage(), t);
        }
    }
}

