/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.io.notifier.unblocked;

import java.io.IOException;
import org.openspcoop2.utils.io.notifier.unblocked.IPipedUnblockedStream;
import org.openspcoop2.utils.io.notifier.unblocked.PipedBytesStream;
import org.openspcoop2.utils.io.notifier.unblocked.PipedUnblockedStream;
import org.openspcoop2.utils.resources.Loader;
import org.slf4j.Logger;

public class PipedUnblockedStreamFactory {
    private static boolean USE_PIPED_BYTES_STREAM_IMPL = true;
    private static boolean USE_PIPED_BYTE_ARRAY_OUTPUT_STREAM_IMPL = false;
    private static String CLASSNAME_IMPL = null;

    public static void setImplementation(String className) {
        if (PipedBytesStream.class.getName().equals(className)) {
            USE_PIPED_BYTES_STREAM_IMPL = true;
            USE_PIPED_BYTE_ARRAY_OUTPUT_STREAM_IMPL = false;
            CLASSNAME_IMPL = null;
        } else if (PipedUnblockedStream.class.getName().equals(className)) {
            USE_PIPED_BYTES_STREAM_IMPL = false;
            USE_PIPED_BYTE_ARRAY_OUTPUT_STREAM_IMPL = true;
            CLASSNAME_IMPL = null;
        } else {
            USE_PIPED_BYTES_STREAM_IMPL = false;
            USE_PIPED_BYTE_ARRAY_OUTPUT_STREAM_IMPL = false;
            CLASSNAME_IMPL = className;
        }
    }

    public static IPipedUnblockedStream newPipedUnblockedStream(Logger log, long sizeBuffer, int timeoutMs, String source) throws IOException {
        try {
            IPipedUnblockedStream pipe = null;
            pipe = USE_PIPED_BYTES_STREAM_IMPL ? new PipedBytesStream() : (USE_PIPED_BYTE_ARRAY_OUTPUT_STREAM_IMPL ? new PipedUnblockedStream() : (IPipedUnblockedStream)new Loader().newInstance(CLASSNAME_IMPL));
            ((IPipedUnblockedStream)pipe).init(log, sizeBuffer, timeoutMs, source);
            return pipe;
        }
        catch (Throwable t) {
            throw new IOException(t.getMessage(), t);
        }
    }
}

