/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.jaxrs;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Calendar;
import javax.ws.rs.ext.ParamConverter;
import javax.ws.rs.ext.ParamConverterProvider;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.jaxrs.JodaDateTimeConverter;
import org.openspcoop2.utils.jaxrs.JodaLocalDateConverter;

public class ParameterConverterProvider
implements ParamConverterProvider {
    private String timeZoneId = null;
    private DateTimeZone timeZone = null;

    public String getTimeZoneId() {
        return this.timeZoneId;
    }

    public void setTimeZoneId(String timeZoneId) {
        this.timeZoneId = timeZoneId;
    }

    private DateTimeZone getDateTimeZone() {
        if (this.timeZone == null) {
            this.initTimeZone();
        }
        return this.timeZone;
    }

    private synchronized void initTimeZone() {
        if (this.timeZone == null) {
            if (this.timeZoneId == null) {
                try {
                    Calendar c = DateManager.getCalendar();
                    this.setTimeZoneId(c.getTimeZone().getID());
                }
                catch (Exception e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            }
            this.timeZone = DateTimeZone.forID((String)this.timeZoneId);
        }
    }

    public <T> ParamConverter<T> getConverter(Class<T> type, Type type1, Annotation[] antns) {
        if (DateTime.class.equals(type)) {
            JodaDateTimeConverter paramConverter = new JodaDateTimeConverter(this.getDateTimeZone());
            return paramConverter;
        }
        if (LocalDate.class.equals(type)) {
            JodaLocalDateConverter paramConverter = new JodaLocalDateConverter(this.getDateTimeZone());
            return paramConverter;
        }
        return null;
    }
}

