/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.jdbc;

import org.openspcoop2.utils.TipiDatabase;
import org.openspcoop2.utils.jdbc.MySQLUtilities;
import org.openspcoop2.utils.jdbc.PostgreSQLUtilities;

public class NullByteTextColumnSanitizer {
    private NullByteTextColumnSanitizer() {
    }

    public static boolean needsSanitization(TipiDatabase tipoDatabase) {
        return TipiDatabase.POSTGRESQL.equals((Object)tipoDatabase) || TipiDatabase.MYSQL.equals((Object)tipoDatabase);
    }

    public static boolean needsSanitization(String tipoDatabase) {
        return TipiDatabase.POSTGRESQL.equals(tipoDatabase) || TipiDatabase.MYSQL.equals(tipoDatabase);
    }

    public static String sanitize(TipiDatabase tipoDatabase, String value) {
        if (tipoDatabase == null) {
            return value;
        }
        return NullByteTextColumnSanitizer.sanitize(tipoDatabase.toString(), value);
    }

    public static String sanitize(String tipoDatabase, String value) {
        if (value == null || tipoDatabase == null) {
            return value;
        }
        if (TipiDatabase.POSTGRESQL.equals(tipoDatabase) && PostgreSQLUtilities.containsNullByteSequence(value)) {
            return PostgreSQLUtilities.normalizeString(value);
        }
        if (TipiDatabase.MYSQL.equals(tipoDatabase) && MySQLUtilities.containsNullByteSequence(value)) {
            return MySQLUtilities.normalizeString(value);
        }
        return value;
    }
}

