/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.json.test;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.List;
import net.minidev.json.JSONObject;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.json.JSONUtils;
import org.openspcoop2.utils.json.JsonPathExpressionEngine;
import org.openspcoop2.utils.json.JsonPathReturnType;
import org.openspcoop2.utils.resources.FileSystemUtilities;

public class JsonPathTest {
    public static void main(String[] args) throws Exception {
        JsonPathExpressionEngine.disableCacheJsonPathEngine();
        System.out.println("\n\n************** ARRAY ************");
        JsonPathTest.testList();
        System.out.println("\n\n************** INSTANCE ************");
        JsonPathTest.testSingleInstance();
    }

    private static void testList() throws Exception {
        String name = "file.json";
        Object pattern = "$.store.book[*]";
        JsonPathExpressionEngine engine = new JsonPathExpressionEngine();
        JSONUtils jsonUtils = JSONUtils.getInstance();
        InputStream is = JsonPathTest.class.getResourceAsStream(name);
        JSONObject object = JsonPathExpressionEngine.getJSONObject(is);
        Object obj = engine.getJsonNodeMatchPattern(object, (String)pattern);
        System.out.println("JsonObject->Nodo:" + obj);
        pattern = "$.store.book[*].available";
        obj = engine.getBooleanMatchPattern(object, (String)pattern);
        System.out.println("JsonObject->Boolean:" + (List)obj);
        pattern = "$.store.book[*].price";
        obj = engine.getNumberMatchPattern(object, (String)pattern);
        System.out.println("JsonObject->Number:" + (List)obj);
        pattern = "$.store.book[*].author";
        obj = engine.getStringMatchPattern(object, (String)pattern);
        System.out.println("JsonObject->String:" + (List)obj);
        pattern = "$.store.book[*]";
        is = JsonPathTest.class.getResourceAsStream(name);
        Object matchPattern = engine.getJsonNodeMatchPattern(is, (String)pattern);
        System.out.println("InputStream->Nodo:" + jsonUtils.toString((JsonNode)matchPattern));
        is = JsonPathTest.class.getResourceAsStream(name);
        JsonNode node = jsonUtils.getAsNode(is);
        Object matchPattern2 = engine.getJsonNodeMatchPattern(node, (String)pattern);
        System.out.println("Nodo->Nodo:" + jsonUtils.toString((JsonNode)matchPattern2));
        is = JsonPathTest.class.getResourceAsStream(name);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        FileSystemUtilities.copy(is, baos);
        matchPattern2 = engine.getJsonNodeMatchPattern(new String(baos.toByteArray()), (String)pattern);
        System.out.println("String->Nodo:" + jsonUtils.toString((JsonNode)matchPattern2));
        pattern = "$.store.book[*].available";
        is = JsonPathTest.class.getResourceAsStream(name);
        matchPattern = engine.getBooleanMatchPattern(is, (String)pattern);
        System.out.println("InputStream->Boolean:" + (List)matchPattern);
        is = JsonPathTest.class.getResourceAsStream(name);
        node = jsonUtils.getAsNode(is);
        matchPattern2 = engine.getBooleanMatchPattern(node, (String)pattern);
        System.out.println("Nodo->Boolean:" + (List)matchPattern2);
        is = JsonPathTest.class.getResourceAsStream(name);
        baos = new ByteArrayOutputStream();
        FileSystemUtilities.copy(is, baos);
        matchPattern2 = engine.getBooleanMatchPattern(new String(baos.toByteArray()), (String)pattern);
        System.out.println("String->Boolean:" + (List)matchPattern2);
        pattern = "$.store.book[*].author";
        is = JsonPathTest.class.getResourceAsStream(name);
        matchPattern = engine.getStringMatchPattern(is, (String)pattern);
        System.out.println("InputStream->String:" + (List)matchPattern);
        is = JsonPathTest.class.getResourceAsStream(name);
        node = jsonUtils.getAsNode(is);
        matchPattern2 = engine.getStringMatchPattern(node, (String)pattern);
        System.out.println("Nodo->String:" + (List)matchPattern2);
        is = JsonPathTest.class.getResourceAsStream(name);
        baos = new ByteArrayOutputStream();
        FileSystemUtilities.copy(is, baos);
        matchPattern2 = engine.getStringMatchPattern(new String(baos.toByteArray()), (String)pattern);
        System.out.println("String->String:" + (List)matchPattern2);
        pattern = "$.store.book[*].price";
        is = JsonPathTest.class.getResourceAsStream(name);
        matchPattern = engine.getNumberMatchPattern(is, (String)pattern);
        System.out.println("InputStream->Number:" + (List)matchPattern);
        is = JsonPathTest.class.getResourceAsStream(name);
        node = jsonUtils.getAsNode(is);
        matchPattern2 = engine.getNumberMatchPattern(node, (String)pattern);
        System.out.println("Nodo->Number:" + (List)matchPattern2);
        is = JsonPathTest.class.getResourceAsStream(name);
        baos = new ByteArrayOutputStream();
        FileSystemUtilities.copy(is, baos);
        matchPattern2 = engine.getNumberMatchPattern(new String(baos.toByteArray()), (String)pattern);
        System.out.println("String->Number:" + (List)matchPattern2);
        pattern = "$.store.book[*]";
        is = JsonPathTest.class.getResourceAsStream(name);
        matchPattern = (JsonNode)engine.getMatchPattern(is, (String)pattern, JsonPathReturnType.NODE);
        System.out.println("(Match pattern) InputStream->Nodo:" + jsonUtils.toString((JsonNode)matchPattern));
        is = JsonPathTest.class.getResourceAsStream(name);
        node = jsonUtils.getAsNode(is);
        matchPattern2 = (JsonNode)engine.getMatchPattern(node, (String)pattern, JsonPathReturnType.NODE);
        System.out.println("(Match pattern) Nodo->Nodo:" + jsonUtils.toString((JsonNode)matchPattern2));
        is = JsonPathTest.class.getResourceAsStream(name);
        baos = new ByteArrayOutputStream();
        FileSystemUtilities.copy(is, baos);
        matchPattern2 = (JsonNode)engine.getMatchPattern(new String(baos.toByteArray()), (String)pattern, JsonPathReturnType.NODE);
        System.out.println("(Match pattern) String->Nodo:" + jsonUtils.toString((JsonNode)matchPattern2));
        pattern = "$.store.book[*].available";
        is = JsonPathTest.class.getResourceAsStream(name);
        matchPattern = (List)engine.getMatchPattern(is, (String)pattern, JsonPathReturnType.BOOLEAN);
        System.out.println("(Match pattern) InputStream->Boolean:" + (List)matchPattern);
        is = JsonPathTest.class.getResourceAsStream(name);
        node = jsonUtils.getAsNode(is);
        matchPattern2 = (List)engine.getMatchPattern(node, (String)pattern, JsonPathReturnType.BOOLEAN);
        System.out.println("(Match pattern) Nodo->Boolean:" + (List)matchPattern2);
        is = JsonPathTest.class.getResourceAsStream(name);
        baos = new ByteArrayOutputStream();
        FileSystemUtilities.copy(is, baos);
        matchPattern2 = (List)engine.getMatchPattern(new String(baos.toByteArray()), (String)pattern, JsonPathReturnType.BOOLEAN);
        System.out.println("(Match pattern) String->Boolean:" + (List)matchPattern2);
        pattern = "$.store.book[*].author";
        is = JsonPathTest.class.getResourceAsStream(name);
        matchPattern = (List)engine.getMatchPattern(is, (String)pattern, JsonPathReturnType.STRING);
        System.out.println("(Match pattern) InputStream->String:" + (List)matchPattern);
        is = JsonPathTest.class.getResourceAsStream(name);
        node = jsonUtils.getAsNode(is);
        matchPattern2 = (List)engine.getMatchPattern(node, (String)pattern, JsonPathReturnType.STRING);
        System.out.println("(Match pattern) Nodo->String:" + (List)matchPattern2);
        is = JsonPathTest.class.getResourceAsStream(name);
        baos = new ByteArrayOutputStream();
        FileSystemUtilities.copy(is, baos);
        matchPattern2 = (List)engine.getMatchPattern(new String(baos.toByteArray()), (String)pattern, JsonPathReturnType.STRING);
        System.out.println("(Match pattern) String->String:" + (List)matchPattern2);
        pattern = "$.store.book[*].price";
        is = JsonPathTest.class.getResourceAsStream(name);
        matchPattern = (List)engine.getMatchPattern(is, (String)pattern, JsonPathReturnType.NUMBER);
        System.out.println("(Match pattern) InputStream->Number:" + (List)matchPattern);
        is = JsonPathTest.class.getResourceAsStream(name);
        node = jsonUtils.getAsNode(is);
        matchPattern2 = (List)engine.getMatchPattern(node, (String)pattern, JsonPathReturnType.NUMBER);
        System.out.println("(Match pattern) Nodo->Number:" + (List)matchPattern2);
        is = JsonPathTest.class.getResourceAsStream(name);
        baos = new ByteArrayOutputStream();
        FileSystemUtilities.copy(is, baos);
        matchPattern2 = (List)engine.getMatchPattern(new String(baos.toByteArray()), (String)pattern, JsonPathReturnType.NUMBER);
        System.out.println("(Match pattern) String->Number:" + (List)matchPattern2);
        String p1 = "$.store.book[0].price";
        String p2 = "$.store.book[0].category";
        pattern = "concat(" + p1 + ",\"#\"," + p2 + ")";
        System.out.println("Test cache disabilita per operazione 'concat': ...");
        InputStream is2 = JsonPathTest.class.getResourceAsStream(name);
        ByteArrayOutputStream baos2 = new ByteArrayOutputStream();
        FileSystemUtilities.copy(is2, baos2);
        String json = baos2.toString();
        String valoreP1 = JsonPathExpressionEngine.extractAndConvertResultAsString(json, p1, LoggerWrapperFactory.getLogger(JsonPathTest.class));
        if (!"8.95".equals(valoreP1)) {
            throw new Exception("Atteso '8.95' trovato '" + valoreP1 + "' nel messaggio json (pattern:" + p1 + "):\n\n" + json);
        }
        String valoreP2 = JsonPathExpressionEngine.extractAndConvertResultAsString(json, p2, LoggerWrapperFactory.getLogger(JsonPathTest.class));
        if (!"reference".equals(valoreP2)) {
            throw new Exception("Atteso 'reference' trovato '" + valoreP2 + "' nel messaggio json (pattern:" + p2 + "):\n\n" + json);
        }
        String s1 = JsonPathExpressionEngine.extractAndConvertResultAsString(json, (String)pattern, LoggerWrapperFactory.getLogger(JsonPathTest.class));
        if (!"8.95#reference".equals(s1)) {
            throw new Exception("Atteso '8.95#reference' trovato '" + s1 + "' nel messaggio json (pattern:" + (String)pattern + "):\n\n" + json);
        }
        json = json.replace("8.95", "1234.77");
        valoreP1 = JsonPathExpressionEngine.extractAndConvertResultAsString(json = json.replace("reference", "altrovalorecasuale"), p1, LoggerWrapperFactory.getLogger(JsonPathTest.class));
        if (!"1234.77".equals(valoreP1)) {
            throw new Exception("Atteso '1234.77' trovato '" + valoreP1 + "' nel messaggio json (pattern:" + p1 + "):\n\n" + json);
        }
        valoreP2 = JsonPathExpressionEngine.extractAndConvertResultAsString(json, p2, LoggerWrapperFactory.getLogger(JsonPathTest.class));
        if (!"altrovalorecasuale".equals(valoreP2)) {
            throw new Exception("Atteso 'altrovalorecasuale' trovato '" + valoreP2 + "' nel messaggio json (pattern:" + p1 + "):\n\n" + json);
        }
        String s2 = JsonPathExpressionEngine.extractAndConvertResultAsString(json, (String)pattern, LoggerWrapperFactory.getLogger(JsonPathTest.class));
        if (!"1234.77#altrovalorecasuale".equals(s2)) {
            throw new Exception("Atteso '1234.77#altrovalorecasuale' trovato '" + s2 + "' nel messaggio json (pattern:" + (String)pattern + "):\n\n" + json);
        }
        System.out.println("Test cache disabilita per operazione 'concat': ok");
        pattern = "$.store.book[*].price";
        System.out.println("Test cache disabilita ...");
        is2 = JsonPathTest.class.getResourceAsStream(name);
        baos2 = new ByteArrayOutputStream();
        FileSystemUtilities.copy(is2, baos2);
        json = baos2.toString();
        valoreP1 = JsonPathExpressionEngine.extractAndConvertResultAsString(json, p1, LoggerWrapperFactory.getLogger(JsonPathTest.class));
        if (!"8.95".equals(valoreP1)) {
            throw new Exception("Atteso '8.95' trovato '" + valoreP1 + "' nel messaggio json:\n\n" + json);
        }
        String s12 = JsonPathExpressionEngine.extractAndConvertResultAsString(json, (String)pattern, LoggerWrapperFactory.getLogger(JsonPathTest.class));
        if (!"8.95,12.99,8.99,22.99".equals(s12)) {
            throw new Exception("Atteso '8.95,12.99,8.99,22.99' trovato '" + s12 + "' nel messaggio json:\n\n" + json);
        }
        String s22 = JsonPathExpressionEngine.extractAndConvertResultAsString(json = json.replace("8.95", "1234.77"), (String)pattern, LoggerWrapperFactory.getLogger(JsonPathTest.class));
        if (!"1234.77,12.99,8.99,22.99".equals(s22)) {
            throw new Exception("Atteso '1234.77,12.99,8.99,22.99' trovato '" + s22 + "' nel messaggio json:\n\n" + json);
        }
        System.out.println("Test cache disabilita ok");
    }

    private static void testSingleInstance() throws Exception {
        String name = "fileNoList.json";
        Object pattern = "$.store.book";
        JsonPathExpressionEngine engine = new JsonPathExpressionEngine();
        JSONUtils jsonUtils = JSONUtils.getInstance();
        InputStream is = JsonPathTest.class.getResourceAsStream(name);
        JSONObject object = JsonPathExpressionEngine.getJSONObject(is);
        Object obj = engine.getJsonNodeMatchPattern(object, (String)pattern);
        System.out.println("JsonObject->Nodo:" + obj);
        pattern = "$.store.book.available";
        obj = engine.getBooleanMatchPattern(object, (String)pattern);
        System.out.println("JsonObject->Boolean:" + (List)obj);
        pattern = "$.store.book.price";
        obj = engine.getNumberMatchPattern(object, (String)pattern);
        System.out.println("JsonObject->Number:" + (List)obj);
        pattern = "$.store.book.author";
        obj = engine.getStringMatchPattern(object, (String)pattern);
        System.out.println("JsonObject->String:" + (List)obj);
        pattern = "$.store.book";
        is = JsonPathTest.class.getResourceAsStream(name);
        Object matchPattern = engine.getJsonNodeMatchPattern(is, (String)pattern);
        System.out.println("InputStream->Nodo:" + jsonUtils.toString((JsonNode)matchPattern));
        is = JsonPathTest.class.getResourceAsStream(name);
        JsonNode node = jsonUtils.getAsNode(is);
        Object matchPattern2 = engine.getJsonNodeMatchPattern(node, (String)pattern);
        System.out.println("Nodo->Nodo:" + jsonUtils.toString((JsonNode)matchPattern2));
        is = JsonPathTest.class.getResourceAsStream(name);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        FileSystemUtilities.copy(is, baos);
        matchPattern2 = engine.getJsonNodeMatchPattern(new String(baos.toByteArray()), (String)pattern);
        System.out.println("String->Nodo:" + jsonUtils.toString((JsonNode)matchPattern2));
        pattern = "$.store.book.available";
        is = JsonPathTest.class.getResourceAsStream(name);
        matchPattern = engine.getBooleanMatchPattern(is, (String)pattern);
        System.out.println("InputStream->Boolean:" + (List)matchPattern);
        is = JsonPathTest.class.getResourceAsStream(name);
        node = jsonUtils.getAsNode(is);
        matchPattern2 = engine.getBooleanMatchPattern(node, (String)pattern);
        System.out.println("Nodo->Boolean:" + (List)matchPattern2);
        is = JsonPathTest.class.getResourceAsStream(name);
        baos = new ByteArrayOutputStream();
        FileSystemUtilities.copy(is, baos);
        matchPattern2 = engine.getBooleanMatchPattern(new String(baos.toByteArray()), (String)pattern);
        System.out.println("String->Boolean:" + (List)matchPattern2);
        pattern = "$.store.book.author";
        is = JsonPathTest.class.getResourceAsStream(name);
        matchPattern = engine.getStringMatchPattern(is, (String)pattern);
        System.out.println("InputStream->String:" + (List)matchPattern);
        is = JsonPathTest.class.getResourceAsStream(name);
        node = jsonUtils.getAsNode(is);
        matchPattern2 = engine.getStringMatchPattern(node, (String)pattern);
        System.out.println("Nodo->String:" + (List)matchPattern2);
        is = JsonPathTest.class.getResourceAsStream(name);
        baos = new ByteArrayOutputStream();
        FileSystemUtilities.copy(is, baos);
        matchPattern2 = engine.getStringMatchPattern(new String(baos.toByteArray()), (String)pattern);
        System.out.println("String->String:" + (List)matchPattern2);
        pattern = "$.store.book.price";
        is = JsonPathTest.class.getResourceAsStream(name);
        matchPattern = engine.getNumberMatchPattern(is, (String)pattern);
        System.out.println("InputStream->Number:" + (List)matchPattern);
        is = JsonPathTest.class.getResourceAsStream(name);
        node = jsonUtils.getAsNode(is);
        matchPattern2 = engine.getNumberMatchPattern(node, (String)pattern);
        System.out.println("Nodo->Number:" + (List)matchPattern2);
        is = JsonPathTest.class.getResourceAsStream(name);
        baos = new ByteArrayOutputStream();
        FileSystemUtilities.copy(is, baos);
        matchPattern2 = engine.getNumberMatchPattern(new String(baos.toByteArray()), (String)pattern);
        System.out.println("String->Number:" + (List)matchPattern2);
        pattern = "$.store.book";
        is = JsonPathTest.class.getResourceAsStream(name);
        matchPattern = (JsonNode)engine.getMatchPattern(is, (String)pattern, JsonPathReturnType.NODE);
        System.out.println("(Match pattern) InputStream->Nodo:" + jsonUtils.toString((JsonNode)matchPattern));
        is = JsonPathTest.class.getResourceAsStream(name);
        node = jsonUtils.getAsNode(is);
        matchPattern2 = (JsonNode)engine.getMatchPattern(node, (String)pattern, JsonPathReturnType.NODE);
        System.out.println("(Match pattern) Nodo->Nodo:" + jsonUtils.toString((JsonNode)matchPattern2));
        is = JsonPathTest.class.getResourceAsStream(name);
        baos = new ByteArrayOutputStream();
        FileSystemUtilities.copy(is, baos);
        matchPattern2 = (JsonNode)engine.getMatchPattern(new String(baos.toByteArray()), (String)pattern, JsonPathReturnType.NODE);
        System.out.println("(Match pattern) String->Nodo:" + jsonUtils.toString((JsonNode)matchPattern2));
        pattern = "$.store.book.available";
        is = JsonPathTest.class.getResourceAsStream(name);
        matchPattern = (List)engine.getMatchPattern(is, (String)pattern, JsonPathReturnType.BOOLEAN);
        System.out.println("(Match pattern) InputStream->Boolean:" + (List)matchPattern);
        is = JsonPathTest.class.getResourceAsStream(name);
        node = jsonUtils.getAsNode(is);
        matchPattern2 = (List)engine.getMatchPattern(node, (String)pattern, JsonPathReturnType.BOOLEAN);
        System.out.println("(Match pattern) Nodo->Boolean:" + (List)matchPattern2);
        is = JsonPathTest.class.getResourceAsStream(name);
        baos = new ByteArrayOutputStream();
        FileSystemUtilities.copy(is, baos);
        matchPattern2 = (List)engine.getMatchPattern(new String(baos.toByteArray()), (String)pattern, JsonPathReturnType.BOOLEAN);
        System.out.println("(Match pattern) String->Boolean:" + (List)matchPattern2);
        pattern = "$.store.book.author";
        is = JsonPathTest.class.getResourceAsStream(name);
        matchPattern = (List)engine.getMatchPattern(is, (String)pattern, JsonPathReturnType.STRING);
        System.out.println("(Match pattern) InputStream->String:" + (List)matchPattern);
        is = JsonPathTest.class.getResourceAsStream(name);
        node = jsonUtils.getAsNode(is);
        matchPattern2 = (List)engine.getMatchPattern(node, (String)pattern, JsonPathReturnType.STRING);
        System.out.println("(Match pattern) Nodo->String:" + (List)matchPattern2);
        is = JsonPathTest.class.getResourceAsStream(name);
        baos = new ByteArrayOutputStream();
        FileSystemUtilities.copy(is, baos);
        matchPattern2 = (List)engine.getMatchPattern(new String(baos.toByteArray()), (String)pattern, JsonPathReturnType.STRING);
        System.out.println("(Match pattern) String->String:" + (List)matchPattern2);
        pattern = "$.store.book.price";
        is = JsonPathTest.class.getResourceAsStream(name);
        matchPattern = (List)engine.getMatchPattern(is, (String)pattern, JsonPathReturnType.NUMBER);
        System.out.println("(Match pattern) InputStream->Number:" + (List)matchPattern);
        is = JsonPathTest.class.getResourceAsStream(name);
        node = jsonUtils.getAsNode(is);
        matchPattern2 = (List)engine.getMatchPattern(node, (String)pattern, JsonPathReturnType.NUMBER);
        System.out.println("(Match pattern) Nodo->Number:" + (List)matchPattern2);
        is = JsonPathTest.class.getResourceAsStream(name);
        baos = new ByteArrayOutputStream();
        FileSystemUtilities.copy(is, baos);
        matchPattern2 = (List)engine.getMatchPattern(new String(baos.toByteArray()), (String)pattern, JsonPathReturnType.NUMBER);
        System.out.println("(Match pattern) String->Number:" + (List)matchPattern2);
        String p1 = "$.store.book.price";
        String p2 = "$.store.book.category";
        pattern = "concat(" + p1 + ",\"#\"," + p2 + ")";
        System.out.println("Test cache disabilita per operazione 'concat': ...");
        InputStream is2 = JsonPathTest.class.getResourceAsStream(name);
        ByteArrayOutputStream baos2 = new ByteArrayOutputStream();
        FileSystemUtilities.copy(is2, baos2);
        String json = baos2.toString();
        String valoreP1 = JsonPathExpressionEngine.extractAndConvertResultAsString(json, p1, LoggerWrapperFactory.getLogger(JsonPathTest.class));
        if (!"8.95".equals(valoreP1)) {
            throw new Exception("Atteso '8.95' trovato '" + valoreP1 + "' nel messaggio json:\n\n" + json);
        }
        String valoreP2 = JsonPathExpressionEngine.extractAndConvertResultAsString(json, p2, LoggerWrapperFactory.getLogger(JsonPathTest.class));
        if (!"reference".equals(valoreP2)) {
            throw new Exception("Atteso 'reference' trovato '" + valoreP2 + "' nel messaggio json:\n\n" + json);
        }
        String s1 = JsonPathExpressionEngine.extractAndConvertResultAsString(json, (String)pattern, LoggerWrapperFactory.getLogger(JsonPathTest.class));
        if (!"8.95#reference".equals(s1)) {
            throw new Exception("Atteso '8.95#reference' trovato '" + s1 + "' nel messaggio json:\n\n" + json);
        }
        json = json.replace("8.95", "1234.77");
        valoreP1 = JsonPathExpressionEngine.extractAndConvertResultAsString(json = json.replace("reference", "altrovalorecasuale"), p1, LoggerWrapperFactory.getLogger(JsonPathTest.class));
        if (!"1234.77".equals(valoreP1)) {
            throw new Exception("Atteso '1234.77' trovato '" + valoreP1 + "' nel messaggio json:\n\n" + json);
        }
        valoreP2 = JsonPathExpressionEngine.extractAndConvertResultAsString(json, p2, LoggerWrapperFactory.getLogger(JsonPathTest.class));
        if (!"altrovalorecasuale".equals(valoreP2)) {
            throw new Exception("Atteso 'altrovalorecasuale' trovato '" + valoreP2 + "' nel messaggio json:\n\n" + json);
        }
        String s2 = JsonPathExpressionEngine.extractAndConvertResultAsString(json, (String)pattern, LoggerWrapperFactory.getLogger(JsonPathTest.class));
        if (!"1234.77#altrovalorecasuale".equals(s2)) {
            throw new Exception("Atteso '1234.77#altrovalorecasuale' trovato '" + s2 + "' nel messaggio json:\n\n" + json);
        }
        System.out.println("Test cache disabilita per operazione 'concat': ok");
        pattern = "$.store.book.price";
        System.out.println("Test cache disabilita ...");
        is2 = JsonPathTest.class.getResourceAsStream(name);
        baos2 = new ByteArrayOutputStream();
        FileSystemUtilities.copy(is2, baos2);
        json = baos2.toString();
        valoreP1 = JsonPathExpressionEngine.extractAndConvertResultAsString(json, p1, LoggerWrapperFactory.getLogger(JsonPathTest.class));
        if (!"8.95".equals(valoreP1)) {
            throw new Exception("Atteso '8.95' trovato '" + valoreP1 + "' nel messaggio json:\n\n" + json);
        }
        String s12 = JsonPathExpressionEngine.extractAndConvertResultAsString(json, (String)pattern, LoggerWrapperFactory.getLogger(JsonPathTest.class));
        if (!"8.95".equals(s12)) {
            throw new Exception("Atteso '8.95' trovato '" + s12 + "' nel messaggio json:\n\n" + json);
        }
        String s22 = JsonPathExpressionEngine.extractAndConvertResultAsString(json = json.replace("8.95", "1234.77"), (String)pattern, LoggerWrapperFactory.getLogger(JsonPathTest.class));
        if (!"1234.77".equals(s22)) {
            throw new Exception("Atteso '1234.77' trovato '" + s22 + "' nel messaggio json:\n\n" + json);
        }
        System.out.println("Test cache disabilita ok");
    }
}

