/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.json.validation;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import net.sf.json.JSONArray;
import org.everit.json.schema.Schema;
import org.everit.json.schema.loader.SchemaLoader;
import org.json.JSONObject;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.json.IJsonSchemaValidator;
import org.openspcoop2.utils.json.JsonSchemaValidatorConfig;
import org.openspcoop2.utils.json.ValidationException;
import org.openspcoop2.utils.json.ValidationResponse;
import org.openspcoop2.utils.json.validation.ValidationUtils;
import org.slf4j.Logger;

public class EveritJsonschemaValidator
implements IJsonSchemaValidator {
    private Schema schema;
    private byte[] schemaBytes;
    private Logger log;
    private boolean logError;

    @Override
    public void setSchema(byte[] schema, JsonSchemaValidatorConfig config, Logger log) throws ValidationException {
        this.log = log;
        if (this.log == null) {
            this.log = LoggerWrapperFactory.getLogger(EveritJsonschemaValidator.class);
        }
        this.logError = config != null ? config.isEmitLogError() : true;
        this.schemaBytes = schema;
        try {
            JSONObject jsonSchemaObject = new JSONObject(new String(schema));
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("type", "string");
            JSONObject jsonStringObject = new JSONObject(map);
            if (config != null) {
                switch (config.getAdditionalProperties()) {
                    case DEFAULT: {
                        break;
                    }
                    case FORCE_DISABLE: {
                        this.addAdditionalProperties(jsonSchemaObject, Boolean.FALSE, true);
                        break;
                    }
                    case FORCE_STRING: {
                        this.addAdditionalProperties(jsonSchemaObject, jsonStringObject, true);
                        break;
                    }
                    case IF_NULL_DISABLE: {
                        this.addAdditionalProperties(jsonSchemaObject, Boolean.FALSE, false);
                        break;
                    }
                    case IF_NULL_STRING: {
                        this.addAdditionalProperties(jsonSchemaObject, jsonStringObject, false);
                        break;
                    }
                }
            }
            if (config != null) {
                switch (config.getPoliticaInclusioneTipi()) {
                    case DEFAULT: {
                        break;
                    }
                    case ALL: {
                        this.addTypes(jsonSchemaObject, config.getTipi(), true);
                        break;
                    }
                    case ANY: {
                        this.addTypes(jsonSchemaObject, config.getTipi(), false);
                        break;
                    }
                }
            }
            this.schema = SchemaLoader.load((JSONObject)jsonSchemaObject);
            if (config != null && config.isVerbose()) {
                try {
                    String debugSchema = jsonSchemaObject.toString();
                    this.log.debug("JSON Schema: " + debugSchema);
                }
                catch (Exception e) {
                    this.log.debug("JSON Schema build error: " + e.getMessage(), (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            throw new ValidationException(e);
        }
    }

    private void addTypes(JSONObject jsonSchemaObject, List<String> nomi, boolean all) {
        String allAny = all ? "allOf" : "anyOf";
        JSONArray array = new JSONArray();
        for (String nome : nomi) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("$ref", nome);
            JSONObject obj = new JSONObject(map);
            array.element((Object)obj);
        }
        jsonSchemaObject.remove("anyOf");
        jsonSchemaObject.remove("allOf");
        jsonSchemaObject.put(allAny, (Collection)array);
    }

    private void addAdditionalProperties(JSONObject jsonSchemaObject, Object additionalPropertiesObject, boolean force) {
        JSONObject definitions = (JSONObject)jsonSchemaObject.get("definitions");
        for (String def : definitions.keySet()) {
            JSONObject definition = (JSONObject)definitions.get(def);
            if (!force && definition.has("additionalProperties")) continue;
            definition.put("additionalProperties", additionalPropertiesObject);
        }
    }

    @Override
    public ValidationResponse validate(byte[] object) throws ValidationException {
        ValidationResponse response = new ValidationResponse();
        try {
            JSONObject jsonObject = null;
            try {
                jsonObject = new JSONObject(new String(object));
            }
            catch (Exception e) {
                this.log.error(e.getMessage(), (Throwable)e);
                String messageString = "Read rawObject as jsonObject failed: " + e.getMessage();
                response.setEsito(ValidationResponse.ESITO.KO);
                if (this.logError) {
                    ValidationUtils.logError(this.log, messageString.toString(), object, this.schemaBytes, null);
                }
                response.setException(new Exception(messageString.toString()));
            }
            if (jsonObject != null) {
                try {
                    this.schema.validate((Object)jsonObject);
                    response.setEsito(ValidationResponse.ESITO.OK);
                }
                catch (org.everit.json.schema.ValidationException e) {
                    response.setEsito(ValidationResponse.ESITO.KO);
                    response.setException((Exception)((Object)e));
                    response.getErrors().add(e.getErrorMessage());
                    if (this.logError) {
                        ValidationUtils.logError(this.log, e.getErrorMessage(), object, this.schemaBytes, null);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new ValidationException(e);
        }
        return response;
    }
}

