/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.json.validation;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.json.JSONUtils;
import org.slf4j.Logger;

public class ValidationUtils {
    public static void logError(Logger log, String msg, byte[] rawObject, byte[] schemaBytes, JsonNode jsonSchema) {
        ByteArrayOutputStream bout;
        if (log == null) {
            return;
        }
        int max100KB = 102400;
        JSONUtils jsonUtils = JSONUtils.getInstance(true);
        StringBuilder sb = new StringBuilder();
        sb.append("Validation error: ").append(msg);
        if (rawObject != null) {
            sb.append("\nMessage: ");
            if (rawObject.length < max100KB) {
                try {
                    bout = new ByteArrayOutputStream();
                    jsonUtils.writeTo(jsonUtils.getAsNode(rawObject), (OutputStream)bout);
                    bout.flush();
                    bout.close();
                    sb.append("\n").append(bout.toString());
                }
                catch (Exception e) {
                    sb.append("\n").append(new String(rawObject));
                }
            } else {
                sb.append("too large for debug (" + Utilities.convertBytesToFormatString(rawObject.length) + ")");
            }
        }
        if (schemaBytes != null) {
            sb.append("\nSchema: ");
            if (schemaBytes.length < max100KB) {
                try {
                    bout = new ByteArrayOutputStream();
                    if (jsonSchema != null) {
                        jsonUtils.writeTo(jsonSchema, (OutputStream)bout);
                    } else {
                        jsonUtils.writeTo(jsonUtils.getAsNode(schemaBytes), (OutputStream)bout);
                    }
                    bout.flush();
                    bout.close();
                    sb.append("\n").append(bout.toString());
                }
                catch (Exception e) {
                    sb.append("\n").append(new String(schemaBytes));
                }
            } else {
                sb.append("too large for debug (" + Utilities.convertBytesToFormatString(schemaBytes.length) + ")");
            }
        }
        log.error(sb.toString());
    }

    public static void disableAdditionalProperties(ObjectMapper mapper, JsonNode jsonSchemaObject, boolean booleanType, boolean force) {
        JsonNode definitions = jsonSchemaObject.get("definitions");
        BooleanNode booleanFalseNode = null;
        BooleanNode booleanTrueNode = null;
        ObjectNode jsonStringTypeNode = null;
        if (booleanType) {
            booleanFalseNode = mapper.getNodeFactory().booleanNode(false);
            booleanTrueNode = mapper.getNodeFactory().booleanNode(true);
        } else {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("type", "string");
            jsonStringTypeNode = mapper.getNodeFactory().objectNode();
            jsonStringTypeNode.set("type", (JsonNode)mapper.getNodeFactory().textNode("string"));
        }
        for (ObjectNode definition : definitions) {
            JsonNode allOfNode;
            boolean allOf = definition.has("allOf");
            boolean hasAdditionalProperties = definition.has("additionalProperties");
            if (!force && hasAdditionalProperties) continue;
            definition.set("additionalProperties", (JsonNode)(booleanType ? booleanFalseNode : jsonStringTypeNode));
            if (!allOf || (allOfNode = definition.get("allOf")) == null || !(allOfNode instanceof ArrayNode)) continue;
            ArrayNode allOfArrayNode = (ArrayNode)allOfNode;
            for (int i = 0; i < allOfArrayNode.size(); ++i) {
                ObjectNode oChild;
                boolean ref;
                JsonNode child = allOfArrayNode.get(i);
                if (!(child instanceof ObjectNode) || (ref = (oChild = (ObjectNode)child).has("$ref"))) continue;
                boolean hasAdditionalPropertiesChild = oChild.has("additionalProperties");
                if (!force && hasAdditionalPropertiesChild) continue;
                oChild.set("additionalProperties", (JsonNode)booleanTrueNode);
            }
        }
    }

    public static void addTypes(ObjectMapper mapper, JsonNode jsonSchemaObject, List<String> nomi, boolean all) {
        String allAny = all ? "allOf" : "anyOf";
        ArrayNode array = mapper.getNodeFactory().arrayNode();
        for (String nome : nomi) {
            array.add((JsonNode)mapper.getNodeFactory().objectNode().put("$ref", nome));
        }
        ((ObjectNode)jsonSchemaObject).remove("allOf");
        ((ObjectNode)jsonSchemaObject).remove("anyOf");
        ((ObjectNode)jsonSchemaObject).set(allAny, (JsonNode)array);
    }
}

