/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.mime;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;

public class MultipartUtils {
    private MultipartUtils() {
    }

    public static String findBoundary(byte[] input) {
        ByteArrayOutputStream boundary = null;
        try {
            boundary = new ByteArrayOutputStream();
            for (int i = 0; i < input.length; ++i) {
                if (input[i] != 10) {
                    boundary.write(input[i]);
                }
                if (input[i] != 10 && i != input.length) continue;
                if (boundary.toString().startsWith("--")) break;
                boundary.reset();
            }
            boundary.flush();
            boundary.close();
            return MultipartUtils.getBoundary(boundary);
        }
        catch (Exception e) {
            try {
                if (boundary != null) {
                    boundary.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }
    }

    private static String getBoundary(ByteArrayOutputStream boundary) {
        String bS = null;
        if (boundary.size() != 0) {
            bS = boundary.toString();
        }
        return bS;
    }

    public static String findBoundary(InputStream input) {
        ByteArrayOutputStream boundary = null;
        try {
            boundary = new ByteArrayOutputStream();
            byte date = 0;
            while ((date = (byte)input.read()) != -1) {
                boundary.write(date);
                if ((char)date != '\n') continue;
                if (boundary.toString().startsWith("--")) break;
                boundary.reset();
            }
            String bS = null;
            if (boundary.size() != 0) {
                bS = boundary.toString().substring(0, boundary.toString().length() - 2);
            }
            boundary.close();
            return bS;
        }
        catch (Exception e) {
            try {
                if (boundary != null) {
                    boundary.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }
    }

    public static boolean messageWithAttachment(byte[] input) {
        if (input.length < 10) {
            return false;
        }
        for (int i = 0; i < 9; ++i) {
            if ((char)input[i] == '-' && (char)input[i + 1] == '-') {
                return true;
            }
            if ((char)input[i] != '<') continue;
            return false;
        }
        return false;
    }

    public static String firstContentID(byte[] input) {
        ByteArrayOutputStream line = null;
        try {
            String idfirst = null;
            int index = 0;
            boolean found = false;
            while (!found && index < input.length) {
                line = new ByteArrayOutputStream();
                index = MultipartUtils.readLineFirstContentID(input, line, index);
                if (line.toString().toLowerCase().startsWith("Content-Id:".toLowerCase())) {
                    found = true;
                    String[] rr = line.toString().split(" ");
                    idfirst = rr[1];
                }
                line.close();
            }
            return idfirst;
        }
        catch (Exception e) {
            try {
                if (line != null) {
                    line.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }
    }

    private static int readLineFirstContentID(byte[] input, ByteArrayOutputStream line, int index) {
        while (true) {
            if (input[index] == 13) {
                if (input[++index] != 10) break;
                ++index;
                break;
            }
            line.write(input[index]);
            ++index;
        }
        return index;
    }
}

