/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.oauth2;

import java.io.IOException;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.utils.oauth2.OAuth2Token;
import org.openspcoop2.utils.oauth2.OAuth2Utilities;
import org.openspcoop2.utils.oauth2.Oauth2BaseResponse;
import org.openspcoop2.utils.oauth2.Oauth2Exception;
import org.openspcoop2.utils.oauth2.Oauth2UserInfo;
import org.slf4j.Logger;

public abstract class BaseOAuth2CallbackServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;

    protected BaseOAuth2CallbackServlet() {
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.engineDoGet(request, response, this.getLog(), this.getLoginProperties());
    }

    private void engineDoGet(HttpServletRequest request, HttpServletResponse response, Logger log, Properties loginProperties) {
        HttpSession session = request.getSession(false);
        try {
            OAuth2Token oAuth2Token;
            String code = this.validaParametriRichiesta(request, session);
            String codeVerifier = null;
            if (session != null && OAuth2Utilities.isPkceEnabled(loginProperties)) {
                codeVerifier = (String)session.getAttribute("oauth2code_verifier");
                session.removeAttribute("oauth2code_verifier");
            }
            if ((oAuth2Token = OAuth2Utilities.getToken(log, loginProperties, code, codeVerifier)).getReturnCode() != 200) {
                throw new Oauth2Exception(oAuth2Token.getError(), oAuth2Token.getDescription());
            }
            Oauth2BaseResponse jwksResponse = OAuth2Utilities.getCertificati(log, loginProperties);
            if (jwksResponse.getReturnCode() != 200) {
                throw new Oauth2Exception(jwksResponse.getError(), jwksResponse.getDescription());
            }
            boolean valida = OAuth2Utilities.isValidToken(log, loginProperties, jwksResponse, oAuth2Token);
            if (!valida) {
                OAuth2Utilities.logError(log, "Token ricevuto non valido");
                throw new Oauth2Exception("Token ricevuto non valido", "Impossibile autenticare l'utente: Token ricevuto non valido");
            }
            Oauth2UserInfo oauth2UserInfo = OAuth2Utilities.getUserInfo(log, loginProperties, oAuth2Token);
            if (oauth2UserInfo.getReturnCode() != 200) {
                throw new Oauth2Exception(oauth2UserInfo.getError(), oauth2UserInfo.getDescription());
            }
            session = request.getSession(true);
            session.setAttribute("oauthAccessToken", (Object)oAuth2Token.getAccessToken());
            session.setAttribute("oauthIdToken", (Object)oAuth2Token.getIdToken());
            session.setAttribute("oauthTokenObj", (Object)oAuth2Token);
            session.setAttribute("oauthRefreshToken", (Object)oAuth2Token.getRefreshToken());
            session.setAttribute("oauthExpiresAt", (Object)oAuth2Token.getExpiresAt());
            session.setAttribute("oauth2UserInfo", (Object)oauth2UserInfo);
            response.sendRedirect(this.getConsoleHome(request));
        }
        catch (IOException e) {
            log.error("Errore durante lo scambio del token OAuth2: " + e.getMessage(), (Throwable)e);
            response.setStatus(503);
            try {
                response.getWriter().write("Autenticazione Oauth2 non disponibile: si e' verificato un'errore durante lo scambio del token OAuth2: " + e.getMessage());
            }
            catch (IOException e1) {
                log.error("Errore durante lo scambio del token OAuth2: " + e1.getMessage(), (Throwable)e1);
            }
        }
        catch (Oauth2Exception e) {
            OAuth2Utilities.logError(log, e.getErrorCode() + ": " + e.getErrorDetail());
            request.setAttribute("oauth2ErrorCode", (Object)e.getErrorCode());
            request.setAttribute("oauth2ErrorDetail", (Object)e.getErrorDetail());
            request.setAttribute("principalErrorMsg", (Object)e.getErrorDetail());
            String redirectUrl = this.getConsoleError(request);
            if (session != null) {
                session.setAttribute("principalErrorMsg", (Object)e.getErrorDetail());
                String idToken = (String)session.getAttribute("oauthIdToken");
                String oauth2LogoutUrl = loginProperties.getProperty("oauth2.logout.endpoint");
                if (idToken != null) {
                    redirectUrl = OAuth2Utilities.creaUrlLogout(idToken, oauth2LogoutUrl, redirectUrl);
                }
            }
            try {
                response.sendRedirect(redirectUrl);
            }
            catch (IOException e1) {
                log.error("Errore durante esecuzione redirect: " + e1.getMessage(), (Throwable)e1);
            }
        }
    }

    private String validaParametriRichiesta(HttpServletRequest request, HttpSession session) throws Oauth2Exception {
        String code = request.getParameter("code");
        String state = request.getParameter("state");
        String error = request.getParameter("error");
        if (error != null) {
            throw new Oauth2Exception("401", "Accesso OAuth2 negato o errore: " + error);
        }
        if (code == null || code.isEmpty()) {
            throw new Oauth2Exception("400", "Parametro 'code' mancante.");
        }
        if (StringUtils.isNotBlank((CharSequence)state)) {
            String stateFromSession;
            String string = stateFromSession = session != null ? (String)session.getAttribute("oauth2state") : null;
            if (StringUtils.isBlank((CharSequence)stateFromSession) || !stateFromSession.equals(state)) {
                throw new Oauth2Exception("400", "Parametro 'state' non valido.");
            }
        }
        return code;
    }

    protected abstract Logger getLog();

    protected abstract Properties getLoginProperties();

    protected abstract String getConsoleHome(HttpServletRequest var1);

    protected abstract String getConsoleError(HttpServletRequest var1);
}

